/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.junit;

import java.text.ParseException;
import java.util.Calendar;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.apache.ws.jaxme.xs.util.XsDateFormat;
import org.apache.ws.jaxme.xs.util.XsDateTimeFormat;
import org.apache.ws.jaxme.xs.util.XsTimeFormat;

public class FormatTest
extends TestCase {
    public FormatTest(String pName) {
        super(pName);
    }

    private Calendar getCalendar(TimeZone pTimeZone) {
        Calendar cal = Calendar.getInstance(pTimeZone);
        cal.set(2004, 1, 14, 3, 12, 7);
        cal.set(14, 0);
        return cal;
    }

    public void testFormatDateTime() {
        Calendar cal = this.getCalendar(TimeZone.getTimeZone("GMT"));
        FormatTest.assertEquals((int)0, (int)cal.get(14));
        XsDateTimeFormat format = new XsDateTimeFormat();
        String got = format.format(cal);
        String expect = "2004-01-14T03:12:07Z";
        FormatTest.assertEquals((Object)expect, (Object)got);
        cal = this.getCalendar(TimeZone.getTimeZone("GMT-03:00"));
        FormatTest.assertEquals((int)0, (int)cal.get(14));
        got = format.format(cal);
        expect = "2004-01-14T03:12:07-03:00";
        FormatTest.assertEquals((Object)expect, (Object)got);
    }

    public void testParseDateTime() throws ParseException {
        Calendar got;
        String[] dateTimes = new String[]{"2004-01-14T03:12:07.000Z", "2004-01-14T03:12:07", "2004-01-14T03:12:07-00:00", "2004-01-14T03:12:07+00:00"};
        XsDateTimeFormat format = new XsDateTimeFormat();
        Calendar expect = this.getCalendar(TimeZone.getTimeZone("GMT"));
        for (int i = 0; i < dateTimes.length; ++i) {
            got = (Calendar)format.parseObject(dateTimes[0]);
            FormatTest.assertEquals((long)expect.getTimeInMillis(), (long)got.getTimeInMillis());
        }
        String dateTime = "2004-01-14T03:12:07.000-03:00";
        expect = this.getCalendar(TimeZone.getTimeZone("GMT-03:00"));
        got = (Calendar)format.parseObject(dateTime);
        FormatTest.assertEquals((long)expect.getTimeInMillis(), (long)got.getTimeInMillis());
    }

    public void testFormatDate() {
        Calendar cal = this.getCalendar(TimeZone.getTimeZone("GMT"));
        FormatTest.assertEquals((int)0, (int)cal.get(14));
        XsDateFormat format = new XsDateFormat();
        String got = format.format(cal);
        String expect = "2004-01-14Z";
        FormatTest.assertEquals((Object)expect, (Object)got);
        cal = this.getCalendar(TimeZone.getTimeZone("GMT-03:00"));
        FormatTest.assertEquals((int)0, (int)cal.get(14));
        got = format.format(cal);
        expect = "2004-01-14-03:00";
        FormatTest.assertEquals((Object)expect, (Object)got);
    }

    protected void assertEqualDate(Calendar pExpect, Calendar pGot) {
        FormatTest.assertEquals((int)pExpect.get(1), (int)pGot.get(1));
        FormatTest.assertEquals((int)pExpect.get(2), (int)pGot.get(2));
        FormatTest.assertEquals((int)pExpect.get(5), (int)pGot.get(5));
        FormatTest.assertEquals((Object)pExpect.getTimeZone(), (Object)pGot.getTimeZone());
    }

    protected void assertEqualTime(Calendar pExpect, Calendar pGot) {
        FormatTest.assertEquals((int)pExpect.get(11), (int)pGot.get(11));
        FormatTest.assertEquals((int)pExpect.get(12), (int)pGot.get(12));
        FormatTest.assertEquals((int)pExpect.get(13), (int)pGot.get(13));
        FormatTest.assertEquals((int)pExpect.get(14), (int)pGot.get(14));
        FormatTest.assertEquals((Object)pExpect.getTimeZone(), (Object)pGot.getTimeZone());
    }

    public void testParseDate() throws ParseException {
        Calendar got;
        String[] dateTimes = new String[]{"2004-01-14Z", "2004-01-14", "2004-01-14+00:00", "2004-01-14-00:00"};
        XsDateFormat format = new XsDateFormat();
        Calendar expect = this.getCalendar(TimeZone.getTimeZone("GMT"));
        for (int i = 0; i < dateTimes.length; ++i) {
            got = (Calendar)format.parseObject(dateTimes[0]);
            this.assertEqualDate(expect, got);
        }
        String dateTime = "2004-01-14-03:00";
        expect = this.getCalendar(TimeZone.getTimeZone("GMT-03:00"));
        got = (Calendar)format.parseObject(dateTime);
        this.assertEqualDate(expect, got);
    }

    public void testFormatTime() {
        Calendar cal = this.getCalendar(TimeZone.getTimeZone("GMT"));
        FormatTest.assertEquals((int)0, (int)cal.get(14));
        XsTimeFormat format = new XsTimeFormat();
        String got = format.format(cal);
        String expect = "03:12:07Z";
        FormatTest.assertEquals((Object)expect, (Object)got);
        cal = this.getCalendar(TimeZone.getTimeZone("GMT-03:00"));
        FormatTest.assertEquals((int)0, (int)cal.get(14));
        got = format.format(cal);
        expect = "03:12:07-03:00";
        FormatTest.assertEquals((Object)expect, (Object)got);
    }

    public void testParseTime() throws ParseException {
        Calendar got;
        String[] dateTimes = new String[]{"03:12:07.000Z", "03:12:07", "03:12:07-00:00", "03:12:07+00:00"};
        XsTimeFormat format = new XsTimeFormat();
        Calendar expect = this.getCalendar(TimeZone.getTimeZone("GMT"));
        for (int i = 0; i < dateTimes.length; ++i) {
            got = (Calendar)format.parseObject(dateTimes[0]);
            this.assertEqualTime(expect, got);
        }
        String dateTime = "03:12:07.000-03:00";
        expect = this.getCalendar(TimeZone.getTimeZone("GMT-03:00"));
        got = (Calendar)format.parseObject(dateTime);
        this.assertEqualTime(expect, got);
    }
}

