/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.workers;

import android.content.Context;
import android.os.Build;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.WorkerParameters;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.constraints.ConstraintsState;
import androidx.work.impl.constraints.OnConstraintsStateChangedListener;
import androidx.work.impl.constraints.WorkConstraintsTracker;
import androidx.work.impl.constraints.WorkConstraintsTrackerKt;
import androidx.work.impl.constraints.trackers.Trackers;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.utils.SynchronousExecutor;
import androidx.work.impl.utils.futures.SettableFuture;
import androidx.work.impl.workers.ConstraintTrackingWorkerKt;
import com.google.common.util.concurrent.ListenableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u001dH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u00018G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR2\u0010\u000e\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010 \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/work/impl/workers/ConstraintTrackingWorker;", "Landroidx/work/ListenableWorker;", "Landroidx/work/impl/constraints/OnConstraintsStateChangedListener;", "appContext", "Landroid/content/Context;", "workerParameters", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "areConstraintsUnmet", "", "<set-?>", "delegate", "getDelegate", "()Landroidx/work/ListenableWorker;", "future", "Landroidx/work/impl/utils/futures/SettableFuture;", "Landroidx/work/ListenableWorker$Result;", "kotlin.jvm.PlatformType", "lock", "", "onConstraintsStateChanged", "", "workSpec", "Landroidx/work/impl/model/WorkSpec;", "state", "Landroidx/work/impl/constraints/ConstraintsState;", "onStopped", "setupAndRunConstraintTrackingWork", "startWork", "Lcom/google/common/util/concurrent/ListenableFuture;", "work-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nConstraintTrackingWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstraintTrackingWorker.kt\nandroidx/work/impl/workers/ConstraintTrackingWorker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1#2:168\n*E\n"})
public final class ConstraintTrackingWorker
extends ListenableWorker
implements OnConstraintsStateChangedListener {
    @NotNull
    private final WorkerParameters workerParameters;
    @NotNull
    private final Object lock;
    private volatile boolean areConstraintsUnmet;
    private final SettableFuture<ListenableWorker.Result> future;
    @Nullable
    private ListenableWorker delegate;

    public ConstraintTrackingWorker(@NotNull Context appContext, @NotNull WorkerParameters workerParameters) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)workerParameters, (String)"workerParameters");
        super(appContext, workerParameters);
        this.workerParameters = workerParameters;
        this.lock = new Object();
        this.future = SettableFuture.create();
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final ListenableWorker getDelegate() {
        return this.delegate;
    }

    @Override
    @NotNull
    public ListenableFuture<ListenableWorker.Result> startWork() {
        this.getBackgroundExecutor().execute(() -> ConstraintTrackingWorker.startWork$lambda$0(this));
        SettableFuture<ListenableWorker.Result> settableFuture = this.future;
        Intrinsics.checkNotNullExpressionValue(settableFuture, (String)"future");
        return settableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setupAndRunConstraintTrackingWork() {
        if (this.future.isCancelled()) {
            return;
        }
        String className = this.getInputData().getString("androidx.work.impl.workers.ConstraintTrackingWorker.ARGUMENT_CLASS_NAME");
        Logger logger = Logger.get();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"get()");
        Logger logger2 = logger;
        CharSequence charSequence = className;
        if (charSequence == null || charSequence.length() == 0) {
            logger2.error(ConstraintTrackingWorkerKt.access$getTAG$p(), "No worker to delegate to.");
            SettableFuture<ListenableWorker.Result> settableFuture = this.future;
            Intrinsics.checkNotNullExpressionValue(settableFuture, (String)"future");
            ConstraintTrackingWorkerKt.access$setFailed(settableFuture);
            return;
        }
        this.delegate = this.getWorkerFactory().createWorkerWithDefaultFallback(this.getApplicationContext(), className, this.workerParameters);
        if (this.delegate == null) {
            logger2.debug(ConstraintTrackingWorkerKt.access$getTAG$p(), "No worker to delegate to.");
            SettableFuture<ListenableWorker.Result> settableFuture = this.future;
            Intrinsics.checkNotNullExpressionValue(settableFuture, (String)"future");
            ConstraintTrackingWorkerKt.access$setFailed(settableFuture);
            return;
        }
        WorkManagerImpl workManagerImpl = WorkManagerImpl.getInstance(this.getApplicationContext());
        Intrinsics.checkNotNullExpressionValue((Object)workManagerImpl, (String)"getInstance(applicationContext)");
        WorkManagerImpl workManagerImpl2 = workManagerImpl;
        WorkSpecDao workSpecDao = workManagerImpl2.getWorkDatabase().workSpecDao();
        String string = this.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id.toString()");
        WorkSpec workSpec = workSpecDao.getWorkSpec(string);
        if (workSpec == null) {
            SettableFuture<ListenableWorker.Result> settableFuture = this.future;
            Intrinsics.checkNotNullExpressionValue(settableFuture, (String)"future");
            ConstraintTrackingWorkerKt.access$setFailed(settableFuture);
            return;
        }
        Trackers trackers = workManagerImpl2.getTrackers();
        Intrinsics.checkNotNullExpressionValue((Object)trackers, (String)"workManagerImpl.trackers");
        WorkConstraintsTracker workConstraintsTracker = new WorkConstraintsTracker(trackers);
        CoroutineDispatcher coroutineDispatcher = workManagerImpl2.getWorkTaskExecutor().getTaskCoroutineDispatcher();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineDispatcher, (String)"workManagerImpl.workTask\u2026r.taskCoroutineDispatcher");
        CoroutineDispatcher dispatcher = coroutineDispatcher;
        Job job = WorkConstraintsTrackerKt.listen(workConstraintsTracker, workSpec, dispatcher, this);
        this.future.addListener(() -> ConstraintTrackingWorker.setupAndRunConstraintTrackingWork$lambda$1(job), new SynchronousExecutor());
        if (workConstraintsTracker.areAllConstraintsMet(workSpec)) {
            logger2.debug(ConstraintTrackingWorkerKt.access$getTAG$p(), "Constraints met for delegate " + className);
            try {
                ListenableWorker listenableWorker = this.delegate;
                Intrinsics.checkNotNull((Object)listenableWorker);
                ListenableFuture<ListenableWorker.Result> listenableFuture = listenableWorker.startWork();
                Intrinsics.checkNotNullExpressionValue(listenableFuture, (String)"delegate!!.startWork()");
                ListenableFuture<ListenableWorker.Result> innerFuture = listenableFuture;
                innerFuture.addListener(() -> ConstraintTrackingWorker.setupAndRunConstraintTrackingWork$lambda$3(this, innerFuture), this.getBackgroundExecutor());
            }
            catch (Throwable exception) {
                logger2.debug(ConstraintTrackingWorkerKt.access$getTAG$p(), "Delegated worker " + className + " threw exception in startWork.", exception);
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    if (this.areConstraintsUnmet) {
                        logger2.debug(ConstraintTrackingWorkerKt.access$getTAG$p(), "Constraints were unmet, Retrying.");
                        SettableFuture<ListenableWorker.Result> settableFuture = this.future;
                        Intrinsics.checkNotNullExpressionValue(settableFuture, (String)"future");
                        bl = ConstraintTrackingWorkerKt.access$setRetry(settableFuture);
                    } else {
                        SettableFuture<ListenableWorker.Result> settableFuture = this.future;
                        Intrinsics.checkNotNullExpressionValue(settableFuture, (String)"future");
                        bl = ConstraintTrackingWorkerKt.access$setFailed(settableFuture);
                    }
                    boolean bl3 = bl;
                }
            }
        } else {
            logger2.debug(ConstraintTrackingWorkerKt.access$getTAG$p(), "Constraints not met for delegate " + className + ". Requesting retry.");
            SettableFuture<ListenableWorker.Result> settableFuture = this.future;
            Intrinsics.checkNotNullExpressionValue(settableFuture, (String)"future");
            ConstraintTrackingWorkerKt.access$setRetry(settableFuture);
        }
    }

    @Override
    public void onStopped() {
        super.onStopped();
        ListenableWorker delegateInner = this.delegate;
        if (delegateInner != null && !delegateInner.isStopped()) {
            int reason = Build.VERSION.SDK_INT >= 31 ? this.getStopReason() : 0;
            delegateInner.stop(reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConstraintsStateChanged(@NotNull WorkSpec workSpec, @NotNull ConstraintsState state) {
        Intrinsics.checkNotNullParameter((Object)workSpec, (String)"workSpec");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Logger.get().debug(ConstraintTrackingWorkerKt.access$getTAG$p(), "Constraints changed for " + workSpec);
        if (state instanceof ConstraintsState.ConstraintsNotMet) {
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                this.areConstraintsUnmet = true;
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private static final void startWork$lambda$0(ConstraintTrackingWorker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.setupAndRunConstraintTrackingWork();
    }

    private static final void setupAndRunConstraintTrackingWork$lambda$1(Job $job) {
        Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
        $job.cancel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setupAndRunConstraintTrackingWork$lambda$3(ConstraintTrackingWorker this$0, ListenableFuture $innerFuture) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$innerFuture, (String)"$innerFuture");
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            if (this$0.areConstraintsUnmet) {
                SettableFuture<ListenableWorker.Result> settableFuture = this$0.future;
                Intrinsics.checkNotNullExpressionValue(settableFuture, (String)"future");
                ConstraintTrackingWorkerKt.access$setRetry(settableFuture);
            } else {
                this$0.future.setFuture((ListenableFuture<ListenableWorker.Result>)$innerFuture);
            }
            Unit unit = Unit.INSTANCE;
        }
    }
}

