/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemjob;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.os.Build;
import android.os.PersistableBundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Consumer;
import androidx.work.Configuration;
import androidx.work.Logger;
import androidx.work.OutOfQuotaPolicy;
import androidx.work.WorkInfo;
import androidx.work.impl.Scheduler;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.background.systemjob.SystemJobInfoConverter;
import androidx.work.impl.background.systemjob.SystemJobService;
import androidx.work.impl.model.SystemIdInfo;
import androidx.work.impl.model.SystemIdInfoKt;
import androidx.work.impl.model.WorkGenerationalId;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.model.WorkSpecKt;
import androidx.work.impl.utils.IdGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=23)
public class SystemJobScheduler
implements Scheduler {
    private static final String TAG = Logger.tagWithPrefix("SystemJobScheduler");
    private final Context mContext;
    private final JobScheduler mJobScheduler;
    private final SystemJobInfoConverter mSystemJobInfoConverter;
    private final WorkDatabase mWorkDatabase;
    private final Configuration mConfiguration;

    public SystemJobScheduler(@NonNull Context context, @NonNull WorkDatabase workDatabase, @NonNull Configuration configuration) {
        this(context, workDatabase, configuration, (JobScheduler)context.getSystemService("jobscheduler"), new SystemJobInfoConverter(context, configuration.getClock()));
    }

    @VisibleForTesting
    public SystemJobScheduler(@NonNull Context context, @NonNull WorkDatabase workDatabase, @NonNull Configuration configuration, @NonNull JobScheduler jobScheduler, @NonNull SystemJobInfoConverter systemJobInfoConverter) {
        this.mContext = context;
        this.mJobScheduler = jobScheduler;
        this.mSystemJobInfoConverter = systemJobInfoConverter;
        this.mWorkDatabase = workDatabase;
        this.mConfiguration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(WorkSpec ... workSpecs) {
        IdGenerator idGenerator = new IdGenerator(this.mWorkDatabase);
        for (WorkSpec workSpec : workSpecs) {
            this.mWorkDatabase.beginTransaction();
            try {
                List<Integer> jobIds;
                int jobId;
                WorkSpec currentDbWorkSpec = this.mWorkDatabase.workSpecDao().getWorkSpec(workSpec.id);
                if (currentDbWorkSpec == null) {
                    Logger.get().warning(TAG, "Skipping scheduling " + workSpec.id + " because it's no longer in the DB");
                    this.mWorkDatabase.setTransactionSuccessful();
                    continue;
                }
                if (currentDbWorkSpec.state != WorkInfo.State.ENQUEUED) {
                    Logger.get().warning(TAG, "Skipping scheduling " + workSpec.id + " because it is no longer enqueued");
                    this.mWorkDatabase.setTransactionSuccessful();
                    continue;
                }
                WorkGenerationalId generationalId = WorkSpecKt.generationalId(workSpec);
                SystemIdInfo info = this.mWorkDatabase.systemIdInfoDao().getSystemIdInfo(generationalId);
                int n = jobId = info != null ? info.systemId : idGenerator.nextJobSchedulerIdWithRange(this.mConfiguration.getMinJobSchedulerId(), this.mConfiguration.getMaxJobSchedulerId());
                if (info == null) {
                    SystemIdInfo newSystemIdInfo = SystemIdInfoKt.systemIdInfo(generationalId, jobId);
                    this.mWorkDatabase.systemIdInfoDao().insertSystemIdInfo(newSystemIdInfo);
                }
                this.scheduleInternal(workSpec, jobId);
                if (Build.VERSION.SDK_INT == 23 && (jobIds = SystemJobScheduler.getPendingJobIds(this.mContext, this.mJobScheduler, workSpec.id)) != null) {
                    int index = jobIds.indexOf(jobId);
                    if (index >= 0) {
                        jobIds.remove(index);
                    }
                    int nextJobId = !jobIds.isEmpty() ? jobIds.get(0).intValue() : idGenerator.nextJobSchedulerIdWithRange(this.mConfiguration.getMinJobSchedulerId(), this.mConfiguration.getMaxJobSchedulerId());
                    this.scheduleInternal(workSpec, nextJobId);
                }
                this.mWorkDatabase.setTransactionSuccessful();
            }
            finally {
                this.mWorkDatabase.endTransaction();
            }
        }
    }

    @VisibleForTesting
    public void scheduleInternal(@NonNull WorkSpec workSpec, int jobId) {
        JobInfo jobInfo = this.mSystemJobInfoConverter.convert(workSpec, jobId);
        Logger.get().debug(TAG, "Scheduling work ID " + workSpec.id + "Job ID " + jobId);
        try {
            int result = this.mJobScheduler.schedule(jobInfo);
            if (result == 0) {
                Logger.get().warning(TAG, "Unable to schedule work ID " + workSpec.id);
                if (workSpec.expedited && workSpec.outOfQuotaPolicy == OutOfQuotaPolicy.RUN_AS_NON_EXPEDITED_WORK_REQUEST) {
                    workSpec.expedited = false;
                    String message = String.format("Scheduling a non-expedited job (work ID %s)", workSpec.id);
                    Logger.get().debug(TAG, message);
                    this.scheduleInternal(workSpec, jobId);
                }
            }
        }
        catch (IllegalStateException e) {
            List<JobInfo> jobs = SystemJobScheduler.getPendingJobs(this.mContext, this.mJobScheduler);
            int numWorkManagerJobs = jobs != null ? jobs.size() : 0;
            String message = String.format(Locale.getDefault(), "JobScheduler 100 job limit exceeded.  We count %d WorkManager jobs in JobScheduler; we have %d tracked jobs in our DB; our Configuration limit is %d.", numWorkManagerJobs, this.mWorkDatabase.workSpecDao().getScheduledWork().size(), this.mConfiguration.getMaxSchedulerLimit());
            Logger.get().error(TAG, message);
            IllegalStateException schedulingException = new IllegalStateException(message, e);
            Consumer<Throwable> handler = this.mConfiguration.getSchedulingExceptionHandler();
            if (handler != null) {
                handler.accept((Object)schedulingException);
            }
            throw schedulingException;
        }
        catch (Throwable throwable) {
            Logger.get().error(TAG, "Unable to schedule " + workSpec, throwable);
        }
    }

    @Override
    public void cancel(@NonNull String workSpecId) {
        List<Integer> jobIds = SystemJobScheduler.getPendingJobIds(this.mContext, this.mJobScheduler, workSpecId);
        if (jobIds != null && !jobIds.isEmpty()) {
            for (int jobId : jobIds) {
                SystemJobScheduler.cancelJobById(this.mJobScheduler, jobId);
            }
            this.mWorkDatabase.systemIdInfoDao().removeSystemIdInfo(workSpecId);
        }
    }

    @Override
    public boolean hasLimitedSchedulingSlots() {
        return true;
    }

    private static void cancelJobById(@NonNull JobScheduler jobScheduler, int id) {
        try {
            jobScheduler.cancel(id);
        }
        catch (Throwable throwable) {
            Logger.get().error(TAG, String.format(Locale.getDefault(), "Exception while trying to cancel job (%d)", id), throwable);
        }
    }

    public static void cancelAll(@NonNull Context context) {
        List<JobInfo> jobs;
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler != null && (jobs = SystemJobScheduler.getPendingJobs(context, jobScheduler)) != null && !jobs.isEmpty()) {
            for (JobInfo jobInfo : jobs) {
                SystemJobScheduler.cancelJobById(jobScheduler, jobInfo.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reconcileJobs(@NonNull Context context, @NonNull WorkDatabase workDatabase) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        List<JobInfo> jobs = SystemJobScheduler.getPendingJobs(context, jobScheduler);
        List<String> workManagerWorkSpecs = workDatabase.systemIdInfoDao().getWorkSpecIds();
        int jobSize = jobs != null ? jobs.size() : 0;
        HashSet<String> jobSchedulerWorkSpecs = new HashSet<String>(jobSize);
        if (jobs != null && !jobs.isEmpty()) {
            for (JobInfo jobInfo : jobs) {
                WorkGenerationalId id = SystemJobScheduler.getWorkGenerationalIdFromJobInfo(jobInfo);
                if (id != null) {
                    jobSchedulerWorkSpecs.add(id.getWorkSpecId());
                    continue;
                }
                SystemJobScheduler.cancelJobById(jobScheduler, jobInfo.getId());
            }
        }
        boolean needsReconciling = false;
        for (String workSpecId : workManagerWorkSpecs) {
            if (jobSchedulerWorkSpecs.contains(workSpecId)) continue;
            Logger.get().debug(TAG, "Reconciling jobs");
            needsReconciling = true;
            break;
        }
        if (needsReconciling) {
            workDatabase.beginTransaction();
            try {
                WorkSpecDao workSpecDao = workDatabase.workSpecDao();
                for (String workSpecId : workManagerWorkSpecs) {
                    workSpecDao.markWorkSpecScheduled(workSpecId, -1L);
                }
                workDatabase.setTransactionSuccessful();
            }
            finally {
                workDatabase.endTransaction();
            }
        }
        return needsReconciling;
    }

    @Nullable
    private static List<JobInfo> getPendingJobs(@NonNull Context context, @NonNull JobScheduler jobScheduler) {
        List pendingJobs = null;
        try {
            pendingJobs = jobScheduler.getAllPendingJobs();
        }
        catch (Throwable exception) {
            Logger.get().error(TAG, "getAllPendingJobs() is not reliable on this device.", exception);
        }
        if (pendingJobs == null) {
            return null;
        }
        ArrayList<JobInfo> filtered = new ArrayList<JobInfo>(pendingJobs.size());
        ComponentName jobServiceComponent = new ComponentName(context, SystemJobService.class);
        for (JobInfo jobInfo : pendingJobs) {
            if (!jobServiceComponent.equals((Object)jobInfo.getService())) continue;
            filtered.add(jobInfo);
        }
        return filtered;
    }

    @Nullable
    private static List<Integer> getPendingJobIds(@NonNull Context context, @NonNull JobScheduler jobScheduler, @NonNull String workSpecId) {
        List<JobInfo> jobs = SystemJobScheduler.getPendingJobs(context, jobScheduler);
        if (jobs == null) {
            return null;
        }
        ArrayList<Integer> jobIds = new ArrayList<Integer>(2);
        for (JobInfo jobInfo : jobs) {
            WorkGenerationalId id = SystemJobScheduler.getWorkGenerationalIdFromJobInfo(jobInfo);
            if (id == null || !workSpecId.equals(id.getWorkSpecId())) continue;
            jobIds.add(jobInfo.getId());
        }
        return jobIds;
    }

    @Nullable
    private static WorkGenerationalId getWorkGenerationalIdFromJobInfo(@NonNull JobInfo jobInfo) {
        PersistableBundle extras = jobInfo.getExtras();
        try {
            if (extras != null && extras.containsKey("EXTRA_WORK_SPEC_ID")) {
                int generation = extras.getInt("EXTRA_WORK_SPEC_GENERATION", 0);
                return new WorkGenerationalId(extras.getString("EXTRA_WORK_SPEC_ID"), generation);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }
}

