/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.constraints.trackers;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import androidx.annotation.RequiresApi;
import androidx.work.Logger;
import androidx.work.impl.constraints.NetworkState;
import androidx.work.impl.constraints.trackers.ConstraintTracker;
import androidx.work.impl.constraints.trackers.NetworkStateTracker24;
import androidx.work.impl.constraints.trackers.NetworkStateTrackerKt;
import androidx.work.impl.utils.NetworkApi21;
import androidx.work.impl.utils.NetworkApi24;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\u000e\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0013"}, d2={"Landroidx/work/impl/constraints/trackers/NetworkStateTracker24;", "Landroidx/work/impl/constraints/trackers/ConstraintTracker;", "Landroidx/work/impl/constraints/NetworkState;", "context", "Landroid/content/Context;", "taskExecutor", "Landroidx/work/impl/utils/taskexecutor/TaskExecutor;", "(Landroid/content/Context;Landroidx/work/impl/utils/taskexecutor/TaskExecutor;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "initialState", "getInitialState", "()Landroidx/work/impl/constraints/NetworkState;", "networkCallback", "androidx/work/impl/constraints/trackers/NetworkStateTracker24$networkCallback$1", "Landroidx/work/impl/constraints/trackers/NetworkStateTracker24$networkCallback$1;", "startTracking", "", "stopTracking", "work-runtime_release"})
@RequiresApi(value=24)
public final class NetworkStateTracker24
extends ConstraintTracker<NetworkState> {
    @NotNull
    private final ConnectivityManager connectivityManager;
    @NotNull
    private final networkCallback.1 networkCallback;

    public NetworkStateTracker24(@NotNull Context context, @NotNull TaskExecutor taskExecutor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        super(context, taskExecutor);
        Object object = this.getAppContext().getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        this.connectivityManager = (ConnectivityManager)object;
        this.networkCallback = new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ NetworkStateTracker24 this$0;
            {
                this.this$0 = $receiver;
            }

            public void onCapabilitiesChanged(@NotNull Network network, @NotNull NetworkCapabilities capabilities) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                Intrinsics.checkNotNullParameter((Object)capabilities, (String)"capabilities");
                Logger.get().debug(NetworkStateTrackerKt.access$getTAG$p(), Intrinsics.stringPlus((String)"Network capabilities changed: ", (Object)capabilities));
                this.this$0.setState(NetworkStateTrackerKt.getActiveNetworkState(NetworkStateTracker24.access$getConnectivityManager$p(this.this$0)));
            }

            public void onLost(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                Logger.get().debug(NetworkStateTrackerKt.access$getTAG$p(), "Network connection lost");
                this.this$0.setState(NetworkStateTrackerKt.getActiveNetworkState(NetworkStateTracker24.access$getConnectivityManager$p(this.this$0)));
            }
        };
    }

    @Override
    @NotNull
    public NetworkState getInitialState() {
        return NetworkStateTrackerKt.getActiveNetworkState(this.connectivityManager);
    }

    @Override
    public void startTracking() {
        try {
            Logger.get().debug(NetworkStateTrackerKt.access$getTAG$p(), "Registering network callback");
            NetworkApi24.registerDefaultNetworkCallbackCompat(this.connectivityManager, this.networkCallback);
        }
        catch (IllegalArgumentException e) {
            Logger.get().error(NetworkStateTrackerKt.access$getTAG$p(), "Received exception while registering network callback", e);
        }
        catch (SecurityException e) {
            Logger.get().error(NetworkStateTrackerKt.access$getTAG$p(), "Received exception while registering network callback", e);
        }
    }

    @Override
    public void stopTracking() {
        try {
            Logger.get().debug(NetworkStateTrackerKt.access$getTAG$p(), "Unregistering network callback");
            NetworkApi21.unregisterNetworkCallbackCompat(this.connectivityManager, this.networkCallback);
        }
        catch (IllegalArgumentException e) {
            Logger.get().error(NetworkStateTrackerKt.access$getTAG$p(), "Received exception while unregistering network callback", e);
        }
        catch (SecurityException e) {
            Logger.get().error(NetworkStateTrackerKt.access$getTAG$p(), "Received exception while unregistering network callback", e);
        }
    }

    public static final /* synthetic */ ConnectivityManager access$getConnectivityManager$p(NetworkStateTracker24 $this) {
        return $this.connectivityManager;
    }
}

