/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.constraints;

import androidx.annotation.VisibleForTesting;
import androidx.work.Logger;
import androidx.work.impl.constraints.WorkConstraintsCallback;
import androidx.work.impl.constraints.WorkConstraintsTracker;
import androidx.work.impl.constraints.WorkConstraintsTrackerKt;
import androidx.work.impl.constraints.controllers.BatteryChargingController;
import androidx.work.impl.constraints.controllers.BatteryNotLowController;
import androidx.work.impl.constraints.controllers.ConstraintController;
import androidx.work.impl.constraints.controllers.NetworkConnectedController;
import androidx.work.impl.constraints.controllers.NetworkMeteredController;
import androidx.work.impl.constraints.controllers.NetworkNotRoamingController;
import androidx.work.impl.constraints.controllers.NetworkUnmeteredController;
import androidx.work.impl.constraints.controllers.StorageNotLowController;
import androidx.work.impl.constraints.trackers.Trackers;
import androidx.work.impl.model.WorkSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0016J\u0016\u0010\u0018\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0014H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Landroidx/work/impl/constraints/WorkConstraintsTrackerImpl;", "Landroidx/work/impl/constraints/WorkConstraintsTracker;", "Landroidx/work/impl/constraints/controllers/ConstraintController$OnConstraintUpdatedCallback;", "trackers", "Landroidx/work/impl/constraints/trackers/Trackers;", "callback", "Landroidx/work/impl/constraints/WorkConstraintsCallback;", "(Landroidx/work/impl/constraints/trackers/Trackers;Landroidx/work/impl/constraints/WorkConstraintsCallback;)V", "constraintControllers", "", "Landroidx/work/impl/constraints/controllers/ConstraintController;", "(Landroidx/work/impl/constraints/WorkConstraintsCallback;[Landroidx/work/impl/constraints/controllers/ConstraintController;)V", "[Landroidx/work/impl/constraints/controllers/ConstraintController;", "lock", "", "areAllConstraintsMet", "", "workSpecId", "", "onConstraintMet", "", "workSpecIds", "", "onConstraintNotMet", "replace", "workSpecs", "", "Landroidx/work/impl/model/WorkSpec;", "reset", "work-runtime_release"})
public final class WorkConstraintsTrackerImpl
implements WorkConstraintsTracker,
ConstraintController.OnConstraintUpdatedCallback {
    @Nullable
    private final WorkConstraintsCallback callback;
    @NotNull
    private final ConstraintController<?>[] constraintControllers;
    @NotNull
    private final Object lock;

    @VisibleForTesting
    public WorkConstraintsTrackerImpl(@Nullable WorkConstraintsCallback callback, @NotNull ConstraintController<?>[] constraintControllers) {
        Intrinsics.checkNotNullParameter(constraintControllers, (String)"constraintControllers");
        this.callback = callback;
        this.constraintControllers = constraintControllers;
        this.lock = new Object();
    }

    public WorkConstraintsTrackerImpl(@NotNull Trackers trackers, @Nullable WorkConstraintsCallback callback) {
        Intrinsics.checkNotNullParameter((Object)trackers, (String)"trackers");
        ConstraintController[] constraintControllerArray = new ConstraintController[]{new BatteryChargingController(trackers.getBatteryChargingTracker()), new BatteryNotLowController(trackers.getBatteryNotLowTracker()), new StorageNotLowController(trackers.getStorageNotLowTracker()), new NetworkConnectedController(trackers.getNetworkStateTracker()), new NetworkUnmeteredController(trackers.getNetworkStateTracker()), new NetworkNotRoamingController(trackers.getNetworkStateTracker()), new NetworkMeteredController(trackers.getNetworkStateTracker())};
        this(callback, constraintControllerArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(@NotNull Iterable<WorkSpec> workSpecs) {
        Intrinsics.checkNotNullParameter(workSpecs, (String)"workSpecs");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            for (ConstraintController<?> controller : this.constraintControllers) {
                controller.setCallback(null);
            }
            for (ConstraintController<?> controller : this.constraintControllers) {
                controller.replace(workSpecs);
            }
            for (ConstraintController<?> controller : this.constraintControllers) {
                controller.setCallback(this);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            for (ConstraintController<?> controller : this.constraintControllers) {
                controller.reset();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean areAllConstraintsMet(@NotNull String workSpecId) {
        Intrinsics.checkNotNullParameter((Object)workSpecId, (String)"workSpecId");
        Object object = this.lock;
        synchronized (object) {
            ConstraintController<?> controller;
            block5: {
                ConstraintController<?> constraintController;
                boolean bl = false;
                ConstraintController<?>[] $this$firstOrNull$iv = this.constraintControllers;
                boolean $i$f$firstOrNull = false;
                for (ConstraintController<?> element$iv : $this$firstOrNull$iv) {
                    ConstraintController<?> it = element$iv;
                    boolean bl2 = false;
                    if (!it.isWorkSpecConstrained(workSpecId)) continue;
                    constraintController = element$iv;
                    break block5;
                }
                constraintController = controller = null;
            }
            if (controller != null) {
                Logger.get().debug(WorkConstraintsTrackerKt.access$getTAG$p(), "Work " + workSpecId + " constrained by " + controller.getClass().getSimpleName());
            }
            boolean bl = controller == null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void onConstraintMet(@NotNull List<String> workSpecIds) {
        Intrinsics.checkNotNullParameter(workSpecIds, (String)"workSpecIds");
        Object object = this.lock;
        synchronized (object) {
            Unit unit;
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = workSpecIds;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (!this.areAllConstraintsMet(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List unconstrainedWorkSpecIds = (List)destination$iv$iv;
            Iterable $this$forEach$iv = unconstrainedWorkSpecIds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl3 = false;
                Logger.get().debug(WorkConstraintsTrackerKt.access$getTAG$p(), Intrinsics.stringPlus((String)"Constraints met for ", (Object)it));
            }
            WorkConstraintsCallback workConstraintsCallback = this.callback;
            if (workConstraintsCallback == null) {
                unit = null;
            } else {
                workConstraintsCallback.onAllConstraintsMet(unconstrainedWorkSpecIds);
                unit = Unit.INSTANCE;
            }
            Unit unit2 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConstraintNotMet(@NotNull List<String> workSpecIds) {
        Intrinsics.checkNotNullParameter(workSpecIds, (String)"workSpecIds");
        Object object = this.lock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            WorkConstraintsCallback workConstraintsCallback = this.callback;
            if (workConstraintsCallback == null) {
                unit = null;
            } else {
                workConstraintsCallback.onAllConstraintsNotMet(workSpecIds);
                unit = Unit.INSTANCE;
            }
            Unit unit2 = unit;
        }
    }
}

