/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.WorkerFactory;
import androidx.work.WorkerParameters;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DelegatingWorkerFactory
extends WorkerFactory {
    private static final String TAG = Logger.tagWithPrefix("DelegatingWkrFctry");
    private final List<WorkerFactory> mFactories = new CopyOnWriteArrayList<WorkerFactory>();

    @VisibleForTesting
    @NonNull
    List<WorkerFactory> getFactories() {
        return this.mFactories;
    }

    public final void addFactory(@NonNull WorkerFactory workerFactory) {
        this.mFactories.add(workerFactory);
    }

    @Override
    @Nullable
    public final ListenableWorker createWorker(@NonNull Context appContext, @NonNull String workerClassName, @NonNull WorkerParameters workerParameters) {
        for (WorkerFactory factory : this.mFactories) {
            try {
                ListenableWorker worker = factory.createWorker(appContext, workerClassName, workerParameters);
                if (worker == null) continue;
                return worker;
            }
            catch (Throwable throwable) {
                String message = String.format("Unable to instantiate a ListenableWorker (%s)", workerClassName);
                Logger.get().error(TAG, message, throwable);
                throw throwable;
            }
        }
        return null;
    }
}

