/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.room.ColumnInfo;
import androidx.work.ContentUriTriggers;
import androidx.work.NetworkType;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public final class Constraints {
    public static final Constraints NONE = new Builder().build();
    @ColumnInfo(name="required_network_type")
    private NetworkType mRequiredNetworkType = NetworkType.NOT_REQUIRED;
    @ColumnInfo(name="requires_charging")
    private boolean mRequiresCharging;
    @ColumnInfo(name="requires_device_idle")
    private boolean mRequiresDeviceIdle;
    @ColumnInfo(name="requires_battery_not_low")
    private boolean mRequiresBatteryNotLow;
    @ColumnInfo(name="requires_storage_not_low")
    private boolean mRequiresStorageNotLow;
    @ColumnInfo(name="trigger_content_update_delay")
    private long mTriggerContentUpdateDelay = -1L;
    @ColumnInfo(name="trigger_max_content_delay")
    private long mTriggerMaxContentDelay = -1L;
    @ColumnInfo(name="content_uri_triggers")
    private ContentUriTriggers mContentUriTriggers = new ContentUriTriggers();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Constraints() {
    }

    Constraints(Builder builder) {
        this.mRequiresCharging = builder.mRequiresCharging;
        this.mRequiresDeviceIdle = Build.VERSION.SDK_INT >= 23 && builder.mRequiresDeviceIdle;
        this.mRequiredNetworkType = builder.mRequiredNetworkType;
        this.mRequiresBatteryNotLow = builder.mRequiresBatteryNotLow;
        this.mRequiresStorageNotLow = builder.mRequiresStorageNotLow;
        if (Build.VERSION.SDK_INT >= 24) {
            this.mContentUriTriggers = builder.mContentUriTriggers;
            this.mTriggerContentUpdateDelay = builder.mTriggerContentUpdateDelay;
            this.mTriggerMaxContentDelay = builder.mTriggerContentMaxDelay;
        }
    }

    public Constraints(@NonNull Constraints other) {
        this.mRequiresCharging = other.mRequiresCharging;
        this.mRequiresDeviceIdle = other.mRequiresDeviceIdle;
        this.mRequiredNetworkType = other.mRequiredNetworkType;
        this.mRequiresBatteryNotLow = other.mRequiresBatteryNotLow;
        this.mRequiresStorageNotLow = other.mRequiresStorageNotLow;
        this.mContentUriTriggers = other.mContentUriTriggers;
    }

    @NonNull
    public NetworkType getRequiredNetworkType() {
        return this.mRequiredNetworkType;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setRequiredNetworkType(@NonNull NetworkType requiredNetworkType) {
        this.mRequiredNetworkType = requiredNetworkType;
    }

    public boolean requiresCharging() {
        return this.mRequiresCharging;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setRequiresCharging(boolean requiresCharging) {
        this.mRequiresCharging = requiresCharging;
    }

    @RequiresApi(value=23)
    public boolean requiresDeviceIdle() {
        return this.mRequiresDeviceIdle;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=23)
    public void setRequiresDeviceIdle(boolean requiresDeviceIdle) {
        this.mRequiresDeviceIdle = requiresDeviceIdle;
    }

    public boolean requiresBatteryNotLow() {
        return this.mRequiresBatteryNotLow;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setRequiresBatteryNotLow(boolean requiresBatteryNotLow) {
        this.mRequiresBatteryNotLow = requiresBatteryNotLow;
    }

    public boolean requiresStorageNotLow() {
        return this.mRequiresStorageNotLow;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setRequiresStorageNotLow(boolean requiresStorageNotLow) {
        this.mRequiresStorageNotLow = requiresStorageNotLow;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public long getTriggerContentUpdateDelay() {
        return this.mTriggerContentUpdateDelay;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setTriggerContentUpdateDelay(long triggerContentUpdateDelay) {
        this.mTriggerContentUpdateDelay = triggerContentUpdateDelay;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public long getTriggerMaxContentDelay() {
        return this.mTriggerMaxContentDelay;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setTriggerMaxContentDelay(long triggerMaxContentDelay) {
        this.mTriggerMaxContentDelay = triggerMaxContentDelay;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=24)
    public void setContentUriTriggers(@Nullable ContentUriTriggers mContentUriTriggers) {
        this.mContentUriTriggers = mContentUriTriggers;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=24)
    @NonNull
    public ContentUriTriggers getContentUriTriggers() {
        return this.mContentUriTriggers;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=24)
    public boolean hasContentUriTriggers() {
        return this.mContentUriTriggers.size() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Constraints that = (Constraints)o;
        if (this.mRequiresCharging != that.mRequiresCharging) {
            return false;
        }
        if (this.mRequiresDeviceIdle != that.mRequiresDeviceIdle) {
            return false;
        }
        if (this.mRequiresBatteryNotLow != that.mRequiresBatteryNotLow) {
            return false;
        }
        if (this.mRequiresStorageNotLow != that.mRequiresStorageNotLow) {
            return false;
        }
        if (this.mTriggerContentUpdateDelay != that.mTriggerContentUpdateDelay) {
            return false;
        }
        if (this.mTriggerMaxContentDelay != that.mTriggerMaxContentDelay) {
            return false;
        }
        if (this.mRequiredNetworkType != that.mRequiredNetworkType) {
            return false;
        }
        return this.mContentUriTriggers.equals(that.mContentUriTriggers);
    }

    public int hashCode() {
        int result = this.mRequiredNetworkType.hashCode();
        result = 31 * result + (this.mRequiresCharging ? 1 : 0);
        result = 31 * result + (this.mRequiresDeviceIdle ? 1 : 0);
        result = 31 * result + (this.mRequiresBatteryNotLow ? 1 : 0);
        result = 31 * result + (this.mRequiresStorageNotLow ? 1 : 0);
        result = 31 * result + (int)(this.mTriggerContentUpdateDelay ^ this.mTriggerContentUpdateDelay >>> 32);
        result = 31 * result + (int)(this.mTriggerMaxContentDelay ^ this.mTriggerMaxContentDelay >>> 32);
        result = 31 * result + this.mContentUriTriggers.hashCode();
        return result;
    }

    public static final class Builder {
        boolean mRequiresCharging = false;
        boolean mRequiresDeviceIdle = false;
        NetworkType mRequiredNetworkType = NetworkType.NOT_REQUIRED;
        boolean mRequiresBatteryNotLow = false;
        boolean mRequiresStorageNotLow = false;
        long mTriggerContentUpdateDelay = -1L;
        long mTriggerContentMaxDelay = -1L;
        ContentUriTriggers mContentUriTriggers = new ContentUriTriggers();

        public Builder() {
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder(@NonNull Constraints constraints) {
            this.mRequiresCharging = constraints.requiresCharging();
            this.mRequiresDeviceIdle = Build.VERSION.SDK_INT >= 23 && constraints.requiresDeviceIdle();
            this.mRequiredNetworkType = constraints.getRequiredNetworkType();
            this.mRequiresBatteryNotLow = constraints.requiresBatteryNotLow();
            this.mRequiresStorageNotLow = constraints.requiresStorageNotLow();
            if (Build.VERSION.SDK_INT >= 24) {
                this.mTriggerContentUpdateDelay = constraints.getTriggerContentUpdateDelay();
                this.mTriggerContentMaxDelay = constraints.getTriggerMaxContentDelay();
                this.mContentUriTriggers = constraints.getContentUriTriggers();
            }
        }

        @NonNull
        public Builder setRequiresCharging(boolean requiresCharging) {
            this.mRequiresCharging = requiresCharging;
            return this;
        }

        @RequiresApi(value=23)
        @NonNull
        public Builder setRequiresDeviceIdle(boolean requiresDeviceIdle) {
            this.mRequiresDeviceIdle = requiresDeviceIdle;
            return this;
        }

        @NonNull
        public Builder setRequiredNetworkType(@NonNull NetworkType networkType) {
            this.mRequiredNetworkType = networkType;
            return this;
        }

        @NonNull
        public Builder setRequiresBatteryNotLow(boolean requiresBatteryNotLow) {
            this.mRequiresBatteryNotLow = requiresBatteryNotLow;
            return this;
        }

        @NonNull
        public Builder setRequiresStorageNotLow(boolean requiresStorageNotLow) {
            this.mRequiresStorageNotLow = requiresStorageNotLow;
            return this;
        }

        @RequiresApi(value=24)
        @NonNull
        public Builder addContentUriTrigger(@NonNull Uri uri, boolean triggerForDescendants) {
            this.mContentUriTriggers.add(uri, triggerForDescendants);
            return this;
        }

        @RequiresApi(value=24)
        @NonNull
        public Builder setTriggerContentUpdateDelay(long duration, @NonNull TimeUnit timeUnit) {
            this.mTriggerContentUpdateDelay = timeUnit.toMillis(duration);
            return this;
        }

        @RequiresApi(value=26)
        @NonNull
        public Builder setTriggerContentUpdateDelay(Duration duration) {
            this.mTriggerContentUpdateDelay = duration.toMillis();
            return this;
        }

        @RequiresApi(value=24)
        @NonNull
        public Builder setTriggerContentMaxDelay(long duration, @NonNull TimeUnit timeUnit) {
            this.mTriggerContentMaxDelay = timeUnit.toMillis(duration);
            return this;
        }

        @RequiresApi(value=26)
        @NonNull
        public Builder setTriggerContentMaxDelay(Duration duration) {
            this.mTriggerContentMaxDelay = duration.toMillis();
            return this;
        }

        @NonNull
        public Constraints build() {
            return new Constraints(this);
        }
    }
}

