/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import androidx.annotation.NonNull;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.work.WorkInfo;
import androidx.work.WorkQuery;
import androidx.work.impl.model.WorkTypeConverters;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class RawQueries {
    private RawQueries() {
    }

    @NonNull
    public static SupportSQLiteQuery workQueryToRawQuery(@NonNull WorkQuery querySpec) {
        List<String> list;
        List<String> tags;
        List<UUID> ids;
        ArrayList arguments = new ArrayList();
        StringBuilder builder = new StringBuilder("SELECT * FROM workspec");
        String conjunction = " WHERE";
        List<WorkInfo.State> states = querySpec.getStates();
        if (!states.isEmpty()) {
            ArrayList<Integer> stateIds = new ArrayList<Integer>(states.size());
            for (WorkInfo.State state : states) {
                stateIds.add(WorkTypeConverters.stateToInt(state));
            }
            builder.append(conjunction).append(" state IN (");
            RawQueries.bindings(builder, stateIds.size());
            builder.append(")");
            arguments.addAll(stateIds);
            conjunction = " AND";
        }
        if (!(ids = querySpec.getIds()).isEmpty()) {
            ArrayList<String> workSpecIds = new ArrayList<String>(ids.size());
            for (UUID id : ids) {
                workSpecIds.add(id.toString());
            }
            builder.append(conjunction).append(" id IN (");
            RawQueries.bindings(builder, ids.size());
            builder.append(")");
            arguments.addAll(workSpecIds);
            conjunction = " AND";
        }
        if (!(tags = querySpec.getTags()).isEmpty()) {
            builder.append(conjunction).append(" id IN (SELECT work_spec_id FROM worktag WHERE tag IN (");
            RawQueries.bindings(builder, tags.size());
            builder.append("))");
            arguments.addAll(tags);
            conjunction = " AND";
        }
        if (!(list = querySpec.getUniqueWorkNames()).isEmpty()) {
            builder.append(conjunction).append(" id IN (SELECT work_spec_id FROM workname WHERE name IN (");
            RawQueries.bindings(builder, list.size());
            builder.append("))");
            arguments.addAll(list);
            conjunction = " AND";
        }
        builder.append(";");
        return new SimpleSQLiteQuery(builder.toString(), arguments.toArray());
    }

    private static void bindings(@NonNull StringBuilder builder, int count) {
        if (count <= 0) {
            return;
        }
        builder.append("?");
        for (int i = 1; i < count; ++i) {
            builder.append(",");
            builder.append("?");
        }
    }
}

