/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.annotation.SuppressLint;
import android.os.Build;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.work.InitializationExceptionHandler;
import androidx.work.InputMergerFactory;
import androidx.work.RunnableScheduler;
import androidx.work.WorkerFactory;
import androidx.work.impl.DefaultRunnableScheduler;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public final class Configuration {
    @SuppressLint(value={"MinMaxConstant"})
    public static final int MIN_SCHEDULER_LIMIT = 20;
    @NonNull
    final Executor mExecutor;
    @NonNull
    final Executor mTaskExecutor;
    @NonNull
    final WorkerFactory mWorkerFactory;
    @NonNull
    final InputMergerFactory mInputMergerFactory;
    @NonNull
    final RunnableScheduler mRunnableScheduler;
    @Nullable
    final InitializationExceptionHandler mExceptionHandler;
    final int mLoggingLevel;
    final int mMinJobSchedulerId;
    final int mMaxJobSchedulerId;
    final int mMaxSchedulerLimit;
    private final boolean mIsUsingDefaultTaskExecutor;

    Configuration(@NonNull Builder builder) {
        this.mExecutor = builder.mExecutor == null ? this.createDefaultExecutor() : builder.mExecutor;
        if (builder.mTaskExecutor == null) {
            this.mIsUsingDefaultTaskExecutor = true;
            this.mTaskExecutor = this.createDefaultExecutor();
        } else {
            this.mIsUsingDefaultTaskExecutor = false;
            this.mTaskExecutor = builder.mTaskExecutor;
        }
        this.mWorkerFactory = builder.mWorkerFactory == null ? WorkerFactory.getDefaultWorkerFactory() : builder.mWorkerFactory;
        this.mInputMergerFactory = builder.mInputMergerFactory == null ? InputMergerFactory.getDefaultInputMergerFactory() : builder.mInputMergerFactory;
        this.mRunnableScheduler = builder.mRunnableScheduler == null ? new DefaultRunnableScheduler() : builder.mRunnableScheduler;
        this.mLoggingLevel = builder.mLoggingLevel;
        this.mMinJobSchedulerId = builder.mMinJobSchedulerId;
        this.mMaxJobSchedulerId = builder.mMaxJobSchedulerId;
        this.mMaxSchedulerLimit = builder.mMaxSchedulerLimit;
        this.mExceptionHandler = builder.mExceptionHandler;
    }

    @NonNull
    public Executor getExecutor() {
        return this.mExecutor;
    }

    @NonNull
    public Executor getTaskExecutor() {
        return this.mTaskExecutor;
    }

    @NonNull
    public WorkerFactory getWorkerFactory() {
        return this.mWorkerFactory;
    }

    @NonNull
    public InputMergerFactory getInputMergerFactory() {
        return this.mInputMergerFactory;
    }

    @NonNull
    public RunnableScheduler getRunnableScheduler() {
        return this.mRunnableScheduler;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getMinimumLoggingLevel() {
        return this.mLoggingLevel;
    }

    public int getMinJobSchedulerId() {
        return this.mMinJobSchedulerId;
    }

    public int getMaxJobSchedulerId() {
        return this.mMaxJobSchedulerId;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @IntRange(from=20L, to=50L)
    public int getMaxSchedulerLimit() {
        if (Build.VERSION.SDK_INT == 23) {
            return this.mMaxSchedulerLimit / 2;
        }
        return this.mMaxSchedulerLimit;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isUsingDefaultTaskExecutor() {
        return this.mIsUsingDefaultTaskExecutor;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public InitializationExceptionHandler getExceptionHandler() {
        return this.mExceptionHandler;
    }

    @NonNull
    private Executor createDefaultExecutor() {
        return Executors.newFixedThreadPool(Math.max(2, Math.min(Runtime.getRuntime().availableProcessors() - 1, 4)));
    }

    public static interface Provider {
        @NonNull
        public Configuration getWorkManagerConfiguration();
    }

    public static final class Builder {
        Executor mExecutor;
        WorkerFactory mWorkerFactory;
        InputMergerFactory mInputMergerFactory;
        Executor mTaskExecutor;
        RunnableScheduler mRunnableScheduler;
        @Nullable
        InitializationExceptionHandler mExceptionHandler;
        int mLoggingLevel;
        int mMinJobSchedulerId;
        int mMaxJobSchedulerId;
        int mMaxSchedulerLimit;

        public Builder() {
            this.mLoggingLevel = 4;
            this.mMinJobSchedulerId = 0;
            this.mMaxJobSchedulerId = Integer.MAX_VALUE;
            this.mMaxSchedulerLimit = 20;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder(@NonNull Configuration configuration) {
            this.mExecutor = configuration.mExecutor;
            this.mWorkerFactory = configuration.mWorkerFactory;
            this.mInputMergerFactory = configuration.mInputMergerFactory;
            this.mTaskExecutor = configuration.mTaskExecutor;
            this.mLoggingLevel = configuration.mLoggingLevel;
            this.mMinJobSchedulerId = configuration.mMinJobSchedulerId;
            this.mMaxJobSchedulerId = configuration.mMaxJobSchedulerId;
            this.mMaxSchedulerLimit = configuration.mMaxSchedulerLimit;
            this.mRunnableScheduler = configuration.mRunnableScheduler;
            this.mExceptionHandler = configuration.mExceptionHandler;
        }

        @NonNull
        public Builder setWorkerFactory(@NonNull WorkerFactory workerFactory) {
            this.mWorkerFactory = workerFactory;
            return this;
        }

        @NonNull
        public Builder setInputMergerFactory(@NonNull InputMergerFactory inputMergerFactory) {
            this.mInputMergerFactory = inputMergerFactory;
            return this;
        }

        @NonNull
        public Builder setExecutor(@NonNull Executor executor) {
            this.mExecutor = executor;
            return this;
        }

        @NonNull
        public Builder setTaskExecutor(@NonNull Executor taskExecutor) {
            this.mTaskExecutor = taskExecutor;
            return this;
        }

        @NonNull
        public Builder setJobSchedulerJobIdRange(int minJobSchedulerId, int maxJobSchedulerId) {
            if (maxJobSchedulerId - minJobSchedulerId < 1000) {
                throw new IllegalArgumentException("WorkManager needs a range of at least 1000 job ids.");
            }
            this.mMinJobSchedulerId = minJobSchedulerId;
            this.mMaxJobSchedulerId = maxJobSchedulerId;
            return this;
        }

        @NonNull
        public Builder setMaxSchedulerLimit(int maxSchedulerLimit) {
            if (maxSchedulerLimit < 20) {
                throw new IllegalArgumentException("WorkManager needs to be able to schedule at least 20 jobs in JobScheduler.");
            }
            this.mMaxSchedulerLimit = Math.min(maxSchedulerLimit, 50);
            return this;
        }

        @NonNull
        public Builder setMinimumLoggingLevel(int loggingLevel) {
            this.mLoggingLevel = loggingLevel;
            return this;
        }

        @NonNull
        public Builder setRunnableScheduler(@NonNull RunnableScheduler runnableScheduler) {
            this.mRunnableScheduler = runnableScheduler;
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setInitializationExceptionHandler(@NonNull InitializationExceptionHandler exceptionHandler) {
            this.mExceptionHandler = exceptionHandler;
            return this;
        }

        @NonNull
        public Configuration build() {
            return new Configuration(this);
        }
    }
}

