/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.greedy;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Configuration;
import androidx.work.Logger;
import androidx.work.WorkInfo;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.Scheduler;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.background.greedy.DelayedWorkTracker;
import androidx.work.impl.constraints.WorkConstraintsCallback;
import androidx.work.impl.constraints.WorkConstraintsTracker;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class GreedyScheduler
implements Scheduler,
WorkConstraintsCallback,
ExecutionListener {
    private static final String TAG = Logger.tagWithPrefix("GreedyScheduler");
    private final Context mContext;
    private final WorkManagerImpl mWorkManagerImpl;
    private final WorkConstraintsTracker mWorkConstraintsTracker;
    private final Set<WorkSpec> mConstrainedWorkSpecs = new HashSet<WorkSpec>();
    private DelayedWorkTracker mDelayedWorkTracker;
    private boolean mRegisteredExecutionListener;
    private final Object mLock;
    private Boolean mIsMainProcess;

    public GreedyScheduler(@NonNull Context context, @NonNull Configuration configuration, @NonNull TaskExecutor taskExecutor, @NonNull WorkManagerImpl workManagerImpl) {
        this.mContext = context;
        this.mWorkManagerImpl = workManagerImpl;
        this.mWorkConstraintsTracker = new WorkConstraintsTracker(context, taskExecutor, this);
        this.mDelayedWorkTracker = new DelayedWorkTracker(this, configuration.getRunnableScheduler());
        this.mLock = new Object();
    }

    @VisibleForTesting
    public GreedyScheduler(@NonNull Context context, @NonNull WorkManagerImpl workManagerImpl, @NonNull WorkConstraintsTracker workConstraintsTracker) {
        this.mContext = context;
        this.mWorkManagerImpl = workManagerImpl;
        this.mWorkConstraintsTracker = workConstraintsTracker;
        this.mLock = new Object();
    }

    @VisibleForTesting
    public void setDelayedWorkTracker(@NonNull DelayedWorkTracker delayedWorkTracker) {
        this.mDelayedWorkTracker = delayedWorkTracker;
    }

    @Override
    public boolean hasLimitedSchedulingSlots() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(WorkSpec ... workSpecs) {
        if (this.mIsMainProcess == null) {
            this.mIsMainProcess = TextUtils.equals((CharSequence)this.mContext.getPackageName(), (CharSequence)this.getProcessName());
        }
        if (!this.mIsMainProcess.booleanValue()) {
            Logger.get().info(TAG, "Ignoring schedule request in non-main process", new Throwable[0]);
            return;
        }
        this.registerExecutionListenerIfNeeded();
        HashSet<WorkSpec> constrainedWorkSpecs = new HashSet<WorkSpec>();
        HashSet<String> constrainedWorkSpecIds = new HashSet<String>();
        for (WorkSpec workSpec : workSpecs) {
            long nextRunTime = workSpec.calculateNextRunTime();
            long now = System.currentTimeMillis();
            if (workSpec.state != WorkInfo.State.ENQUEUED) continue;
            if (now < nextRunTime) {
                if (this.mDelayedWorkTracker == null) continue;
                this.mDelayedWorkTracker.schedule(workSpec);
                continue;
            }
            if (workSpec.hasConstraints()) {
                if (Build.VERSION.SDK_INT >= 23 && workSpec.constraints.requiresDeviceIdle()) {
                    Logger.get().debug(TAG, String.format("Ignoring WorkSpec %s, Requires device idle.", workSpec), new Throwable[0]);
                    continue;
                }
                if (Build.VERSION.SDK_INT >= 24 && workSpec.constraints.hasContentUriTriggers()) {
                    Logger.get().debug(TAG, String.format("Ignoring WorkSpec %s, Requires ContentUri triggers.", workSpec), new Throwable[0]);
                    continue;
                }
                constrainedWorkSpecs.add(workSpec);
                constrainedWorkSpecIds.add(workSpec.id);
                continue;
            }
            Logger.get().debug(TAG, String.format("Starting work for %s", workSpec.id), new Throwable[0]);
            this.mWorkManagerImpl.startWork(workSpec.id);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!constrainedWorkSpecs.isEmpty()) {
                Logger.get().debug(TAG, String.format("Starting tracking for [%s]", TextUtils.join((CharSequence)",", constrainedWorkSpecIds)), new Throwable[0]);
                this.mConstrainedWorkSpecs.addAll(constrainedWorkSpecs);
                this.mWorkConstraintsTracker.replace(this.mConstrainedWorkSpecs);
            }
        }
    }

    @Override
    public void cancel(@NonNull String workSpecId) {
        if (this.mIsMainProcess == null) {
            this.mIsMainProcess = TextUtils.equals((CharSequence)this.mContext.getPackageName(), (CharSequence)this.getProcessName());
        }
        if (!this.mIsMainProcess.booleanValue()) {
            Logger.get().info(TAG, "Ignoring schedule request in non-main process", new Throwable[0]);
            return;
        }
        this.registerExecutionListenerIfNeeded();
        Logger.get().debug(TAG, String.format("Cancelling work ID %s", workSpecId), new Throwable[0]);
        if (this.mDelayedWorkTracker != null) {
            this.mDelayedWorkTracker.unschedule(workSpecId);
        }
        this.mWorkManagerImpl.stopWork(workSpecId);
    }

    @Override
    public void onAllConstraintsMet(@NonNull List<String> workSpecIds) {
        for (String workSpecId : workSpecIds) {
            Logger.get().debug(TAG, String.format("Constraints met: Scheduling work ID %s", workSpecId), new Throwable[0]);
            this.mWorkManagerImpl.startWork(workSpecId);
        }
    }

    @Override
    public void onAllConstraintsNotMet(@NonNull List<String> workSpecIds) {
        for (String workSpecId : workSpecIds) {
            Logger.get().debug(TAG, String.format("Constraints not met: Cancelling work ID %s", workSpecId), new Throwable[0]);
            this.mWorkManagerImpl.stopWork(workSpecId);
        }
    }

    @Override
    public void onExecuted(@NonNull String workSpecId, boolean needsReschedule) {
        this.removeConstraintTrackingFor(workSpecId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConstraintTrackingFor(@NonNull String workSpecId) {
        Object object = this.mLock;
        synchronized (object) {
            for (WorkSpec constrainedWorkSpec : this.mConstrainedWorkSpecs) {
                if (!constrainedWorkSpec.id.equals(workSpecId)) continue;
                Logger.get().debug(TAG, String.format("Stopping tracking for %s", workSpecId), new Throwable[0]);
                this.mConstrainedWorkSpecs.remove(constrainedWorkSpec);
                this.mWorkConstraintsTracker.replace(this.mConstrainedWorkSpecs);
                break;
            }
        }
    }

    private void registerExecutionListenerIfNeeded() {
        if (!this.mRegisteredExecutionListener) {
            this.mWorkManagerImpl.getProcessor().addExecutionListener(this);
            this.mRegisteredExecutionListener = true;
        }
    }

    @Nullable
    private String getProcessName() {
        List processes;
        int pid = Process.myPid();
        ActivityManager am = (ActivityManager)this.mContext.getSystemService("activity");
        if (am != null && (processes = am.getRunningAppProcesses()) != null && !processes.isEmpty()) {
            for (ActivityManager.RunningAppProcessInfo process : processes) {
                if (process.pid != pid) continue;
                return process.processName;
            }
        }
        return null;
    }
}

