/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import androidx.work.Logger;

public class PackageManagerHelper {
    private static final String TAG = Logger.tagWithPrefix("PackageManagerHelper");

    private PackageManagerHelper() {
    }

    public static void setComponentEnabled(@NonNull Context context, @NonNull Class<?> klazz, boolean enabled) {
        try {
            boolean current = PackageManagerHelper.isComponentEnabled(PackageManagerHelper.getComponentEnabledSetting(context, klazz.getName()), false);
            if (enabled == current) {
                Logger.get().debug(TAG, "Skipping component enablement for " + klazz.getName());
                return;
            }
            PackageManager packageManager = context.getPackageManager();
            ComponentName componentName = new ComponentName(context, klazz.getName());
            packageManager.setComponentEnabledSetting(componentName, enabled ? 1 : 2, 1);
            Logger.get().debug(TAG, klazz.getName() + " " + (enabled ? "enabled" : "disabled"));
        }
        catch (Exception exception) {
            Logger.get().debug(TAG, klazz.getName() + "could not be " + (enabled ? "enabled" : "disabled"), exception);
        }
    }

    public static boolean isComponentExplicitlyEnabled(@NonNull Context context, @NonNull Class<?> klazz) {
        int setting = PackageManagerHelper.getComponentEnabledSetting(context, klazz.getName());
        return PackageManagerHelper.isComponentEnabled(setting, false);
    }

    public static boolean isComponentExplicitlyEnabled(@NonNull Context context, @NonNull String className) {
        int state = PackageManagerHelper.getComponentEnabledSetting(context, className);
        return state == 1;
    }

    private static int getComponentEnabledSetting(@NonNull Context context, @NonNull String className) {
        PackageManager packageManager = context.getPackageManager();
        ComponentName componentName = new ComponentName(context, className);
        return packageManager.getComponentEnabledSetting(componentName);
    }

    private static boolean isComponentEnabled(int setting, boolean defaults) {
        if (setting == 0) {
            return defaults;
        }
        return setting == 1;
    }
}

