/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import androidx.work.Configuration;
import androidx.work.Logger;
import androidx.work.WorkManager;
import androidx.work.impl.utils.Api28Impl;
import java.lang.reflect.Method;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0003\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"TAG", "", "getProcessName", "context", "Landroid/content/Context;", "isDefaultProcess", "", "configuration", "Landroidx/work/Configuration;", "work-runtime_release"})
@JvmName(name="ProcessUtils")
@SourceDebugExtension(value={"SMAP\nProcessUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessUtils.kt\nandroidx/work/impl/utils/ProcessUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class ProcessUtils {
    @NotNull
    private static final String TAG;

    public static final boolean isDefaultProcess(@NotNull Context context, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        String processName = ProcessUtils.getProcessName(context);
        CharSequence charSequence = configuration.getDefaultProcessName();
        return !(charSequence == null || charSequence.length() == 0) ? Intrinsics.areEqual((Object)processName, (Object)configuration.getDefaultProcessName()) : Intrinsics.areEqual((Object)processName, (Object)context.getApplicationInfo().processName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"PrivateApi", "DiscouragedPrivateApi"})
    private static final String getProcessName(Context context) {
        Object v4;
        List list;
        block5: {
            if (Build.VERSION.SDK_INT >= 28) {
                return Api28Impl.INSTANCE.getProcessName();
            }
            try {
                Class<?> activityThread = Class.forName("android.app.ActivityThread", false, WorkManager.class.getClassLoader());
                Method currentProcessName = activityThread.getDeclaredMethod("currentProcessName", new Class[0]);
                currentProcessName.setAccessible(true);
                Object object = currentProcessName.invoke(null, new Object[0]);
                Intrinsics.checkNotNull((Object)object);
                Object packageName = object;
                if (packageName instanceof String) {
                    return (String)packageName;
                }
            }
            catch (Throwable exception) {
                Logger.get().debug(TAG, "Unable to check ActivityThread for processName", exception);
            }
            int pid = Process.myPid();
            Object object = context.getSystemService("activity");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
            ActivityManager am = (ActivityManager)object;
            List list2 = am.getRunningAppProcesses();
            list = list2;
            if (list2 == null) return null;
            Iterable iterable = list;
            for (Object t : iterable) {
                ActivityManager.RunningAppProcessInfo process = (ActivityManager.RunningAppProcessInfo)t;
                boolean bl = false;
                if (!(process.pid == pid)) continue;
                v4 = t;
                break block5;
            }
            v4 = null;
        }
        ActivityManager.RunningAppProcessInfo runningAppProcessInfo = v4;
        list = runningAppProcessInfo;
        if (runningAppProcessInfo == null) return null;
        String string = ((ActivityManager.RunningAppProcessInfo)list).processName;
        return string;
    }

    static {
        String string = Logger.tagWithPrefix("ProcessUtils");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tagWithPrefix(\"ProcessUtils\")");
        TAG = string;
    }
}

