/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import androidx.tracing.Trace;
import androidx.work.Tracer;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\b\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003*\u0004\u0018\u00010\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"DEFAULT_CONTENT_URI_TRIGGERS_WORKERS_LIMIT", "", "createDefaultExecutor", "Ljava/util/concurrent/Executor;", "isTaskExecutor", "", "createDefaultTracer", "Landroidx/work/Tracer;", "asExecutor", "Lkotlin/coroutines/CoroutineContext;", "work-runtime_release"})
public final class ConfigurationKt {
    public static final int DEFAULT_CONTENT_URI_TRIGGERS_WORKERS_LIMIT = 8;

    private static final Executor createDefaultExecutor(boolean isTaskExecutor) {
        ThreadFactory factory2 = new ThreadFactory(isTaskExecutor){
            @NotNull
            private final AtomicInteger threadCount;
            final /* synthetic */ boolean $isTaskExecutor;
            {
                this.$isTaskExecutor = $isTaskExecutor;
                this.threadCount = new AtomicInteger(0);
            }

            @NotNull
            public Thread newThread(@NotNull Runnable runnable) {
                Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
                String prefix = this.$isTaskExecutor ? "WM.task-" : "androidx.work-";
                return new Thread(runnable, prefix + this.threadCount.incrementAndGet());
            }
        };
        ExecutorService executorService = Executors.newFixedThreadPool(Math.max(2, Math.min(Runtime.getRuntime().availableProcessors() - 1, 4)), factory2);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newFixedThreadPool(\n    \u2026)),\n        factory\n    )");
        return executorService;
    }

    private static final Tracer createDefaultTracer() {
        Tracer tracer2 = new Tracer(){

            public void beginAsyncSection(@NotNull String methodName, int cookie) {
                Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
                Trace.beginAsyncSection((String)methodName, (int)cookie);
            }

            public void endAsyncSection(@NotNull String methodName, int cookie) {
                Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
                Trace.endAsyncSection((String)methodName, (int)cookie);
            }
        };
        return tracer2;
    }

    private static final Executor asExecutor(CoroutineContext $this$asExecutor) {
        CoroutineContext coroutineContext = $this$asExecutor;
        ContinuationInterceptor continuationInterceptor = coroutineContext != null ? (ContinuationInterceptor)coroutineContext.get((CoroutineContext.Key)ContinuationInterceptor.Key) : null;
        CoroutineDispatcher coroutineDispatcher = continuationInterceptor instanceof CoroutineDispatcher ? (CoroutineDispatcher)continuationInterceptor : null;
        return coroutineDispatcher != null ? ExecutorsKt.asExecutor((CoroutineDispatcher)coroutineDispatcher) : null;
    }

    public static final /* synthetic */ Executor access$asExecutor(CoroutineContext $receiver) {
        return ConfigurationKt.asExecutor($receiver);
    }

    public static final /* synthetic */ Executor access$createDefaultExecutor(boolean isTaskExecutor) {
        return ConfigurationKt.createDefaultExecutor(isTaskExecutor);
    }

    public static final /* synthetic */ Tracer access$createDefaultTracer() {
        return ConfigurationKt.createDefaultTracer();
    }
}

