/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.work.Clock;
import androidx.work.Configuration;
import androidx.work.Data;
import androidx.work.InputMerger;
import androidx.work.InputMergerFactory;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.WorkInfo;
import androidx.work.WorkerParameters;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkerWrapperKt;
import androidx.work.impl.background.systemalarm.RescheduleReceiver;
import androidx.work.impl.foreground.ForegroundProcessor;
import androidx.work.impl.model.DependencyDao;
import androidx.work.impl.model.WorkGenerationalId;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.model.WorkSpecKt;
import androidx.work.impl.utils.PackageManagerHelper;
import androidx.work.impl.utils.SynchronousExecutor;
import androidx.work.impl.utils.WorkForegroundRunnable;
import androidx.work.impl.utils.WorkForegroundUpdater;
import androidx.work.impl.utils.WorkProgressUpdater;
import androidx.work.impl.utils.futures.SettableFuture;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001:\u0001GB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u00102\u001a\u00020\u001e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u00105\u001a\u0002042\u0006\u00106\u001a\u00020\u0017H\u0007J\u0010\u00107\u001a\u0002042\u0006\u0010,\u001a\u00020\u001eH\u0002J\b\u00108\u001a\u000204H\u0002J\b\u00109\u001a\u000204H\u0002J\b\u0010:\u001a\u000204H\u0002J\u0010\u0010;\u001a\u0002042\u0006\u0010<\u001a\u00020\u0007H\u0002J\u001e\u0010;\u001a\u0002042\u0006\u0010=\u001a\u00020\u00072\f\u0010>\u001a\b\u0012\u0004\u0012\u0002040?H\u0002J\b\u0010@\u001a\u000204H\u0002J\b\u0010A\u001a\u000204H\u0017J\b\u0010B\u001a\u000204H\u0002J\b\u0010C\u001a\u000204H\u0007J\b\u0010D\u001a\u000204H\u0002J\b\u0010E\u001a\u00020\u0007H\u0002J\b\u0010F\u001a\u00020\u0007H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u00190\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Landroidx/work/impl/WorkerWrapper;", "Ljava/lang/Runnable;", "builder", "Landroidx/work/impl/WorkerWrapper$Builder;", "(Landroidx/work/impl/WorkerWrapper$Builder;)V", "_future", "Landroidx/work/impl/utils/futures/SettableFuture;", "", "appContext", "Landroid/content/Context;", "clock", "Landroidx/work/Clock;", "configuration", "Landroidx/work/Configuration;", "dependencyDao", "Landroidx/work/impl/model/DependencyDao;", "foregroundProcessor", "Landroidx/work/impl/foreground/ForegroundProcessor;", "future", "Lcom/google/common/util/concurrent/ListenableFuture;", "getFuture", "()Lcom/google/common/util/concurrent/ListenableFuture;", "interrupted", "", "result", "Landroidx/work/ListenableWorker$Result;", "runtimeExtras", "Landroidx/work/WorkerParameters$RuntimeExtras;", "tags", "", "", "workDatabase", "Landroidx/work/impl/WorkDatabase;", "workDescription", "workGenerationalId", "Landroidx/work/impl/model/WorkGenerationalId;", "getWorkGenerationalId", "()Landroidx/work/impl/model/WorkGenerationalId;", "workSpec", "Landroidx/work/impl/model/WorkSpec;", "getWorkSpec", "()Landroidx/work/impl/model/WorkSpec;", "workSpecDao", "Landroidx/work/impl/model/WorkSpecDao;", "workSpecId", "workTaskExecutor", "Landroidx/work/impl/utils/taskexecutor/TaskExecutor;", "worker", "Landroidx/work/ListenableWorker;", "workerResultFuture", "createWorkDescription", "handleResult", "", "interrupt", "stopReason", "iterativelyFailWorkAndDependents", "onWorkFinished", "rescheduleAndResolve", "resetPeriodicAndResolve", "resolve", "needsReschedule", "reschedule", "block", "Lkotlin/Function0;", "resolveIncorrectStatus", "run", "runWorker", "setFailedAndResolve", "setSucceededAndResolve", "tryCheckForInterruptionAndResolve", "trySetRunning", "Builder", "work-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nWorkerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkerWrapper.kt\nandroidx/work/impl/WorkerWrapper\n+ 2 LoggerExt.kt\nandroidx/work/LoggerExtKt\n*L\n1#1,553:1\n27#2:554\n27#2:555\n27#2:556\n19#2:557\n19#2:558\n19#2:559\n19#2:560\n23#2:561\n23#2:562\n23#2:563\n19#2:564\n19#2:565\n27#2:566\n19#2:567\n25#2:568\n29#2:569\n29#2:570\n*S KotlinDebug\n*F\n+ 1 WorkerWrapper.kt\nandroidx/work/impl/WorkerWrapper\n*L\n155#1:554\n187#1:555\n192#1:556\n312#1:557\n319#1:558\n325#1:559\n337#1:560\n380#1:561\n387#1:562\n390#1:563\n108#1:564\n231#1:565\n246#1:566\n251#1:567\n257#1:568\n259#1:569\n263#1:570\n*E\n"})
public final class WorkerWrapper
implements Runnable {
    @NotNull
    private final WorkSpec workSpec;
    @NotNull
    private final Context appContext;
    @NotNull
    private final String workSpecId;
    @NotNull
    private final WorkerParameters.RuntimeExtras runtimeExtras;
    @Nullable
    private ListenableWorker worker;
    @NotNull
    private final TaskExecutor workTaskExecutor;
    @NotNull
    private ListenableWorker.Result result;
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final Clock clock;
    @NotNull
    private final ForegroundProcessor foregroundProcessor;
    @NotNull
    private final WorkDatabase workDatabase;
    @NotNull
    private final WorkSpecDao workSpecDao;
    @NotNull
    private final DependencyDao dependencyDao;
    @NotNull
    private final List<String> tags;
    @Nullable
    private String workDescription;
    @NotNull
    private final SettableFuture<Boolean> _future;
    @NotNull
    private final SettableFuture<ListenableWorker.Result> workerResultFuture;
    private volatile int interrupted;

    public WorkerWrapper(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.workSpec = builder.getWorkSpec();
        this.appContext = builder.getAppContext();
        this.workSpecId = this.workSpec.id;
        this.runtimeExtras = builder.getRuntimeExtras();
        this.worker = builder.getWorker();
        this.workTaskExecutor = builder.getWorkTaskExecutor();
        ListenableWorker.Result result = ListenableWorker.Result.failure();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"failure()");
        this.result = result;
        this.configuration = builder.getConfiguration();
        this.clock = this.configuration.getClock();
        this.foregroundProcessor = builder.getForegroundProcessor();
        this.workDatabase = builder.getWorkDatabase();
        this.workSpecDao = this.workDatabase.workSpecDao();
        this.dependencyDao = this.workDatabase.dependencyDao();
        this.tags = builder.getTags();
        SettableFuture settableFuture = SettableFuture.create();
        Intrinsics.checkNotNullExpressionValue(settableFuture, (String)"create()");
        this._future = settableFuture;
        SettableFuture settableFuture2 = SettableFuture.create();
        Intrinsics.checkNotNullExpressionValue(settableFuture2, (String)"create()");
        this.workerResultFuture = settableFuture2;
        this.interrupted = -256;
    }

    @NotNull
    public final WorkSpec getWorkSpec() {
        return this.workSpec;
    }

    @NotNull
    public final WorkGenerationalId getWorkGenerationalId() {
        return WorkSpecKt.generationalId(this.workSpec);
    }

    @NotNull
    public final ListenableFuture<Boolean> getFuture() {
        return this._future;
    }

    @Override
    @WorkerThread
    public void run() {
        this.workDescription = this.createWorkDescription(this.tags);
        this.runWorker();
    }

    private final void runWorker() {
        String tag$iv;
        ListenableWorker worker;
        Data data;
        if (this.tryCheckForInterruptionAndResolve()) {
            return;
        }
        Boolean shouldExit = (Boolean)this.workDatabase.runInTransaction(() -> WorkerWrapper.runWorker$lambda$1(this));
        Intrinsics.checkNotNullExpressionValue((Object)shouldExit, (String)"shouldExit");
        if (shouldExit.booleanValue()) {
            return;
        }
        if (this.workSpec.isPeriodic()) {
            data = this.workSpec.input;
        } else {
            String inputMergerClassName;
            InputMergerFactory inputMergerFactory = this.configuration.getInputMergerFactory();
            InputMerger inputMerger = inputMergerFactory.createInputMergerWithDefaultFallback(inputMergerClassName = this.workSpec.inputMergerClassName);
            if (inputMerger == null) {
                String tag$iv2 = WorkerWrapperKt.access$getTAG$p();
                boolean $i$f$loge = false;
                String string = tag$iv2;
                Logger logger = Logger.get();
                boolean bl = false;
                String string2 = "Could not create Input Merger " + this.workSpec.inputMergerClassName;
                logger.error(string, string2);
                this.setFailedAndResolve();
                return;
            }
            List inputs = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.workSpec.input), (Iterable)this.workSpecDao.getInputsFromPrerequisites(this.workSpecId));
            data = inputMerger.merge(inputs);
        }
        Data input = data;
        WorkerParameters params = new WorkerParameters(UUID.fromString(this.workSpecId), input, (Collection<String>)this.tags, this.runtimeExtras, this.workSpec.runAttemptCount, this.workSpec.getGeneration(), this.configuration.getExecutor(), this.workTaskExecutor, this.configuration.getWorkerFactory(), new WorkProgressUpdater(this.workDatabase, this.workTaskExecutor), new WorkForegroundUpdater(this.workDatabase, this.foregroundProcessor, this.workTaskExecutor));
        if (this.worker == null) {
            this.worker = this.configuration.getWorkerFactory().createWorkerWithDefaultFallback(this.appContext, this.workSpec.workerClassName, params);
        }
        if ((worker = this.worker) == null) {
            tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$loge = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string3 = "Could not create Worker " + this.workSpec.workerClassName;
            logger.error(string, string3);
            this.setFailedAndResolve();
            return;
        }
        if (worker.isUsed()) {
            tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$loge = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string4 = "Received an already-used Worker " + this.workSpec.workerClassName + "; Worker Factory should return new instances";
            logger.error(string, string4);
            this.setFailedAndResolve();
            return;
        }
        worker.setUsed();
        if (this.trySetRunning()) {
            if (this.tryCheckForInterruptionAndResolve()) {
                return;
            }
            WorkForegroundRunnable foregroundRunnable = new WorkForegroundRunnable(this.appContext, this.workSpec, worker, params.getForegroundUpdater(), this.workTaskExecutor);
            this.workTaskExecutor.getMainThreadExecutor().execute(foregroundRunnable);
            ListenableFuture<Void> listenableFuture = foregroundRunnable.getFuture();
            Intrinsics.checkNotNullExpressionValue(listenableFuture, (String)"foregroundRunnable.future");
            ListenableFuture<Void> runExpedited = listenableFuture;
            this.workerResultFuture.addListener(() -> WorkerWrapper.runWorker$lambda$5(this, runExpedited), new SynchronousExecutor());
            runExpedited.addListener(() -> WorkerWrapper.runWorker$lambda$7(this, runExpedited, worker), this.workTaskExecutor.getMainThreadExecutor());
            String workDescription = this.workDescription;
            this.workerResultFuture.addListener(() -> WorkerWrapper.runWorker$lambda$13(this, workDescription), this.workTaskExecutor.getSerialTaskExecutor());
        } else {
            this.resolveIncorrectStatus();
        }
    }

    private final void onWorkFinished() {
        if (!this.tryCheckForInterruptionAndResolve()) {
            this.workDatabase.runInTransaction(() -> WorkerWrapper.onWorkFinished$lambda$14(this));
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void interrupt(int stopReason) {
        this.interrupted = stopReason;
        this.tryCheckForInterruptionAndResolve();
        this.workerResultFuture.cancel(true);
        ListenableWorker worker = this.worker;
        if (worker != null && this.workerResultFuture.isCancelled()) {
            worker.stop(stopReason);
        } else {
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logd = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string2 = "WorkSpec " + this.workSpec + " is already done. Not interrupting.";
            logger.debug(string, string2);
        }
    }

    private final void resolveIncorrectStatus() {
        WorkInfo.State status = this.workSpecDao.getState(this.workSpecId);
        if (status == WorkInfo.State.RUNNING) {
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logd = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string2 = "Status for " + this.workSpecId + " is RUNNING; not doing any work and rescheduling for later execution";
            logger.debug(string, string2);
            this.resolve(true);
        } else {
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logd = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string3 = "Status for " + this.workSpecId + " is " + (Object)((Object)status) + " ; not doing any work";
            logger.debug(string, string3);
            this.resolve(false);
        }
    }

    private final boolean tryCheckForInterruptionAndResolve() {
        if (this.interrupted != -256) {
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logd = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string2 = "Work interrupted for " + this.workDescription;
            logger.debug(string, string2);
            WorkInfo.State currentState = this.workSpecDao.getState(this.workSpecId);
            if (currentState == null) {
                this.resolve(false);
            } else {
                this.resolve(!currentState.isFinished());
            }
            return true;
        }
        return false;
    }

    private final void resolve(boolean needsReschedule) {
        this.workDatabase.runInTransaction(() -> WorkerWrapper.resolve$lambda$19(this, needsReschedule));
        this._future.set(needsReschedule);
    }

    private final void handleResult(ListenableWorker.Result result) {
        if (result instanceof ListenableWorker.Result.Success) {
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logi = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string2 = "Worker result SUCCESS for " + this.workDescription;
            logger.info(string, string2);
            if (this.workSpec.isPeriodic()) {
                this.resetPeriodicAndResolve();
            } else {
                this.setSucceededAndResolve();
            }
        } else if (result instanceof ListenableWorker.Result.Retry) {
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logi = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string3 = "Worker result RETRY for " + this.workDescription;
            logger.info(string, string3);
            this.rescheduleAndResolve();
        } else {
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logi = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string4 = "Worker result FAILURE for " + this.workDescription;
            logger.info(string, string4);
            if (this.workSpec.isPeriodic()) {
                this.resetPeriodicAndResolve();
            } else {
                this.setFailedAndResolve();
            }
        }
    }

    private final boolean trySetRunning() {
        Object object = this.workDatabase.runInTransaction(() -> WorkerWrapper.trySetRunning$lambda$23(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"workDatabase.runInTransa\u2026lse false\n        }\n    )");
        return (Boolean)object;
    }

    @VisibleForTesting
    public final void setFailedAndResolve() {
        this.resolve(false, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WorkerWrapper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WorkerWrapper.access$iterativelyFailWorkAndDependents(this.this$0, WorkerWrapper.access$getWorkSpecId$p(this.this$0));
                ListenableWorker.Result result = WorkerWrapper.access$getResult$p(this.this$0);
                Intrinsics.checkNotNull((Object)result, (String)"null cannot be cast to non-null type androidx.work.ListenableWorker.Result.Failure");
                ListenableWorker.Result.Failure failure = (ListenableWorker.Result.Failure)result;
                Data data = failure.getOutputData();
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"failure.outputData");
                Data output = data;
                WorkerWrapper.access$getWorkSpecDao$p(this.this$0).resetWorkSpecNextScheduleTimeOverride(WorkerWrapper.access$getWorkSpecId$p(this.this$0), this.this$0.getWorkSpec().getNextScheduleTimeOverrideGeneration());
                WorkerWrapper.access$getWorkSpecDao$p(this.this$0).setOutput(WorkerWrapper.access$getWorkSpecId$p(this.this$0), output);
            }
        }));
    }

    private final void iterativelyFailWorkAndDependents(String workSpecId) {
        Object[] objectArray = new String[]{workSpecId};
        List idsToProcess = CollectionsKt.mutableListOf((Object[])objectArray);
        while (!((Collection)idsToProcess).isEmpty()) {
            String id = (String)CollectionsKt.removeLast((List)idsToProcess);
            if (this.workSpecDao.getState(id) != WorkInfo.State.CANCELLED) {
                this.workSpecDao.setState(WorkInfo.State.FAILED, id);
            }
            idsToProcess.addAll((Collection)this.dependencyDao.getDependentWorkIds(id));
        }
    }

    private final void rescheduleAndResolve() {
        this.resolve(true, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WorkerWrapper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WorkerWrapper.access$getWorkSpecDao$p(this.this$0).setState(WorkInfo.State.ENQUEUED, WorkerWrapper.access$getWorkSpecId$p(this.this$0));
                WorkerWrapper.access$getWorkSpecDao$p(this.this$0).setLastEnqueueTime(WorkerWrapper.access$getWorkSpecId$p(this.this$0), WorkerWrapper.access$getClock$p(this.this$0).currentTimeMillis());
                WorkerWrapper.access$getWorkSpecDao$p(this.this$0).resetWorkSpecNextScheduleTimeOverride(WorkerWrapper.access$getWorkSpecId$p(this.this$0), this.this$0.getWorkSpec().getNextScheduleTimeOverrideGeneration());
                WorkerWrapper.access$getWorkSpecDao$p(this.this$0).markWorkSpecScheduled(WorkerWrapper.access$getWorkSpecId$p(this.this$0), -1L);
            }
        }));
    }

    private final void resetPeriodicAndResolve() {
        this.resolve(false, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WorkerWrapper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WorkerWrapper.access$getWorkSpecDao$p(this.this$0).setLastEnqueueTime(WorkerWrapper.access$getWorkSpecId$p(this.this$0), WorkerWrapper.access$getClock$p(this.this$0).currentTimeMillis());
                WorkerWrapper.access$getWorkSpecDao$p(this.this$0).setState(WorkInfo.State.ENQUEUED, WorkerWrapper.access$getWorkSpecId$p(this.this$0));
                WorkerWrapper.access$getWorkSpecDao$p(this.this$0).resetWorkSpecRunAttemptCount(WorkerWrapper.access$getWorkSpecId$p(this.this$0));
                WorkerWrapper.access$getWorkSpecDao$p(this.this$0).resetWorkSpecNextScheduleTimeOverride(WorkerWrapper.access$getWorkSpecId$p(this.this$0), this.this$0.getWorkSpec().getNextScheduleTimeOverrideGeneration());
                WorkerWrapper.access$getWorkSpecDao$p(this.this$0).incrementPeriodCount(WorkerWrapper.access$getWorkSpecId$p(this.this$0));
                WorkerWrapper.access$getWorkSpecDao$p(this.this$0).markWorkSpecScheduled(WorkerWrapper.access$getWorkSpecId$p(this.this$0), -1L);
            }
        }));
    }

    private final void setSucceededAndResolve() {
        this.resolve(false, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WorkerWrapper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WorkerWrapper.access$getWorkSpecDao$p(this.this$0).setState(WorkInfo.State.SUCCEEDED, WorkerWrapper.access$getWorkSpecId$p(this.this$0));
                ListenableWorker.Result result = WorkerWrapper.access$getResult$p(this.this$0);
                Intrinsics.checkNotNull((Object)result, (String)"null cannot be cast to non-null type androidx.work.ListenableWorker.Result.Success");
                ListenableWorker.Result.Success success = (ListenableWorker.Result.Success)result;
                Data data = success.getOutputData();
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"success.outputData");
                Data output = data;
                WorkerWrapper.access$getWorkSpecDao$p(this.this$0).setOutput(WorkerWrapper.access$getWorkSpecId$p(this.this$0), output);
                long currentTimeMillis = WorkerWrapper.access$getClock$p(this.this$0).currentTimeMillis();
                List<String> dependentWorkIds = WorkerWrapper.access$getDependencyDao$p(this.this$0).getDependentWorkIds(WorkerWrapper.access$getWorkSpecId$p(this.this$0));
                for (String dependentWorkId : dependentWorkIds) {
                    if (WorkerWrapper.access$getWorkSpecDao$p(this.this$0).getState(dependentWorkId) != WorkInfo.State.BLOCKED || !WorkerWrapper.access$getDependencyDao$p(this.this$0).hasCompletedAllPrerequisites(dependentWorkId)) continue;
                    String tag$iv = WorkerWrapperKt.access$getTAG$p();
                    boolean $i$f$logi = false;
                    String string = tag$iv;
                    Logger logger = Logger.get();
                    boolean bl = false;
                    String string2 = "Setting status to enqueued for " + dependentWorkId;
                    logger.info(string, string2);
                    WorkerWrapper.access$getWorkSpecDao$p(this.this$0).setState(WorkInfo.State.ENQUEUED, dependentWorkId);
                    WorkerWrapper.access$getWorkSpecDao$p(this.this$0).setLastEnqueueTime(dependentWorkId, currentTimeMillis);
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resolve(boolean reschedule, Function0<Unit> block) {
        try {
            this.workDatabase.runInTransaction(() -> WorkerWrapper.resolve$lambda$24(block));
        }
        finally {
            this.resolve(reschedule);
        }
    }

    private final String createWorkDescription(List<String> tags) {
        return "Work [ id=" + this.workSpecId + ", tags={ " + CollectionsKt.joinToString$default((Iterable)tags, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + " } ]";
    }

    private static final Boolean runWorker$lambda$1(WorkerWrapper this$0) {
        long now;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.workSpec.state != WorkInfo.State.ENQUEUED) {
            this$0.resolveIncorrectStatus();
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logd = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string2 = this$0.workSpec.workerClassName + " is not in ENQUEUED state. Nothing more to do";
            logger.debug(string, string2);
            return true;
        }
        if ((this$0.workSpec.isPeriodic() || this$0.workSpec.isBackedOff()) && (now = this$0.clock.currentTimeMillis()) < this$0.workSpec.calculateNextRunTime()) {
            Logger.get().debug(WorkerWrapperKt.access$getTAG$p(), "Delaying execution for " + this$0.workSpec.workerClassName + " because it is being executed before schedule.");
            this$0.resolve(true);
            return true;
        }
        return false;
    }

    private static final void runWorker$lambda$5(WorkerWrapper this$0, ListenableFuture $runExpedited) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$runExpedited, (String)"$runExpedited");
        if (this$0.workerResultFuture.isCancelled()) {
            $runExpedited.cancel(true);
        }
    }

    private static final void runWorker$lambda$7(WorkerWrapper this$0, ListenableFuture $runExpedited, ListenableWorker $worker) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$runExpedited, (String)"$runExpedited");
        if (this$0.workerResultFuture.isCancelled()) {
            return;
        }
        try {
            $runExpedited.get();
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logd = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string2 = "Starting work for " + this$0.workSpec.workerClassName;
            logger.debug(string, string2);
            this$0.workerResultFuture.setFuture($worker.startWork());
        }
        catch (Throwable e) {
            this$0.workerResultFuture.setException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void runWorker$lambda$13(WorkerWrapper this$0, String $workDescription) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            ListenableWorker.Result result = (ListenableWorker.Result)this$0.workerResultFuture.get();
            if (result == null) {
                String tag$iv = WorkerWrapperKt.access$getTAG$p();
                boolean $i$f$loge = false;
                String string = tag$iv;
                Logger logger = Logger.get();
                boolean bl = false;
                String string2 = this$0.workSpec.workerClassName + " returned a null result. Treating it as a failure.";
                logger.error(string, string2);
            } else {
                String tag$iv = WorkerWrapperKt.access$getTAG$p();
                boolean $i$f$logd = false;
                String string = tag$iv;
                Logger logger = Logger.get();
                boolean bl = false;
                String string3 = this$0.workSpec.workerClassName + " returned a " + result + '.';
                logger.debug(string, string3);
                this$0.result = result;
            }
        }
        catch (CancellationException exception) {
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logi = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string4 = $workDescription + " was cancelled";
            logger.info(string, string4, exception);
        }
        catch (InterruptedException exception) {
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$loge = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string5 = $workDescription + " failed because it threw an exception/error";
            logger.error(string, string5, exception);
        }
        catch (ExecutionException exception) {
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$loge = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string6 = $workDescription + " failed because it threw an exception/error";
            logger.error(string, string6, exception);
        }
        finally {
            this$0.onWorkFinished();
        }
    }

    private static final void onWorkFinished$lambda$14(WorkerWrapper this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        WorkInfo.State state = this$0.workSpecDao.getState(this$0.workSpecId);
        this$0.workDatabase.workProgressDao().delete(this$0.workSpecId);
        if (state == null) {
            this$0.resolve(false);
        } else if (state == WorkInfo.State.RUNNING) {
            this$0.handleResult(this$0.result);
        } else if (!state.isFinished()) {
            this$0.interrupted = -512;
            this$0.rescheduleAndResolve();
        }
    }

    private static final void resolve$lambda$19(WorkerWrapper this$0, boolean $needsReschedule) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        boolean hasUnfinishedWork = this$0.workDatabase.workSpecDao().hasUnfinishedWork();
        if (!hasUnfinishedWork) {
            PackageManagerHelper.setComponentEnabled(this$0.appContext, RescheduleReceiver.class, false);
        }
        if ($needsReschedule) {
            this$0.workSpecDao.setState(WorkInfo.State.ENQUEUED, this$0.workSpecId);
            this$0.workSpecDao.setStopReason(this$0.workSpecId, this$0.interrupted);
            this$0.workSpecDao.markWorkSpecScheduled(this$0.workSpecId, -1L);
        }
    }

    private static final Boolean trySetRunning$lambda$23(WorkerWrapper this$0) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        WorkInfo.State currentState = this$0.workSpecDao.getState(this$0.workSpecId);
        if (currentState == WorkInfo.State.ENQUEUED) {
            this$0.workSpecDao.setState(WorkInfo.State.RUNNING, this$0.workSpecId);
            this$0.workSpecDao.incrementWorkSpecRunAttemptCount(this$0.workSpecId);
            this$0.workSpecDao.setStopReason(this$0.workSpecId, -256);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final void resolve$lambda$24(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    public static final /* synthetic */ void access$iterativelyFailWorkAndDependents(WorkerWrapper $this, String workSpecId) {
        $this.iterativelyFailWorkAndDependents(workSpecId);
    }

    public static final /* synthetic */ String access$getWorkSpecId$p(WorkerWrapper $this) {
        return $this.workSpecId;
    }

    public static final /* synthetic */ ListenableWorker.Result access$getResult$p(WorkerWrapper $this) {
        return $this.result;
    }

    public static final /* synthetic */ WorkSpecDao access$getWorkSpecDao$p(WorkerWrapper $this) {
        return $this.workSpecDao;
    }

    public static final /* synthetic */ Clock access$getClock$p(WorkerWrapper $this) {
        return $this.clock;
    }

    public static final /* synthetic */ DependencyDao access$getDependencyDao$p(WorkerWrapper $this) {
        return $this.dependencyDao;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001BE\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u00100\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(H\u0007R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u00061"}, d2={"Landroidx/work/impl/WorkerWrapper$Builder;", "", "context", "Landroid/content/Context;", "configuration", "Landroidx/work/Configuration;", "workTaskExecutor", "Landroidx/work/impl/utils/taskexecutor/TaskExecutor;", "foregroundProcessor", "Landroidx/work/impl/foreground/ForegroundProcessor;", "workDatabase", "Landroidx/work/impl/WorkDatabase;", "workSpec", "Landroidx/work/impl/model/WorkSpec;", "tags", "", "", "(Landroid/content/Context;Landroidx/work/Configuration;Landroidx/work/impl/utils/taskexecutor/TaskExecutor;Landroidx/work/impl/foreground/ForegroundProcessor;Landroidx/work/impl/WorkDatabase;Landroidx/work/impl/model/WorkSpec;Ljava/util/List;)V", "appContext", "getAppContext", "()Landroid/content/Context;", "getConfiguration", "()Landroidx/work/Configuration;", "getForegroundProcessor", "()Landroidx/work/impl/foreground/ForegroundProcessor;", "runtimeExtras", "Landroidx/work/WorkerParameters$RuntimeExtras;", "getRuntimeExtras", "()Landroidx/work/WorkerParameters$RuntimeExtras;", "setRuntimeExtras", "(Landroidx/work/WorkerParameters$RuntimeExtras;)V", "getTags", "()Ljava/util/List;", "getWorkDatabase", "()Landroidx/work/impl/WorkDatabase;", "getWorkSpec", "()Landroidx/work/impl/model/WorkSpec;", "getWorkTaskExecutor", "()Landroidx/work/impl/utils/taskexecutor/TaskExecutor;", "worker", "Landroidx/work/ListenableWorker;", "getWorker", "()Landroidx/work/ListenableWorker;", "setWorker", "(Landroidx/work/ListenableWorker;)V", "build", "Landroidx/work/impl/WorkerWrapper;", "withRuntimeExtras", "withWorker", "work-runtime_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Builder {
        @NotNull
        private final Configuration configuration;
        @NotNull
        private final TaskExecutor workTaskExecutor;
        @NotNull
        private final ForegroundProcessor foregroundProcessor;
        @NotNull
        private final WorkDatabase workDatabase;
        @NotNull
        private final WorkSpec workSpec;
        @NotNull
        private final List<String> tags;
        @NotNull
        private final Context appContext;
        @Nullable
        private ListenableWorker worker;
        @NotNull
        private WorkerParameters.RuntimeExtras runtimeExtras;

        @SuppressLint(value={"LambdaLast"})
        public Builder(@NotNull Context context, @NotNull Configuration configuration, @NotNull TaskExecutor workTaskExecutor, @NotNull ForegroundProcessor foregroundProcessor, @NotNull WorkDatabase workDatabase, @NotNull WorkSpec workSpec, @NotNull List<String> tags) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)workTaskExecutor, (String)"workTaskExecutor");
            Intrinsics.checkNotNullParameter((Object)foregroundProcessor, (String)"foregroundProcessor");
            Intrinsics.checkNotNullParameter((Object)((Object)workDatabase), (String)"workDatabase");
            Intrinsics.checkNotNullParameter((Object)workSpec, (String)"workSpec");
            Intrinsics.checkNotNullParameter(tags, (String)"tags");
            this.configuration = configuration;
            this.workTaskExecutor = workTaskExecutor;
            this.foregroundProcessor = foregroundProcessor;
            this.workDatabase = workDatabase;
            this.workSpec = workSpec;
            this.tags = tags;
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
            this.appContext = context2;
            this.runtimeExtras = new WorkerParameters.RuntimeExtras();
        }

        @NotNull
        public final Configuration getConfiguration() {
            return this.configuration;
        }

        @NotNull
        public final TaskExecutor getWorkTaskExecutor() {
            return this.workTaskExecutor;
        }

        @NotNull
        public final ForegroundProcessor getForegroundProcessor() {
            return this.foregroundProcessor;
        }

        @NotNull
        public final WorkDatabase getWorkDatabase() {
            return this.workDatabase;
        }

        @NotNull
        public final WorkSpec getWorkSpec() {
            return this.workSpec;
        }

        @NotNull
        public final List<String> getTags() {
            return this.tags;
        }

        @NotNull
        public final Context getAppContext() {
            return this.appContext;
        }

        @Nullable
        public final ListenableWorker getWorker() {
            return this.worker;
        }

        public final void setWorker(@Nullable ListenableWorker listenableWorker) {
            this.worker = listenableWorker;
        }

        @NotNull
        public final WorkerParameters.RuntimeExtras getRuntimeExtras() {
            return this.runtimeExtras;
        }

        public final void setRuntimeExtras(@NotNull WorkerParameters.RuntimeExtras runtimeExtras) {
            Intrinsics.checkNotNullParameter((Object)runtimeExtras, (String)"<set-?>");
            this.runtimeExtras = runtimeExtras;
        }

        @NotNull
        public final Builder withRuntimeExtras(@Nullable WorkerParameters.RuntimeExtras runtimeExtras) {
            if (runtimeExtras != null) {
                this.runtimeExtras = runtimeExtras;
            }
            return this;
        }

        @VisibleForTesting
        @NotNull
        public final Builder withWorker(@NotNull ListenableWorker worker) {
            Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
            this.worker = worker;
            return this;
        }

        @NotNull
        public final WorkerWrapper build() {
            return new WorkerWrapper(this);
        }
    }
}

