/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.annotation.SuppressLint;
import android.net.NetworkRequest;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.room.ColumnInfo;
import androidx.room.Ignore;
import androidx.work.NetworkType;
import androidx.work.impl.utils.DurationApi26Impl;
import androidx.work.impl.utils.NetworkRequest30;
import androidx.work.impl.utils.NetworkRequestCompat;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 +2\u00020\u0001:\u0003*+,B/\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bB9\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB]\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011Be\b\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0014B\u000f\b\u0017\u0012\u0006\u0010\u0015\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010$\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0097\u0002J\b\u0010%\u001a\u00020\u0005H\u0007J\b\u0010&\u001a\u00020'H\u0017J\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\t\u001a\u00020\u0005H\u0007J\u0006\u0010\u0007\u001a\u00020\u0005J\b\u0010(\u001a\u00020)H\u0017R\u0016\u0010\r\u001a\u00020\f8GX\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u000b\u001a\u00020\f8GX\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8GX\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d8G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010\u0012\u001a\u00020\u00138\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0010\u0010\u0006\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Landroidx/work/Constraints;", "", "requiredNetworkType", "Landroidx/work/NetworkType;", "requiresCharging", "", "requiresBatteryNotLow", "requiresStorageNotLow", "(Landroidx/work/NetworkType;ZZZ)V", "requiresDeviceIdle", "(Landroidx/work/NetworkType;ZZZZ)V", "contentTriggerUpdateDelayMillis", "", "contentTriggerMaxDelayMillis", "contentUriTriggers", "", "Landroidx/work/Constraints$ContentUriTrigger;", "(Landroidx/work/NetworkType;ZZZZJJLjava/util/Set;)V", "requiredNetworkRequestCompat", "Landroidx/work/impl/utils/NetworkRequestCompat;", "(Landroidx/work/impl/utils/NetworkRequestCompat;Landroidx/work/NetworkType;ZZZZJJLjava/util/Set;)V", "other", "(Landroidx/work/Constraints;)V", "getContentTriggerMaxDelayMillis", "()J", "getContentTriggerUpdateDelayMillis", "getContentUriTriggers", "()Ljava/util/Set;", "requiredNetworkRequest", "Landroid/net/NetworkRequest;", "getRequiredNetworkRequest", "()Landroid/net/NetworkRequest;", "getRequiredNetworkRequestCompat$work_runtime_release", "()Landroidx/work/impl/utils/NetworkRequestCompat;", "getRequiredNetworkType", "()Landroidx/work/NetworkType;", "equals", "hasContentUriTriggers", "hashCode", "", "toString", "", "Builder", "Companion", "ContentUriTrigger", "work-runtime_release"})
public final class Constraints {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @ColumnInfo(name="required_network_type")
    @NotNull
    private final NetworkType requiredNetworkType;
    @ColumnInfo(name="required_network_request", defaultValue="x''")
    @NotNull
    private final NetworkRequestCompat requiredNetworkRequestCompat;
    @ColumnInfo(name="requires_charging")
    private final boolean requiresCharging;
    @ColumnInfo(name="requires_device_idle")
    private final boolean requiresDeviceIdle;
    @ColumnInfo(name="requires_battery_not_low")
    private final boolean requiresBatteryNotLow;
    @ColumnInfo(name="requires_storage_not_low")
    private final boolean requiresStorageNotLow;
    @ColumnInfo(name="trigger_content_update_delay")
    private final long contentTriggerUpdateDelayMillis;
    @ColumnInfo(name="trigger_max_content_delay")
    private final long contentTriggerMaxDelayMillis;
    @ColumnInfo(name="content_uri_triggers")
    @NotNull
    private final Set<ContentUriTrigger> contentUriTriggers;
    @JvmField
    @NotNull
    public static final Constraints NONE = new Constraints(null, false, false, false, 15, null);

    @NotNull
    public final NetworkType getRequiredNetworkType() {
        return this.requiredNetworkType;
    }

    @RequiresApi(value=21)
    @Nullable
    public final NetworkRequest getRequiredNetworkRequest() {
        return this.requiredNetworkRequestCompat.getNetworkRequest();
    }

    @NotNull
    public final NetworkRequestCompat getRequiredNetworkRequestCompat$work_runtime_release() {
        return this.requiredNetworkRequestCompat;
    }

    @RequiresApi(value=24)
    public final long getContentTriggerUpdateDelayMillis() {
        return this.contentTriggerUpdateDelayMillis;
    }

    @RequiresApi(value=24)
    public final long getContentTriggerMaxDelayMillis() {
        return this.contentTriggerMaxDelayMillis;
    }

    @RequiresApi(value=24)
    @NotNull
    public final Set<ContentUriTrigger> getContentUriTriggers() {
        return this.contentUriTriggers;
    }

    @Ignore
    @SuppressLint(value={"NewApi"})
    public Constraints(@NotNull NetworkType requiredNetworkType, boolean requiresCharging, boolean requiresBatteryNotLow, boolean requiresStorageNotLow) {
        Intrinsics.checkNotNullParameter((Object)((Object)requiredNetworkType), (String)"requiredNetworkType");
        this(requiredNetworkType, requiresCharging, false, requiresBatteryNotLow, requiresStorageNotLow);
    }

    public /* synthetic */ Constraints(NetworkType networkType, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            networkType = NetworkType.NOT_REQUIRED;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        this(networkType, bl, bl2, bl3);
    }

    @Ignore
    @SuppressLint(value={"NewApi"})
    @RequiresApi(value=23)
    public Constraints(@NotNull NetworkType requiredNetworkType, boolean requiresCharging, boolean requiresDeviceIdle, boolean requiresBatteryNotLow, boolean requiresStorageNotLow) {
        Intrinsics.checkNotNullParameter((Object)((Object)requiredNetworkType), (String)"requiredNetworkType");
        this(requiredNetworkType, requiresCharging, requiresDeviceIdle, requiresBatteryNotLow, requiresStorageNotLow, -1L, 0L, null, 192, null);
    }

    public /* synthetic */ Constraints(NetworkType networkType, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            networkType = NetworkType.NOT_REQUIRED;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        this(networkType, bl, bl2, bl3, bl4);
    }

    @Ignore
    @RequiresApi(value=24)
    public Constraints(@NotNull NetworkType requiredNetworkType, boolean requiresCharging, boolean requiresDeviceIdle, boolean requiresBatteryNotLow, boolean requiresStorageNotLow, long contentTriggerUpdateDelayMillis, long contentTriggerMaxDelayMillis, @NotNull Set<ContentUriTrigger> contentUriTriggers) {
        Intrinsics.checkNotNullParameter((Object)((Object)requiredNetworkType), (String)"requiredNetworkType");
        Intrinsics.checkNotNullParameter(contentUriTriggers, (String)"contentUriTriggers");
        this.requiredNetworkRequestCompat = new NetworkRequestCompat(null, 1, null);
        this.requiredNetworkType = requiredNetworkType;
        this.requiresCharging = requiresCharging;
        this.requiresDeviceIdle = requiresDeviceIdle;
        this.requiresBatteryNotLow = requiresBatteryNotLow;
        this.requiresStorageNotLow = requiresStorageNotLow;
        this.contentTriggerUpdateDelayMillis = contentTriggerUpdateDelayMillis;
        this.contentTriggerMaxDelayMillis = contentTriggerMaxDelayMillis;
        this.contentUriTriggers = contentUriTriggers;
    }

    public /* synthetic */ Constraints(NetworkType networkType, boolean bl, boolean bl2, boolean bl3, boolean bl4, long l, long l2, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            networkType = NetworkType.NOT_REQUIRED;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        if ((n & 0x20) != 0) {
            l = -1L;
        }
        if ((n & 0x40) != 0) {
            l2 = -1L;
        }
        if ((n & 0x80) != 0) {
            set = SetsKt.emptySet();
        }
        this(networkType, bl, bl2, bl3, bl4, l, l2, set);
    }

    public Constraints(@NotNull NetworkRequestCompat requiredNetworkRequestCompat, @NotNull NetworkType requiredNetworkType, boolean requiresCharging, boolean requiresDeviceIdle, boolean requiresBatteryNotLow, boolean requiresStorageNotLow, long contentTriggerUpdateDelayMillis, long contentTriggerMaxDelayMillis, @NotNull Set<ContentUriTrigger> contentUriTriggers) {
        Intrinsics.checkNotNullParameter((Object)requiredNetworkRequestCompat, (String)"requiredNetworkRequestCompat");
        Intrinsics.checkNotNullParameter((Object)((Object)requiredNetworkType), (String)"requiredNetworkType");
        Intrinsics.checkNotNullParameter(contentUriTriggers, (String)"contentUriTriggers");
        this.requiredNetworkRequestCompat = requiredNetworkRequestCompat;
        this.requiredNetworkType = requiredNetworkType;
        this.requiresCharging = requiresCharging;
        this.requiresDeviceIdle = requiresDeviceIdle;
        this.requiresBatteryNotLow = requiresBatteryNotLow;
        this.requiresStorageNotLow = requiresStorageNotLow;
        this.contentTriggerUpdateDelayMillis = contentTriggerUpdateDelayMillis;
        this.contentTriggerMaxDelayMillis = contentTriggerMaxDelayMillis;
        this.contentUriTriggers = contentUriTriggers;
    }

    public /* synthetic */ Constraints(NetworkRequestCompat networkRequestCompat, NetworkType networkType, boolean bl, boolean bl2, boolean bl3, boolean bl4, long l, long l2, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            networkType = NetworkType.NOT_REQUIRED;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        if ((n & 0x20) != 0) {
            bl4 = false;
        }
        if ((n & 0x40) != 0) {
            l = -1L;
        }
        if ((n & 0x80) != 0) {
            l2 = -1L;
        }
        if ((n & 0x100) != 0) {
            set = SetsKt.emptySet();
        }
        this(networkRequestCompat, networkType, bl, bl2, bl3, bl4, l, l2, set);
    }

    @SuppressLint(value={"NewApi"})
    public Constraints(@NotNull Constraints other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.requiresCharging = other.requiresCharging;
        this.requiresDeviceIdle = other.requiresDeviceIdle;
        this.requiredNetworkRequestCompat = other.requiredNetworkRequestCompat;
        this.requiredNetworkType = other.requiredNetworkType;
        this.requiresBatteryNotLow = other.requiresBatteryNotLow;
        this.requiresStorageNotLow = other.requiresStorageNotLow;
        this.contentUriTriggers = other.contentUriTriggers;
        this.contentTriggerUpdateDelayMillis = other.contentTriggerUpdateDelayMillis;
        this.contentTriggerMaxDelayMillis = other.contentTriggerMaxDelayMillis;
    }

    public final boolean requiresCharging() {
        return this.requiresCharging;
    }

    @RequiresApi(value=23)
    public final boolean requiresDeviceIdle() {
        return this.requiresDeviceIdle;
    }

    public final boolean requiresBatteryNotLow() {
        return this.requiresBatteryNotLow;
    }

    public final boolean requiresStorageNotLow() {
        return this.requiresStorageNotLow;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean hasContentUriTriggers() {
        return Build.VERSION.SDK_INT < 24 || !((Collection)this.contentUriTriggers).isEmpty();
    }

    @SuppressLint(value={"NewApi"})
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        Constraints that = (Constraints)other;
        if (this.requiresCharging != that.requiresCharging) {
            return false;
        }
        if (this.requiresDeviceIdle != that.requiresDeviceIdle) {
            return false;
        }
        if (this.requiresBatteryNotLow != that.requiresBatteryNotLow) {
            return false;
        }
        if (this.requiresStorageNotLow != that.requiresStorageNotLow) {
            return false;
        }
        if (this.contentTriggerUpdateDelayMillis != that.contentTriggerUpdateDelayMillis) {
            return false;
        }
        if (this.contentTriggerMaxDelayMillis != that.contentTriggerMaxDelayMillis) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getRequiredNetworkRequest(), (Object)that.getRequiredNetworkRequest())) {
            return false;
        }
        return this.requiredNetworkType != that.requiredNetworkType ? false : Intrinsics.areEqual(this.contentUriTriggers, that.contentUriTriggers);
    }

    @SuppressLint(value={"NewApi"})
    public int hashCode() {
        int result = this.requiredNetworkType.hashCode();
        result = 31 * result + (this.requiresCharging ? 1 : 0);
        result = 31 * result + (this.requiresDeviceIdle ? 1 : 0);
        result = 31 * result + (this.requiresBatteryNotLow ? 1 : 0);
        result = 31 * result + (this.requiresStorageNotLow ? 1 : 0);
        result = 31 * result + (int)(this.contentTriggerUpdateDelayMillis ^ this.contentTriggerUpdateDelayMillis >>> 32);
        result = 31 * result + (int)(this.contentTriggerMaxDelayMillis ^ this.contentTriggerMaxDelayMillis >>> 32);
        result = 31 * result + ((Object)this.contentUriTriggers).hashCode();
        NetworkRequest networkRequest = this.getRequiredNetworkRequest();
        result = 31 * result + (networkRequest != null ? networkRequest.hashCode() : 0);
        return result;
    }

    @SuppressLint(value={"NewApi"})
    @NotNull
    public String toString() {
        return "Constraints{requiredNetworkType=" + (Object)((Object)this.requiredNetworkType) + ", requiresCharging=" + this.requiresCharging + ", requiresDeviceIdle=" + this.requiresDeviceIdle + ", requiresBatteryNotLow=" + this.requiresBatteryNotLow + ", requiresStorageNotLow=" + this.requiresStorageNotLow + ", contentTriggerUpdateDelayMillis=" + this.contentTriggerUpdateDelayMillis + ", contentTriggerMaxDelayMillis=" + this.contentTriggerMaxDelayMillis + ", contentUriTriggers=" + this.contentUriTriggers + ", }";
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eH\u0007J\u0006\u0010\u0019\u001a\u00020\u0004J\u0018\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fH\u0007J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\fJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000eJ\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000eH\u0007J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000eJ\u0010\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%H\u0007J\u0018\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'H\u0007J\u0010\u0010(\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%H\u0007J\u0018\u0010(\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'H\u0007R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Landroidx/work/Constraints$Builder;", "", "()V", "constraints", "Landroidx/work/Constraints;", "(Landroidx/work/Constraints;)V", "contentUriTriggers", "", "Landroidx/work/Constraints$ContentUriTrigger;", "requiredNetworkRequest", "Landroidx/work/impl/utils/NetworkRequestCompat;", "requiredNetworkType", "Landroidx/work/NetworkType;", "requiresBatteryNotLow", "", "requiresCharging", "requiresDeviceIdle", "requiresStorageNotLow", "triggerContentMaxDelay", "", "triggerContentUpdateDelay", "addContentUriTrigger", "uri", "Landroid/net/Uri;", "triggerForDescendants", "build", "setRequiredNetworkRequest", "networkRequest", "Landroid/net/NetworkRequest;", "networkType", "setRequiredNetworkType", "setRequiresBatteryNotLow", "setRequiresCharging", "setRequiresDeviceIdle", "setRequiresStorageNotLow", "setTriggerContentMaxDelay", "duration", "Ljava/time/Duration;", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "setTriggerContentUpdateDelay", "work-runtime_release"})
    public static final class Builder {
        private boolean requiresCharging;
        private boolean requiresDeviceIdle;
        @NotNull
        private NetworkRequestCompat requiredNetworkRequest;
        @NotNull
        private NetworkType requiredNetworkType;
        private boolean requiresBatteryNotLow;
        private boolean requiresStorageNotLow;
        private long triggerContentUpdateDelay;
        private long triggerContentMaxDelay;
        @NotNull
        private Set<ContentUriTrigger> contentUriTriggers;

        public Builder() {
            this.requiredNetworkRequest = new NetworkRequestCompat(null, 1, null);
            this.requiredNetworkType = NetworkType.NOT_REQUIRED;
            this.triggerContentUpdateDelay = -1L;
            this.triggerContentMaxDelay = -1L;
            this.contentUriTriggers = new LinkedHashSet();
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder(@NotNull Constraints constraints) {
            Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
            this.requiredNetworkRequest = new NetworkRequestCompat(null, 1, null);
            this.requiredNetworkType = NetworkType.NOT_REQUIRED;
            this.triggerContentUpdateDelay = -1L;
            this.triggerContentMaxDelay = -1L;
            this.contentUriTriggers = new LinkedHashSet();
            this.requiresCharging = constraints.requiresCharging();
            this.requiresDeviceIdle = Build.VERSION.SDK_INT >= 23 && constraints.requiresDeviceIdle();
            this.requiredNetworkType = constraints.getRequiredNetworkType();
            this.requiresBatteryNotLow = constraints.requiresBatteryNotLow();
            this.requiresStorageNotLow = constraints.requiresStorageNotLow();
            if (Build.VERSION.SDK_INT >= 24) {
                this.triggerContentUpdateDelay = constraints.getContentTriggerUpdateDelayMillis();
                this.triggerContentMaxDelay = constraints.getContentTriggerMaxDelayMillis();
                this.contentUriTriggers = CollectionsKt.toMutableSet((Iterable)constraints.getContentUriTriggers());
            }
        }

        @NotNull
        public final Builder setRequiresCharging(boolean requiresCharging) {
            this.requiresCharging = requiresCharging;
            return this;
        }

        @RequiresApi(value=23)
        @NotNull
        public final Builder setRequiresDeviceIdle(boolean requiresDeviceIdle) {
            this.requiresDeviceIdle = requiresDeviceIdle;
            return this;
        }

        @NotNull
        public final Builder setRequiredNetworkType(@NotNull NetworkType networkType) {
            Intrinsics.checkNotNullParameter((Object)((Object)networkType), (String)"networkType");
            this.requiredNetworkType = networkType;
            this.requiredNetworkRequest = new NetworkRequestCompat(null, 1, null);
            return this;
        }

        @RequiresApi(value=21)
        @NotNull
        public final Builder setRequiredNetworkRequest(@NotNull NetworkRequest networkRequest, @NotNull NetworkType networkType) {
            Intrinsics.checkNotNullParameter((Object)networkRequest, (String)"networkRequest");
            Intrinsics.checkNotNullParameter((Object)((Object)networkType), (String)"networkType");
            if (Build.VERSION.SDK_INT >= 28) {
                if (Build.VERSION.SDK_INT >= 31 && NetworkRequest30.INSTANCE.getNetworkSpecifier(networkRequest) != null) {
                    throw new IllegalArgumentException("NetworkRequests with NetworkSpecifiers set aren't supported.");
                }
                this.requiredNetworkRequest = new NetworkRequestCompat(networkRequest);
                this.requiredNetworkType = NetworkType.NOT_REQUIRED;
            } else {
                this.requiredNetworkType = networkType;
            }
            return this;
        }

        @NotNull
        public final Builder setRequiresBatteryNotLow(boolean requiresBatteryNotLow) {
            this.requiresBatteryNotLow = requiresBatteryNotLow;
            return this;
        }

        @NotNull
        public final Builder setRequiresStorageNotLow(boolean requiresStorageNotLow) {
            this.requiresStorageNotLow = requiresStorageNotLow;
            return this;
        }

        @RequiresApi(value=24)
        @NotNull
        public final Builder addContentUriTrigger(@NotNull Uri uri, boolean triggerForDescendants) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            this.contentUriTriggers.add(new ContentUriTrigger(uri, triggerForDescendants));
            return this;
        }

        @RequiresApi(value=24)
        @NotNull
        public final Builder setTriggerContentUpdateDelay(long duration, @NotNull TimeUnit timeUnit) {
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
            this.triggerContentUpdateDelay = timeUnit.toMillis(duration);
            return this;
        }

        @RequiresApi(value=26)
        @NotNull
        public final Builder setTriggerContentUpdateDelay(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            this.triggerContentUpdateDelay = DurationApi26Impl.toMillisCompat(duration);
            return this;
        }

        @RequiresApi(value=24)
        @NotNull
        public final Builder setTriggerContentMaxDelay(long duration, @NotNull TimeUnit timeUnit) {
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
            this.triggerContentMaxDelay = timeUnit.toMillis(duration);
            return this;
        }

        @RequiresApi(value=26)
        @NotNull
        public final Builder setTriggerContentMaxDelay(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            this.triggerContentMaxDelay = DurationApi26Impl.toMillisCompat(duration);
            return this;
        }

        @NotNull
        public final Constraints build() {
            Set contentUriTriggers = null;
            long triggerContentUpdateDelay = 0L;
            long triggerMaxContentDelay = 0L;
            if (Build.VERSION.SDK_INT >= 24) {
                contentUriTriggers = CollectionsKt.toSet((Iterable)this.contentUriTriggers);
                triggerContentUpdateDelay = this.triggerContentUpdateDelay;
                triggerMaxContentDelay = this.triggerContentMaxDelay;
            } else {
                contentUriTriggers = SetsKt.emptySet();
                triggerContentUpdateDelay = -1L;
                triggerMaxContentDelay = -1L;
            }
            NetworkRequestCompat networkRequestCompat = this.requiredNetworkRequest;
            NetworkType networkType = this.requiredNetworkType;
            boolean bl = this.requiresCharging;
            boolean bl2 = Build.VERSION.SDK_INT >= 23 && this.requiresDeviceIdle;
            boolean bl3 = this.requiresBatteryNotLow;
            boolean bl4 = this.requiresStorageNotLow;
            return new Constraints(networkRequestCompat, networkType, bl, bl2, bl3, bl4, triggerContentUpdateDelay, triggerMaxContentDelay, contentUriTriggers);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/work/Constraints$Companion;", "", "()V", "NONE", "Landroidx/work/Constraints;", "work-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Landroidx/work/Constraints$ContentUriTrigger;", "", "uri", "Landroid/net/Uri;", "isTriggeredForDescendants", "", "(Landroid/net/Uri;Z)V", "()Z", "getUri", "()Landroid/net/Uri;", "equals", "other", "hashCode", "", "work-runtime_release"})
    public static final class ContentUriTrigger {
        @NotNull
        private final Uri uri;
        private final boolean isTriggeredForDescendants;

        public ContentUriTrigger(@NotNull Uri uri, boolean isTriggeredForDescendants) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            this.uri = uri;
            this.isTriggeredForDescendants = isTriggeredForDescendants;
        }

        @NotNull
        public final Uri getUri() {
            return this.uri;
        }

        public final boolean isTriggeredForDescendants() {
            return this.isTriggeredForDescendants;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type androidx.work.Constraints.ContentUriTrigger");
            ContentUriTrigger cfr_ignored_0 = (ContentUriTrigger)other;
            if (!Intrinsics.areEqual((Object)this.uri, (Object)((ContentUriTrigger)other).uri)) {
                return false;
            }
            return this.isTriggeredForDescendants == ((ContentUriTrigger)other).isTriggeredForDescendants;
        }

        public int hashCode() {
            int result = this.uri.hashCode();
            result = 31 * result + Boolean.hashCode(this.isTriggeredForDescendants);
            return result;
        }
    }
}

