/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events.discovery;

import android.os.Parcel;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.TestCaseInfo;
import androidx.test.services.events.discovery.TestDiscoveryEvent;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TestFoundEvent
extends TestDiscoveryEvent {
    @NonNull
    public final TestCaseInfo testCase;

    public TestFoundEvent(@NonNull TestCaseInfo testCase) {
        Checks.checkNotNull((Object)testCase, (Object)"testCase cannot be null");
        this.testCase = testCase;
    }

    TestFoundEvent(Parcel source) {
        this.testCase = new TestCaseInfo(source);
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        this.testCase.writeToParcel(parcel, i);
    }

    @Override
    TestDiscoveryEvent.EventType instanceType() {
        return TestDiscoveryEvent.EventType.TEST_FOUND;
    }
}

