/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.permission;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.test.runner.permission.RequestPermissionCallable;
import androidx.test.runner.permission.ShellCommand;

class GrantPermissionCallable
extends RequestPermissionCallable {
    private static final String TAG = "GrantPermissionCallable";

    GrantPermissionCallable(@NonNull ShellCommand shellCommand, @NonNull Context context, String permission) {
        super(shellCommand, context, permission);
    }

    @Override
    public RequestPermissionCallable.Result call() throws Exception {
        if (this.isPermissionGranted()) {
            Log.i((String)TAG, (String)("Permission: " + this.getPermission() + " is already granted!"));
            return RequestPermissionCallable.Result.SUCCESS;
        }
        ShellCommand cmdForPermission = this.getShellCommand();
        try {
            cmdForPermission.execute();
        }
        finally {
            if (!this.isPermissionGranted()) {
                Thread.sleep(1000L);
                if (!this.isPermissionGranted()) {
                    Log.e((String)TAG, (String)("Permission: " + this.getPermission() + " cannot be granted!"));
                    return RequestPermissionCallable.Result.FAILURE;
                }
            }
        }
        return RequestPermissionCallable.Result.SUCCESS;
    }
}

