/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.listener;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.tracing.Trace;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

public class TraceRunListener
extends RunListener {
    private static final String TAG = TraceRunListener.class.getSimpleName();
    private static final int MAX_SECTION_NAME_LEN = 127;
    private Thread startedThread = null;

    @NonNull
    private static String sanitizeSpanName(@NonNull String name) {
        if (name.length() > 127) {
            String string = name;
            Log.w((String)TAG, (String)("Span name exceeds limits: " + string));
            name = name.substring(0, 127);
        }
        return name;
    }

    public void testFinished(Description description) throws Exception {
        if (Thread.currentThread().equals(this.startedThread)) {
            Trace.endSection();
        } else {
            Log.e((String)"TraceRunListener", (String)"testFinished called on different thread than testStarted");
        }
        this.startedThread = null;
    }

    public void testStarted(Description description) throws Exception {
        String methodName;
        this.startedThread = Thread.currentThread();
        String testClassName = description.getTestClass() != null ? description.getTestClass().getSimpleName() : "None";
        String string = methodName = description.getMethodName() != null ? description.getMethodName() : "None";
        String string2 = testClassName;
        Trace.beginSection((String)TraceRunListener.sanitizeSpanName(string2 + "#" + string));
    }
}

