/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.junit3;

import android.util.Log;
import androidx.test.internal.runner.junit3.AndroidTestSuite;
import androidx.test.internal.runner.junit3.JUnit38ClassRunner;
import androidx.test.internal.util.AndroidRunnerParams;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.internal.builders.SuiteMethodBuilder;
import org.junit.internal.runners.SuiteMethod;
import org.junit.runner.Runner;

public class AndroidSuiteBuilder
extends SuiteMethodBuilder {
    private static final String LOG_TAG = "AndroidSuiteBuilder";
    private final AndroidRunnerParams androidRunnerParams;

    public Runner runnerForClass(Class<?> testClass) throws Throwable {
        if (this.androidRunnerParams.isIgnoreSuiteMethods()) {
            return null;
        }
        try {
            if (this.hasSuiteMethod(testClass)) {
                Test t = SuiteMethod.testFromSuiteMethod(testClass);
                if (!(t instanceof TestSuite)) {
                    String string = testClass.getName();
                    throw new IllegalArgumentException(string + "#suite() did not return a TestSuite");
                }
                return new JUnit38ClassRunner((Test)new AndroidTestSuite((TestSuite)t, this.androidRunnerParams));
            }
        }
        catch (Throwable e) {
            Log.e((String)LOG_TAG, (String)"Error constructing runner", (Throwable)e);
            throw e;
        }
        return null;
    }

    public AndroidSuiteBuilder(AndroidRunnerParams runnerParams) {
        this.androidRunnerParams = runnerParams;
    }
}

