/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events.internal;

import androidx.test.services.events.internal.Throwables$State-IA;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class Throwables {
    private static final String[] TEST_FRAMEWORK_METHOD_NAME_PREFIXES = new String[]{"org.junit.runner.", "org.junit.runners.", "org.junit.experimental.runners.", "org.junit.internal.", "junit."};
    private static final String[] TEST_FRAMEWORK_TEST_METHOD_NAME_PREFIXES = new String[]{"org.junit.internal.StackTracesTest"};
    private static final String[] REFLECTION_METHOD_NAME_PREFIXES = new String[]{"sun.reflect.", "java.lang.reflect.", "jdk.internal.reflect.", "org.junit.rules.RunRules.<init>(", "org.junit.rules.RunRules.applyAll(", "org.junit.runners.BlockJUnit4ClassRunner.withMethodRules(", "junit.framework.TestCase.runBare("};

    private static String getFullStackTrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        exception.printStackTrace(writer);
        return stringWriter.toString();
    }

    public static String getTrimmedStackTrace(Throwable exception) {
        List<String> trimmedStackTraceLines = Throwables.getTrimmedStackTraceLines(exception);
        if (trimmedStackTraceLines.isEmpty()) {
            return Throwables.getFullStackTrace(exception);
        }
        StringBuilder result = new StringBuilder(exception.toString());
        Throwables.appendStackTraceLines(trimmedStackTraceLines, result);
        Throwables.appendStackTraceLines(Throwables.getCauseStackTraceLines(exception), result);
        return result.toString();
    }

    private static <T> List<T> asReversedList(final List<T> list) {
        return new AbstractList<T>(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public T get(int index) {
                return list.get(list.size() - index - 1);
            }
        };
    }

    private static List<String> getCauseStackTraceLines(Throwable exception) {
        if (exception.getCause() != null) {
            String fullTrace = Throwables.getFullStackTrace(exception);
            BufferedReader reader = new BufferedReader(new StringReader(fullTrace.substring(exception.toString().length())));
            ArrayList<String> causedByLines = new ArrayList<String>();
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("Caused by: ")) continue;
                    causedByLines.add(line);
                    while ((line = reader.readLine()) != null) {
                        causedByLines.add(line);
                    }
                    return causedByLines;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private static List<String> getTrimmedStackTraceLines(Throwable exception) {
        List<StackTraceElement> stackTraceElements = Arrays.asList(exception.getStackTrace());
        int linesToInclude = stackTraceElements.size();
        State state = State.PROCESSING_OTHER_CODE;
        for (StackTraceElement stackTraceElement : Throwables.asReversedList(stackTraceElements)) {
            if ((state = state.processStackTraceElement(stackTraceElement)) == State.DONE) {
                ArrayList<String> trimmedLines = new ArrayList<String>(linesToInclude + 2);
                trimmedLines.add("");
                for (StackTraceElement each : stackTraceElements.subList(0, linesToInclude)) {
                    String string = String.valueOf(each);
                    trimmedLines.add("\tat " + string);
                }
                if (exception.getCause() != null) {
                    int n = stackTraceElements.size() - trimmedLines.size();
                    trimmedLines.add("\t... " + n + " trimmed");
                }
                return trimmedLines;
            }
            --linesToInclude;
        }
        return Collections.emptyList();
    }

    private Throwables() {
    }

    private static void appendStackTraceLines(List<String> stackTraceLines, StringBuilder destBuilder) {
        for (String stackTraceLine : stackTraceLines) {
            destBuilder.append(String.format("%s%n", stackTraceLine));
        }
    }

    private static boolean isMatchingMethod(String methodName, String[] methodNamePrefixes) {
        for (String methodNamePrefix : methodNamePrefixes) {
            if (!methodName.startsWith(methodNamePrefix)) continue;
            return true;
        }
        return false;
    }

    private static boolean isReflectionMethod(String methodName) {
        return Throwables.isMatchingMethod(methodName, REFLECTION_METHOD_NAME_PREFIXES);
    }

    private static boolean isTestFrameworkMethod(String methodName) {
        return Throwables.isMatchingMethod(methodName, TEST_FRAMEWORK_METHOD_NAME_PREFIXES) && !Throwables.isMatchingMethod(methodName, TEST_FRAMEWORK_TEST_METHOD_NAME_PREFIXES);
    }

    private static enum State {
        PROCESSING_OTHER_CODE(null){

            @Override
            public State processLine(String methodName) {
                if (Throwables.isTestFrameworkMethod(methodName)) {
                    return PROCESSING_TEST_FRAMEWORK_CODE;
                }
                return this;
            }
        }
        ,
        PROCESSING_TEST_FRAMEWORK_CODE(null){

            @Override
            public State processLine(String methodName) {
                if (Throwables.isReflectionMethod(methodName)) {
                    return PROCESSING_REFLECTION_CODE;
                }
                if (Throwables.isTestFrameworkMethod(methodName)) {
                    return this;
                }
                return PROCESSING_OTHER_CODE;
            }
        }
        ,
        PROCESSING_REFLECTION_CODE(null){

            @Override
            public State processLine(String methodName) {
                if (Throwables.isReflectionMethod(methodName)) {
                    return this;
                }
                if (Throwables.isTestFrameworkMethod(methodName)) {
                    return PROCESSING_TEST_FRAMEWORK_CODE;
                }
                return DONE;
            }
        }
        ,
        DONE(null){

            @Override
            public State processLine(String methodName) {
                return this;
            }
        };


        protected abstract State processLine(String var1);

        public final State processStackTraceElement(StackTraceElement element) {
            String string = element.getMethodName();
            String string2 = element.getClassName();
            return this.processLine(string2 + "." + string + "()");
        }

        private State() {
        }

        /* synthetic */ State(String string, int n, Throwables$State-IA state-IA) {
            this();
        }
    }
}

