/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events.discovery;

import android.os.Parcel;
import androidx.annotation.NonNull;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.ErrorInfo;
import androidx.test.services.events.TimeStamp;
import androidx.test.services.events.discovery.TestDiscoveryEvent;

public class TestDiscoveryErrorEvent
extends TestDiscoveryEvent {
    @NonNull
    public final ErrorInfo error;
    @NonNull
    public final TimeStamp timeStamp;

    @Override
    TestDiscoveryEvent.EventType instanceType() {
        return TestDiscoveryEvent.EventType.ERROR;
    }

    TestDiscoveryErrorEvent(Parcel source) {
        this.error = new ErrorInfo(source);
        this.timeStamp = new TimeStamp(source);
    }

    public TestDiscoveryErrorEvent(@NonNull ErrorInfo error, @NonNull TimeStamp timeStamp) {
        this.error = (ErrorInfo)Checks.checkNotNull((Object)error, (Object)"error cannot be null");
        this.timeStamp = (TimeStamp)Checks.checkNotNull((Object)timeStamp, (Object)"timeStamp cannot be null");
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        this.error.writeToParcel(parcel, i);
        this.timeStamp.writeToParcel(parcel, i);
    }
}

