/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.suites;

import androidx.annotation.RestrictTo;
import androidx.test.internal.runner.ClassPathScanner;
import androidx.test.internal.runner.ErrorReportingRunner;
import androidx.test.internal.runner.TestLoader;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

@RunWith(value=RunnerSuite.class)
public final class AndroidClasspathSuite {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public AndroidClasspathSuite() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static class RunnerSuite
    extends Suite {
        private static List<Runner> getRunnersForClasses(RunnerBuilder builder) {
            try {
                Set<String> classNames = new ClassPathScanner(ClassPathScanner.getDefaultClasspaths(InstrumentationRegistry.getInstrumentation())).getClassPathEntries();
                return TestLoader.Factory.create(null, builder, true).getRunnersFor(classNames);
            }
            catch (IOException e) {
                return Arrays.asList(new Runner[]{new ErrorReportingRunner(InstrumentationRegistry.getInstrumentation().getContext().getPackageName(), new RuntimeException("Failed to perform classpath scanning to determine tests to run", e))});
            }
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public RunnerSuite(Class<?> klass, RunnerBuilder builder) throws InitializationError {
            super(klass, RunnerSuite.getRunnersForClasses(builder));
        }
    }
}

