/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.permission;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.runner.permission.RequestPermissionCallable;
import androidx.test.runner.permission.ShellCommand;

@ExperimentalTestApi
class GrantPermissionCallable
extends RequestPermissionCallable {
    private static final String TAG = "GrantPermissionCallable";

    @Override
    public RequestPermissionCallable.Result call() throws Exception {
        if (this.isPermissionGranted()) {
            String string = this.getPermission();
            Log.i((String)TAG, (String)("Permission: " + string + " is already granted!"));
            return RequestPermissionCallable.Result.SUCCESS;
        }
        ShellCommand cmdForPermission = this.getShellCommand();
        try {
            cmdForPermission.execute();
        }
        finally {
            if (!this.isPermissionGranted()) {
                Thread.sleep(1000L);
                if (!this.isPermissionGranted()) {
                    String string = this.getPermission();
                    Log.e((String)TAG, (String)("Permission: " + string + " cannot be granted!"));
                    return RequestPermissionCallable.Result.FAILURE;
                }
            }
        }
        return RequestPermissionCallable.Result.SUCCESS;
    }

    GrantPermissionCallable(@NonNull ShellCommand shellCommand, @NonNull Context context, String permission) {
        super(shellCommand, context, permission);
    }
}

