/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.orchestrator.junit;

import android.os.Parcel;
import android.os.Parcelable;
import org.junit.runner.Description;

public final class ParcelableDescription
implements Parcelable {
    private final String className;
    private final String methodName;
    private final String displayName;
    public static final Parcelable.Creator<ParcelableDescription> CREATOR = new Parcelable.Creator<ParcelableDescription>(){

        public ParcelableDescription createFromParcel(Parcel in) {
            return new ParcelableDescription(in);
        }

        public ParcelableDescription[] newArray(int size) {
            return new ParcelableDescription[size];
        }
    };

    public ParcelableDescription(Description description) {
        this.className = description.getClassName();
        this.methodName = description.getMethodName();
        this.displayName = description.getDisplayName();
    }

    public ParcelableDescription(String classAndMethodName) {
        String[] classAndMethodNames = classAndMethodName.split("#");
        this.className = classAndMethodNames[0];
        this.methodName = classAndMethodNames.length > 1 ? classAndMethodNames[1] : "";
        this.displayName = classAndMethodName;
    }

    private ParcelableDescription(Parcel in) {
        this.className = this.getNonNullString(in);
        this.methodName = this.getNonNullString(in);
        this.displayName = this.getNonNullString(in);
    }

    private String getNonNullString(Parcel in) {
        String str = in.readString();
        return str == null ? "" : str;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.className);
        out.writeString(this.methodName);
        out.writeString(this.displayName);
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

