/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.permission;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.test.InstrumentationRegistry;
import androidx.test.annotation.Beta;
import androidx.test.internal.util.Checks;
import androidx.test.runner.permission.GrantPermissionCallable;
import androidx.test.runner.permission.RequestPermissionCallable;
import androidx.test.runner.permission.UiAutomationShellCommand;
import java.util.HashSet;
import junit.framework.Assert;

@Beta
@TargetApi(value=23)
public class PermissionRequester {
    private static final String TAG = "PermissionRequester";
    private int mAndroidRuntimeVersion = Build.VERSION.SDK_INT;
    @NonNull
    private final Context mTargetContext;
    @VisibleForTesting
    final HashSet<RequestPermissionCallable> mRequestedPermissions = new HashSet();

    public PermissionRequester() {
        this(InstrumentationRegistry.getTargetContext());
    }

    @VisibleForTesting
    PermissionRequester(@NonNull Context targetContext) {
        this.mTargetContext = (Context)Checks.checkNotNull((Object)targetContext, (Object)"targetContext cannot be null!");
    }

    public void addPermissions(String ... permissions) {
        Checks.checkNotNull((Object)permissions, (Object)"permissions cannot be null!");
        if (this.deviceSupportsRuntimePermissions()) {
            for (String permission : permissions) {
                Assert.assertFalse((String)"Permission String is empty or null!", (boolean)TextUtils.isEmpty((CharSequence)permission));
                GrantPermissionCallable requestPermissionCallable = new GrantPermissionCallable(new UiAutomationShellCommand(this.mTargetContext.getPackageName(), permission, UiAutomationShellCommand.PmCommand.GRANT_PERMISSION), this.mTargetContext, permission);
                Checks.checkState((boolean)this.mRequestedPermissions.add(requestPermissionCallable));
            }
        }
    }

    public void requestPermissions() {
        if (this.deviceSupportsRuntimePermissions()) {
            for (RequestPermissionCallable requestPermissionCallable : this.mRequestedPermissions) {
                try {
                    if (RequestPermissionCallable.Result.FAILURE != requestPermissionCallable.call()) continue;
                    Assert.fail((String)"Failed to grant permissions, see logcat for details");
                    return;
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)"An Exception was thrown while granting permission", (Throwable)exception);
                    Assert.fail((String)"Failed to grant permissions, see logcat for details");
                    return;
                }
            }
        }
    }

    @VisibleForTesting
    protected void setAndroidRuntimeVersion(int sdkInt) {
        this.mAndroidRuntimeVersion = sdkInt;
    }

    private boolean deviceSupportsRuntimePermissions() {
        boolean supportsRuntimePermissions;
        boolean bl = supportsRuntimePermissions = this.getAndroidRuntimeVersion() >= 23;
        if (!supportsRuntimePermissions) {
            Log.w((String)TAG, (String)"Permissions can only be granted on devices running Android M (API 23) orhigher. This rule is ignored.");
        }
        return supportsRuntimePermissions;
    }

    private int getAndroidRuntimeVersion() {
        return this.mAndroidRuntimeVersion;
    }
}

