/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.listener;

import android.app.Instrumentation;
import android.os.Bundle;
import android.util.Log;
import androidx.test.internal.runner.listener.InstrumentationRunListener;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.junit.runner.Result;

public class CoverageListener
extends InstrumentationRunListener {
    private static final String TAG = "CoverageListener";
    private String mCoverageFilePath;
    private static final String REPORT_KEY_COVERAGE_PATH = "coverageFilePath";
    private static final String DEFAULT_COVERAGE_FILE_NAME = "coverage.ec";
    private static final String EMMA_RUNTIME_CLASS = "com.vladium.emma.rt.RT";

    public CoverageListener(String customCoverageFilePath) {
        this.mCoverageFilePath = customCoverageFilePath;
    }

    @Override
    public void setInstrumentation(Instrumentation instr) {
        super.setInstrumentation(instr);
        if (this.mCoverageFilePath == null) {
            String string = instr.getTargetContext().getFilesDir().getAbsolutePath();
            String string2 = File.separator;
            this.mCoverageFilePath = new StringBuilder(11 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append(DEFAULT_COVERAGE_FILE_NAME).toString();
        }
    }

    @Override
    public void instrumentationRunFinished(PrintStream writer, Bundle results, Result junitResults) {
        this.generateCoverageReport(writer, results);
    }

    private void generateCoverageReport(PrintStream writer, Bundle results) {
        File coverageFile = new File(this.mCoverageFilePath);
        try {
            Class<?> emmaRTClass;
            try {
                emmaRTClass = Class.forName(EMMA_RUNTIME_CLASS, true, this.getInstrumentation().getTargetContext().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                emmaRTClass = Class.forName(EMMA_RUNTIME_CLASS, true, this.getInstrumentation().getContext().getClassLoader());
                String msg = "Generating coverage for alternate test context.";
                Log.w((String)TAG, (String)msg);
                writer.format("\nWarning: %s", msg);
            }
            Method dumpCoverageMethod = emmaRTClass.getMethod("dumpCoverageData", coverageFile.getClass(), Boolean.TYPE, Boolean.TYPE);
            dumpCoverageMethod.invoke(null, coverageFile, false, false);
            results.putString(REPORT_KEY_COVERAGE_PATH, this.mCoverageFilePath);
            writer.format("\nGenerated code coverage data to %s", this.mCoverageFilePath);
        }
        catch (ClassNotFoundException e) {
            this.reportEmmaError(writer, "Is Emma/JaCoCo jar on classpath?", e);
        }
        catch (SecurityException e) {
            this.reportEmmaError(writer, e);
        }
        catch (NoSuchMethodException e) {
            this.reportEmmaError(writer, e);
        }
        catch (IllegalArgumentException e) {
            this.reportEmmaError(writer, e);
        }
        catch (IllegalAccessException e) {
            this.reportEmmaError(writer, e);
        }
        catch (InvocationTargetException e) {
            this.reportEmmaError(writer, e);
        }
    }

    private void reportEmmaError(PrintStream writer, Exception e) {
        this.reportEmmaError(writer, "", e);
    }

    private void reportEmmaError(PrintStream writer, String hint, Exception e) {
        String string = String.valueOf(hint);
        String msg = string.length() != 0 ? "Failed to generate Emma/JaCoCo coverage. ".concat(string) : new String("Failed to generate Emma/JaCoCo coverage. ");
        Log.e((String)TAG, (String)msg, (Throwable)e);
        writer.format("\nError: %s", msg);
    }
}

