/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.junit4;

import android.util.Log;
import androidx.test.internal.runner.junit4.AndroidJUnit4ClassRunner;
import androidx.test.internal.util.AndroidRunnerParams;
import java.lang.reflect.Method;
import org.junit.Test;
import org.junit.internal.builders.JUnit4Builder;
import org.junit.runner.Runner;

public class AndroidJUnit4Builder
extends JUnit4Builder {
    private static final String TAG = "AndroidJUnit4Builder";
    private final AndroidRunnerParams mAndroidRunnerParams;
    private final boolean mScanningPath;

    public AndroidJUnit4Builder(AndroidRunnerParams runnerParams, boolean scanningPath) {
        this.mAndroidRunnerParams = runnerParams;
        this.mScanningPath = scanningPath;
    }

    @Deprecated
    public AndroidJUnit4Builder(AndroidRunnerParams runnerParams) {
        this(runnerParams, false);
    }

    public Runner runnerForClass(Class<?> testClass) throws Throwable {
        try {
            if (this.mScanningPath && !AndroidJUnit4Builder.hasTestMethods(testClass)) {
                return null;
            }
            return new AndroidJUnit4ClassRunner(testClass, this.mAndroidRunnerParams);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"Error constructing runner", (Throwable)e);
            throw e;
        }
    }

    private static boolean hasTestMethods(Class<?> testClass) {
        boolean hasTestMethods = false;
        try {
            for (Method testMethod : testClass.getMethods()) {
                if (!testMethod.isAnnotationPresent(Test.class)) continue;
                hasTestMethods = true;
                break;
            }
        }
        catch (Throwable t) {
            Log.w((String)TAG, (String)String.format("%s in hasTestMethods for %s", t.toString(), testClass.getName()));
            return false;
        }
        return hasTestMethods;
    }
}

