/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.rule;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.test.InstrumentationRegistry;
import androidx.test.annotation.Beta;
import androidx.test.internal.util.Checks;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Beta
public class ServiceTestRule
implements TestRule {
    private static final String TAG = "ServiceTestRule";
    private static final long DEFAULT_TIMEOUT = 5L;
    private IBinder binder;
    private Intent serviceIntent;
    private ServiceConnection serviceConn;
    private long timeout;
    private TimeUnit timeUnit;
    boolean serviceStarted = false;
    boolean serviceBound = false;

    public ServiceTestRule() {
        this(5L, TimeUnit.SECONDS);
    }

    public static ServiceTestRule withTimeout(long timeout, TimeUnit timeUnit) {
        return new ServiceTestRule(timeout, timeUnit);
    }

    private ServiceTestRule(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public void startService(@NonNull Intent intent) throws TimeoutException {
        this.serviceIntent = (Intent)Checks.checkNotNull((Object)intent, (Object)"intent can't be null");
        InstrumentationRegistry.getTargetContext().startService(this.serviceIntent);
        this.serviceStarted = true;
        this.serviceBound = this.bindServiceAndWait(this.serviceIntent, null, 1);
    }

    public IBinder bindService(@NonNull Intent intent) throws TimeoutException {
        this.serviceIntent = ((Intent)Checks.checkNotNull((Object)intent, (Object)"intent can't be null")).cloneFilter();
        this.serviceBound = this.bindServiceAndWait(intent, null, 1);
        return this.binder;
    }

    public IBinder bindService(@NonNull Intent intent, @NonNull ServiceConnection connection, int flags) throws TimeoutException {
        this.serviceIntent = ((Intent)Checks.checkNotNull((Object)intent, (Object)"intent can't be null")).cloneFilter();
        ServiceConnection c = (ServiceConnection)Checks.checkNotNull((Object)connection, (Object)"connection can't be null");
        this.serviceBound = this.bindServiceAndWait(this.serviceIntent, c, flags);
        return this.binder;
    }

    @VisibleForTesting
    boolean bindServiceAndWait(Intent intent, ServiceConnection conn, int flags) throws TimeoutException {
        ProxyServiceConnection serviceConn = new ProxyServiceConnection(conn);
        boolean isBound = InstrumentationRegistry.getTargetContext().bindService(intent, (ServiceConnection)serviceConn, flags);
        if (isBound) {
            this.waitOnLatch(serviceConn.connectedLatch, "connected");
            this.serviceConn = serviceConn;
        } else {
            Log.e((String)TAG, (String)"Failed to bind to service! Is your service declared in the manifest?");
        }
        return isBound;
    }

    public void unbindService() {
        if (this.serviceBound) {
            InstrumentationRegistry.getTargetContext().unbindService(this.serviceConn);
            this.binder = null;
            this.serviceBound = false;
        }
    }

    private void waitOnLatch(CountDownLatch latch, String actionName) throws TimeoutException {
        try {
            if (!latch.await(this.timeout, this.timeUnit)) {
                long l = this.timeout;
                String string = this.timeUnit.name();
                throw new TimeoutException(new StringBuilder(56 + String.valueOf(string).length() + String.valueOf(actionName).length()).append("Waited for ").append(l).append(" ").append(string).append(", but service was never ").append(actionName).toString());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String string = String.valueOf(actionName);
            throw new RuntimeException(string.length() != 0 ? "Interrupted while waiting for service to be ".concat(string) : new String("Interrupted while waiting for service to be "), e);
        }
    }

    @VisibleForTesting
    void shutdownService() throws TimeoutException {
        if (this.serviceStarted) {
            InstrumentationRegistry.getTargetContext().stopService(this.serviceIntent);
            this.serviceStarted = false;
        }
        this.unbindService();
    }

    protected void beforeService() {
    }

    protected void afterService() {
    }

    public Statement apply(Statement base, Description description) {
        return new ServiceStatement(base);
    }

    private class ServiceStatement
    extends Statement {
        private final Statement base;

        public ServiceStatement(Statement base) {
            this.base = base;
        }

        public void evaluate() throws Throwable {
            try {
                ServiceTestRule.this.beforeService();
                this.base.evaluate();
            }
            finally {
                ServiceTestRule.this.shutdownService();
                ServiceTestRule.this.afterService();
            }
        }
    }

    class ProxyServiceConnection
    implements ServiceConnection {
        private ServiceConnection callerConnection;
        public CountDownLatch connectedLatch = new CountDownLatch(1);

        private ProxyServiceConnection(ServiceConnection connection) {
            this.callerConnection = connection;
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            ServiceTestRule.this.binder = service;
            if (this.callerConnection != null) {
                this.callerConnection.onServiceConnected(name, service);
            }
            this.connectedLatch.countDown();
        }

        public void onServiceDisconnected(ComponentName name) {
            Log.e((String)ServiceTestRule.TAG, (String)"Connection to the Service has been lost!");
            ServiceTestRule.this.binder = null;
            if (this.callerConnection != null) {
                this.callerConnection.onServiceDisconnected(name);
            }
        }
    }
}

