/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.platform.io;

import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.platform.io.PlatformTestStorage;
import androidx.test.platform.io.TestDirCalculator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class FileTestStorage
implements PlatformTestStorage {
    private static final String TAG = FileTestStorage.class.getSimpleName();
    private final TestDirCalculator testDirCalculator = new TestDirCalculator();

    @Override
    public InputStream openInputFile(String pathname) throws FileNotFoundException {
        File inputFile = new File(this.testDirCalculator.getInputDir(), pathname);
        return new FileInputStream(inputFile);
    }

    @Override
    public OutputStream openOutputFile(String pathname) throws FileNotFoundException {
        return this.openOutputFile(pathname, false);
    }

    @Override
    public OutputStream openOutputFile(String pathname, boolean append) throws FileNotFoundException {
        File outputFile = new File(this.testDirCalculator.getOutputDir(), pathname);
        Log.d((String)"FileTestStorage", (String)("openOutputFile from " + outputFile.getAbsolutePath()));
        if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            throw new FileNotFoundException("Failed to create output dir " + outputFile.getParentFile().getAbsolutePath());
        }
        return new FileOutputStream(outputFile, append);
    }

    @Override
    public String getInputArg(String argName) {
        return InstrumentationRegistry.getArguments().getString(argName);
    }

    @Override
    public Map<String, String> getInputArgs() {
        HashMap<String, String> argMap = new HashMap<String, String>();
        Bundle bundle = InstrumentationRegistry.getArguments();
        for (String key : bundle.keySet()) {
            argMap.put(key, bundle.getString(key));
        }
        return argMap;
    }

    @Override
    public void addOutputProperties(Map<String, Serializable> properties) {
        Log.w((String)TAG, (String)"Output properties is not supported.");
    }

    @Override
    public Map<String, Serializable> getOutputProperties() {
        Log.w((String)TAG, (String)"Output properties is not supported.");
        return Collections.emptyMap();
    }

    @Override
    public InputStream openInternalInputFile(String pathname) throws FileNotFoundException {
        return this.openInputFile(pathname);
    }

    @Override
    public OutputStream openInternalOutputFile(String pathname) throws FileNotFoundException {
        return this.openOutputFile(pathname);
    }

    @Override
    public Uri getInputFileUri(@NonNull String pathname) {
        File inputFile = new File(this.testDirCalculator.getInputDir(), pathname);
        return Uri.fromFile((File)inputFile);
    }

    @Override
    public Uri getOutputFileUri(@NonNull String pathname) {
        File outputFile = new File(this.testDirCalculator.getOutputDir(), pathname);
        return Uri.fromFile((File)outputFile);
    }

    @Override
    public boolean isTestStorageFilePath(@NonNull String pathname) {
        String outputDir2 = this.testDirCalculator.getOutputDir().getAbsolutePath();
        return pathname.startsWith(outputDir2);
    }
}

