/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.util;

import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.test.internal.util.LogUtil$$ExternalSyntheticLambda0;
import androidx.test.internal.util.LogUtil$$ExternalSyntheticLambda1;
import androidx.test.internal.util.ProcSummary;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class LogUtil {
    private static volatile String myProcName = null;

    static /* synthetic */ String lambda$logDebug$0(String message) {
        return message;
    }

    static /* synthetic */ String lambda$logDebugWithProcess$1(String message) {
        String string = LogUtil.procName();
        String string2 = message;
        return string2 + " in " + string;
    }

    private static final String procName() {
        String procDesc = myProcName;
        if (procDesc == null) {
            try {
                procDesc = ProcSummary.summarize((String)"self").cmdline;
            }
            catch (ProcSummary.SummaryException se) {
                procDesc = "unknown";
            }
            if (procDesc.length() > 64 && procDesc.contains("-classpath")) {
                procDesc = "robolectric";
            }
        }
        return procDesc;
    }

    private static void logDebug(String tag, Supplier<String> msgSupplier, Object ... args) {
        if (LogUtil.isLoggable(tag, 3)) {
            Log.d((String)tag, (String)String.format(msgSupplier.get(), args));
        }
    }

    public static void logDebug(String tag, String message, Object ... args) {
        String string = message;
        LogUtil.logDebug(tag, new LogUtil$$ExternalSyntheticLambda1(string), args);
    }

    public static void logDebugWithProcess(String tag, String message, Object ... args) {
        String string = message;
        LogUtil.logDebug(tag, new LogUtil$$ExternalSyntheticLambda0(string), args);
    }

    private static boolean isLoggable(String tag, int level) {
        if (tag.length() > 23) {
            tag = tag.substring(0, 22);
        }
        return Log.isLoggable((String)tag, (int)level);
    }

    static interface Supplier<T> {
        public T get();
    }
}

