/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.util;

import android.util.Log;
import androidx.annotation.RestrictTo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@Deprecated
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ReflectionUtil {
    private static final String TAG = "ReflectionUtil";

    public static Object callStaticMethod(Class<?> clazz, String methodName, ReflectionParams ... params) throws ReflectionException {
        String string = String.valueOf(methodName);
        Log.d((String)TAG, (String)(string.length() != 0 ? "Attempting to reflectively call: ".concat(string) : new String("Attempting to reflectively call: ")));
        try {
            Class<?>[] types = ReflectionParams.getTypes(params);
            Object[] values = ReflectionParams.getValues(params);
            Method m = clazz.getDeclaredMethod(methodName, types);
            m.setAccessible(true);
            return m.invoke(null, values);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    public static Object callStaticMethod(String className, String methodName, ReflectionParams ... params) throws ReflectionException {
        try {
            return ReflectionUtil.callStaticMethod(Class.forName(className), methodName, params);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class ReflectionException
    extends Exception {
        ReflectionException(Exception cause) {
            super("Reflective call failed", cause);
        }
    }

    public static class ReflectionParams {
        final Class<?> type;
        final Object value;

        public ReflectionParams(Class<?> type, Object value) {
            this.type = type;
            this.value = value;
        }

        public static Class<?>[] getTypes(ReflectionParams[] params) {
            Class[] types = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                types[i] = params[i].type;
            }
            return types;
        }

        public static Object[] getValues(ReflectionParams[] params) {
            Object[] values = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                values[i] = params[i].value;
            }
            return values;
        }
    }
}

