/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.util;

import androidx.annotation.VisibleForTesting;
import androidx.test.internal.util.Checks;
import androidx.test.internal.util.ProcSummary-IA;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public final class ProcSummary {
    public final String name;
    public final String pid;
    public final String parent;
    public final String realUid;
    public final String cmdline;
    public final long startTime;

    public int hashCode() {
        return this.pid.hashCode();
    }

    @VisibleForTesting
    static ProcSummary parse(String statLine, String statusContent, String cmdline) {
        String[] stats = statLine.substring(statLine.lastIndexOf(41) + 2).split(" ", -1);
        statusContent = statusContent.substring(statusContent.indexOf("\nUid:") + 1);
        statusContent = statusContent.substring(0, statusContent.indexOf(10));
        String[] uids = statusContent.split("\\s", -1);
        Builder b = new Builder().withPid(statLine.substring(0, statLine.indexOf(32))).withName(statLine.substring(statLine.indexOf(40) + 1, statLine.lastIndexOf(41))).withParent(stats[1]).withRealUid(uids[1]).withCmdline(cmdline.trim().replace('\u0000', ' ')).withStartTime(Long.parseLong(stats[19]));
        return b.build();
    }

    public static ProcSummary summarize(String pid) {
        File statFile = new File(new File("/proc", pid), "stat");
        String statContent = ProcSummary.readToString(statFile);
        File statusFile = new File(new File("/proc", pid), "status");
        String statusContent = ProcSummary.readToString(statusFile);
        File cmdlineFile = new File(new File("/proc", pid), "cmdline");
        String cmdline = ProcSummary.readToString(cmdlineFile);
        return ProcSummary.parse(statContent, statusContent, cmdline);
    }

    private static final String readToString(File path) {
        StringBuilder sb = new StringBuilder();
        char[] buff = new char[1024];
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(new FileInputStream(path));
            int read = 0;
            while ((read = isr.read(buff, 0, buff.length)) != -1) {
                sb.append(buff, 0, read);
            }
            String string = sb.toString();
            return string;
        }
        catch (RuntimeException re) {
            String string = String.valueOf(path);
            throw new SummaryException(new StringBuilder(15 + String.valueOf(string).length()).append("Error reading: ").append(string).toString(), re);
        }
        catch (IOException ioe) {
            String string = String.valueOf(path);
            throw new SummaryException(new StringBuilder(16 + String.valueOf(string).length()).append("Could not read: ").append(string).toString(), ioe);
        }
        finally {
            if (null != isr) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String toString() {
        return String.format("ProcSummary(name: '%s', cmdline: '%s', pid: '%s', parent: '%s', realUid: '%s', startTime: %d)", this.name, this.cmdline, this.pid, this.parent, this.realUid, this.startTime);
    }

    private ProcSummary(Builder b) {
        this.name = Checks.checkNotNull(b.name);
        this.pid = Checks.checkNotNull(b.pid);
        this.realUid = Checks.checkNotNull(b.realUid);
        this.parent = Checks.checkNotNull(b.parent);
        this.cmdline = Checks.checkNotNull(b.cmdline);
        this.startTime = b.startTime;
    }

    /* synthetic */ ProcSummary(Builder builder, ProcSummary-IA procSummary-IA) {
        this(builder);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ProcSummary)) {
            return false;
        }
        ProcSummary ops = (ProcSummary)o;
        return ops.name.equals(this.name) && ops.pid.equals(this.pid) && ops.parent.equals(this.parent) && ops.realUid.equals(this.realUid) && ops.cmdline.equals(this.cmdline) && ops.startTime == this.startTime;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @VisibleForTesting
    static class Builder {
        private String name;
        private String pid;
        private String realUid;
        private String cmdline;
        private long startTime;
        private String parent;

        Builder withCmdline(String cmdline) {
            this.cmdline = cmdline;
            return this;
        }

        Builder withName(String name) {
            this.name = name;
            return this;
        }

        Builder withParent(String ppid) {
            try {
                Integer.parseInt(ppid);
            }
            catch (NumberFormatException nfe) {
                String string = String.valueOf(ppid);
                throw new IllegalArgumentException(string.length() != 0 ? "not a pid: ".concat(string) : new String("not a pid: "));
            }
            this.parent = ppid;
            return this;
        }

        Builder withPid(String pid) {
            try {
                Integer.parseInt(pid);
            }
            catch (NumberFormatException nfe) {
                String string = String.valueOf(pid);
                throw new IllegalArgumentException(string.length() != 0 ? "not a pid: ".concat(string) : new String("not a pid: "));
            }
            this.pid = pid;
            return this;
        }

        Builder withRealUid(String uid) {
            try {
                Integer.parseInt(uid);
            }
            catch (NumberFormatException nfe) {
                String string = String.valueOf(uid);
                throw new IllegalArgumentException(string.length() != 0 ? "not a uid: ".concat(string) : new String("not a uid: "));
            }
            this.realUid = uid;
            return this;
        }

        Builder withStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        ProcSummary build() {
            return new ProcSummary(this, null);
        }

        Builder() {
        }
    }

    public static class SummaryException
    extends RuntimeException {
        public SummaryException(String msg) {
            super(msg);
        }

        public SummaryException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

