/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.platform.reflect;

import androidx.annotation.RestrictTo;
import androidx.test.internal.platform.reflect.ReflectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ReflectiveMethod<T> {
    private final String className;
    private final String methodName;
    private final Class<?>[] paramTypes;
    private boolean initialized = false;
    private Method method;

    public T invoke(Object object, Object ... paramValues) throws ReflectionException {
        try {
            this.initIfNecessary();
            return (T)this.method.invoke(object, paramValues);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    public T invokeStatic(Object ... paramValues) throws ReflectionException {
        return this.invoke(null, paramValues);
    }

    public ReflectiveMethod(String className, String methodName, Class<?> ... paramTypes) {
        this.className = className;
        this.paramTypes = paramTypes;
        this.methodName = methodName;
    }

    private synchronized void initIfNecessary() throws ClassNotFoundException, NoSuchMethodException {
        if (this.initialized) {
            return;
        }
        this.method = Class.forName(this.className).getDeclaredMethod(this.methodName, this.paramTypes);
        this.method.setAccessible(true);
        this.initialized = true;
    }
}

