/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.ext.junit.rules;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.test.core.app.ActivityScenario;
import androidx.test.internal.util.Checks;
import org.junit.rules.ExternalResource;

public final class ActivityScenarioRule<A extends Activity>
extends ExternalResource {
    private final Supplier<ActivityScenario<A>> scenarioSupplier;
    @Nullable
    private ActivityScenario<A> scenario;

    public ActivityScenarioRule(Class<A> activityClass) {
        this.scenarioSupplier = () -> ActivityScenario.launch((Class)((Class)Checks.checkNotNull((Object)activityClass)));
    }

    public ActivityScenarioRule(Class<A> activityClass, @Nullable Bundle activityOptions) {
        this.scenarioSupplier = () -> ActivityScenario.launch((Class)((Class)Checks.checkNotNull((Object)activityClass)), (Bundle)activityOptions);
    }

    public ActivityScenarioRule(Intent startActivityIntent) {
        this.scenarioSupplier = () -> ActivityScenario.launch((Intent)((Intent)Checks.checkNotNull((Object)startActivityIntent)));
    }

    public ActivityScenarioRule(Intent startActivityIntent, @Nullable Bundle activityOptions) {
        this.scenarioSupplier = () -> ActivityScenario.launch((Intent)((Intent)Checks.checkNotNull((Object)startActivityIntent)), (Bundle)activityOptions);
    }

    protected void before() throws Throwable {
        this.scenario = this.scenarioSupplier.get();
    }

    protected void after() {
        this.scenario.close();
    }

    public ActivityScenario<A> getScenario() {
        return (ActivityScenario)Checks.checkNotNull(this.scenario);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static interface Supplier<T> {
        public T get();
    }
}

