/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.ext.junit.runners;

import java.lang.reflect.InvocationTargetException;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public final class AndroidJUnit4
extends Runner
implements Filterable,
Sortable {
    private static final String TAG = "AndroidJUnit4";
    private final Runner delegate;

    public AndroidJUnit4(Class<?> klass) throws InitializationError {
        this.delegate = AndroidJUnit4.loadRunner(klass);
    }

    private static Runner loadRunner(Class<?> testClass) throws InitializationError {
        String runnerClassName = AndroidJUnit4.getRunnerClassName();
        return AndroidJUnit4.loadRunner(testClass, runnerClassName);
    }

    private static String getRunnerClassName() {
        String runnerClassName = System.getProperty("android.junit.runner", null);
        if (runnerClassName == null) {
            if (System.getProperty("java.runtime.name").toLowerCase().contains("android")) {
                return "androidx.test.internal.runner.junit4.AndroidJUnit4ClassRunner";
            }
            return "org.robolectric.RobolectricTestRunner";
        }
        return runnerClassName;
    }

    private static Runner loadRunner(Class<?> testClass, String className) throws InitializationError {
        try {
            Class<?> runnerClass = Class.forName(className);
            return (Runner)runnerClass.getConstructor(Class.class).newInstance(testClass);
        }
        catch (ClassNotFoundException e) {
            AndroidJUnit4.throwInitializationError(className, e);
        }
        catch (NoSuchMethodException e) {
            AndroidJUnit4.throwInitializationError(className, e);
        }
        catch (IllegalAccessException e) {
            AndroidJUnit4.throwInitializationError(className, e);
        }
        catch (InstantiationException e) {
            AndroidJUnit4.throwInitializationError(className, e);
        }
        catch (InvocationTargetException e) {
            AndroidJUnit4.throwInitializationError(className, e);
        }
        throw new IllegalStateException("Should never reach here");
    }

    private static void throwInitializationError(String delegateRunner, Throwable cause) throws InitializationError {
        throw new InitializationError((Throwable)new RuntimeException(String.format("Delegate runner '%s' for AndroidJUnit4 could not be loaded.", delegateRunner), cause));
    }

    public Description getDescription() {
        return this.delegate.getDescription();
    }

    public void run(RunNotifier runNotifier) {
        this.delegate.run(runNotifier);
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        ((Filterable)this.delegate).filter(filter);
    }

    public void sort(Sorter sorter) {
        ((Sortable)this.delegate).sort(sorter);
    }
}

