/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.idling;

import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import androidx.test.espresso.IdlingResource;
import java.util.concurrent.atomic.AtomicInteger;

public final class CountingIdlingResource
implements IdlingResource {
    private static final String TAG = "CountingIdlingResource";
    private final String resourceName;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final boolean debugCounting;
    private volatile IdlingResource.ResourceCallback resourceCallback;
    private volatile long becameBusyAt = 0L;
    private volatile long becameIdleAt = 0L;

    @Override
    public String getName() {
        return this.resourceName;
    }

    public CountingIdlingResource(String resourceName) {
        this(resourceName, false);
    }

    public CountingIdlingResource(String resourceName, boolean debugCounting) {
        if (TextUtils.isEmpty((CharSequence)resourceName)) {
            throw new IllegalArgumentException("resourceName cannot be empty or null!");
        }
        this.resourceName = resourceName;
        this.debugCounting = debugCounting;
    }

    public void decrement() {
        int counterVal = this.counter.decrementAndGet();
        if (counterVal == 0) {
            if (null != this.resourceCallback) {
                this.resourceCallback.onTransitionToIdle();
            }
            this.becameIdleAt = SystemClock.uptimeMillis();
        }
        if (this.debugCounting) {
            String string;
            if (counterVal == 0) {
                long l = this.becameIdleAt - this.becameBusyAt;
                string = this.resourceName;
                Log.i((String)TAG, (String)("Resource: " + string + " went idle! (Time spent not idle: " + l + ")"));
            } else {
                int n = counterVal;
                string = this.resourceName;
                Log.i((String)TAG, (String)("Resource: " + string + " in-use-count decremented to: " + n));
            }
        }
        if (counterVal <= -1) {
            int n = counterVal;
            throw new IllegalStateException("Counter has been corrupted! counterVal=" + n);
        }
    }

    public void dumpStateToLogs() {
        StringBuilder message = new StringBuilder("Resource: ").append(this.resourceName).append(" inflight transaction count: ").append(this.counter.get());
        if (0L == this.becameBusyAt) {
            Log.i((String)TAG, (String)message.append(" and has never been busy!").toString());
        } else {
            message.append(" and was last busy at: ").append(this.becameBusyAt);
            if (0L == this.becameIdleAt) {
                Log.w((String)TAG, (String)message.append(" AND NEVER WENT IDLE!").toString());
            } else {
                message.append(" and last went idle at: ").append(this.becameIdleAt);
                Log.i((String)TAG, (String)message.toString());
            }
        }
    }

    public void increment() {
        int counterVal = this.counter.getAndIncrement();
        if (0 == counterVal) {
            this.becameBusyAt = SystemClock.uptimeMillis();
        }
        if (this.debugCounting) {
            int n = counterVal + 1;
            String string = this.resourceName;
            Log.i((String)TAG, (String)("Resource: " + string + " in-use-count incremented to: " + n));
        }
    }

    @Override
    public void registerIdleTransitionCallback(IdlingResource.ResourceCallback resourceCallback) {
        this.resourceCallback = resourceCallback;
    }

    @Override
    public boolean isIdleNow() {
        return this.counter.get() == 0;
    }
}

