/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.util.concurrent;

import androidx.annotation.RestrictTo;
import androidx.test.internal.util.Checks;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ThreadFactoryBuilder {
    private String nameFormat;

    public ThreadFactoryBuilder setNameFormat(String nameFormat) {
        String unused = ThreadFactoryBuilder.format(nameFormat, 0);
        this.nameFormat = nameFormat;
        return this;
    }

    public ThreadFactory build() {
        Checks.checkNotNull((Object)this.nameFormat);
        ThreadFactory backingFactory = Executors.defaultThreadFactory();
        AtomicLong count = new AtomicLong(0L);
        return r -> {
            Thread thread = backingFactory.newThread(r);
            thread.setName(ThreadFactoryBuilder.format(this.nameFormat, count.getAndIncrement()));
            return thread;
        };
    }

    private static String format(String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }
}

