/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.util.concurrent;

import androidx.annotation.RestrictTo;
import androidx.test.espresso.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ListeningExecutorService
extends AbstractExecutorService {
    private final ExecutorService delegate;

    public ListeningExecutorService(ExecutorService delegate) {
        this.delegate = delegate;
    }

    @Override
    protected final <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return ListenableFutureTask.create(callable);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public <T> ListenableFuture<T> submit(Callable<T> remotePerformCallable) {
        return (ListenableFuture)super.submit(remotePerformCallable);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(command);
    }
}

