/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.util;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.util.Checks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import kotlin.collections.AbstractIterator;

public final class TreeIterables {
    private static final TreeViewer<View> VIEW_TREE_VIEWER = new ViewTreeViewer();

    private TreeIterables() {
    }

    public static Iterable<ViewAndDistance> depthFirstViewTraversalWithDistance(View root) {
        DistanceRecordingTreeViewer<View> distanceRecorder = new DistanceRecordingTreeViewer<View>(root, VIEW_TREE_VIEWER);
        ArrayList<ViewAndDistance> viewAndDistanceList = new ArrayList<ViewAndDistance>();
        for (View view : TreeIterables.depthFirstTraversal(root, distanceRecorder)) {
            viewAndDistanceList.add(new ViewAndDistance(view, distanceRecorder.getDistance(view)));
        }
        return viewAndDistanceList;
    }

    public static Iterable<View> depthFirstViewTraversal(View root) {
        return TreeIterables.depthFirstTraversal(root, VIEW_TREE_VIEWER);
    }

    public static Iterable<View> breadthFirstViewTraversal(View root) {
        return TreeIterables.breadthFirstTraversal(root, VIEW_TREE_VIEWER);
    }

    @VisibleForTesting
    static <T> Iterable<T> depthFirstTraversal(T root, TreeViewer<T> viewer) {
        Checks.checkNotNull(root);
        Checks.checkNotNull(viewer);
        return new TreeTraversalIterable(root, TraversalStrategy.DEPTH_FIRST, viewer);
    }

    @VisibleForTesting
    static <T> Iterable<T> breadthFirstTraversal(T root, TreeViewer<T> viewer) {
        Checks.checkNotNull(root);
        Checks.checkNotNull(viewer);
        return new TreeTraversalIterable(root, TraversalStrategy.BREADTH_FIRST, viewer);
    }

    public static class ViewAndDistance {
        private final View view;
        private final int distanceFromRoot;

        private ViewAndDistance(View view, int distanceFromRoot) {
            this.view = view;
            this.distanceFromRoot = distanceFromRoot;
        }

        public View getView() {
            return this.view;
        }

        public int getDistanceFromRoot() {
            return this.distanceFromRoot;
        }
    }

    @VisibleForTesting
    static interface TreeViewer<T> {
        public Collection<T> children(T var1);
    }

    @VisibleForTesting
    static class DistanceRecordingTreeViewer<T>
    implements TreeViewer<T> {
        private final T root;
        private final Map<T, Integer> nodeToDistance = new HashMap<T, Integer>();
        private final TreeViewer<T> delegateViewer;

        DistanceRecordingTreeViewer(T root, TreeViewer<T> delegateViewer) {
            this.root = Checks.checkNotNull(root);
            this.delegateViewer = (TreeViewer)Checks.checkNotNull(delegateViewer);
        }

        int getDistance(T node) {
            return (Integer)Checks.checkNotNull((Object)this.nodeToDistance.get(node), (String)"Never seen %s before", (Object[])new Object[]{node});
        }

        @Override
        public Collection<T> children(T node) {
            if (node == this.root) {
                this.nodeToDistance.put(node, 0);
            }
            int myDistance = this.getDistance(node);
            int childDistance = myDistance + 1;
            Collection<T> children = this.delegateViewer.children(node);
            for (T child : children) {
                this.nodeToDistance.put(child, childDistance);
            }
            return children;
        }
    }

    @VisibleForTesting
    static class ViewTreeViewer
    implements TreeViewer<View> {
        ViewTreeViewer() {
        }

        @Override
        public Collection<View> children(View view) {
            Checks.checkNotNull((Object)view);
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                int childCount = group.getChildCount();
                ArrayList<View> children = new ArrayList<View>();
                for (int i = 0; i < childCount; ++i) {
                    children.add(group.getChildAt(i));
                }
                return children;
            }
            return Collections.emptyList();
        }
    }

    private static enum TraversalStrategy {
        BREADTH_FIRST{

            @Override
            <T> void combineNewChildren(LinkedList<T> nodes, Collection<T> newChildren) {
                nodes.addAll(newChildren);
            }
        }
        ,
        DEPTH_FIRST{

            @Override
            <T> void combineNewChildren(LinkedList<T> nodes, Collection<T> newChildren) {
                nodes.addAll(0, newChildren);
            }
        };


        abstract <T> void combineNewChildren(LinkedList<T> var1, Collection<T> var2);

        <T> T next(LinkedList<T> nodes) {
            return nodes.removeFirst();
        }
    }

    private static class TreeTraversalIterable<T>
    implements Iterable<T> {
        private final T root;
        private final TraversalStrategy traversalStrategy;
        private final TreeViewer<T> treeViewer;

        private TreeTraversalIterable(T root, TraversalStrategy traversalStrategy, TreeViewer<T> treeViewer) {
            this.root = Checks.checkNotNull(root);
            this.traversalStrategy = (TraversalStrategy)((Object)Checks.checkNotNull((Object)((Object)traversalStrategy)));
            this.treeViewer = (TreeViewer)Checks.checkNotNull(treeViewer);
        }

        @Override
        public Iterator<T> iterator() {
            final LinkedList<T> nodes = new LinkedList<T>();
            nodes.add(this.root);
            return new AbstractIterator<T>(){

                protected void computeNext() {
                    if (nodes.isEmpty()) {
                        this.done();
                    } else {
                        Object nextItem = Checks.checkNotNull(traversalStrategy.next(nodes), (Object)"Null items not allowed!");
                        traversalStrategy.combineNewChildren(nodes, treeViewer.children(nextItem));
                        this.setNext(nextItem);
                    }
                }
            };
        }
    }
}

