/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.util;

import androidx.annotation.RestrictTo;
import androidx.test.espresso.util.StringJoinerKt;
import java.util.ArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class TracingUtil {
    private static final int SPAN_NAME_MAX_LEN = 100;
    private static final String SPAN_NAME_EXCLUDE = "[^0-9A-Za-z._$()\\[\\] /:-]";

    private TracingUtil() {
    }

    public static String getSpanName(String prefix, String methodName, Object ... arguments) {
        String processedPrefix = TracingUtil.sanitizeName(prefix, SPAN_NAME_EXCLUDE, -1);
        String processedMethodName = TracingUtil.sanitizeName(methodName, SPAN_NAME_EXCLUDE, -1);
        ArrayList<String> processedArguments = new ArrayList<String>();
        if (arguments != null) {
            for (Object argument : arguments) {
                String processedArgument;
                if (argument == null || (processedArgument = TracingUtil.sanitizeName(argument.toString(), SPAN_NAME_EXCLUDE, -1)).isEmpty()) continue;
                processedArguments.add(processedArgument);
            }
        }
        String spanName = processedPrefix;
        if (!processedPrefix.isEmpty() && !processedMethodName.isEmpty()) {
            spanName = spanName + ".";
        }
        spanName = spanName + processedMethodName;
        if (!processedArguments.isEmpty()) {
            spanName = spanName + "(" + StringJoinerKt.joinToString(processedArguments, ", ") + ")";
        }
        spanName = TracingUtil.sanitizeName(spanName, null, 100);
        return spanName;
    }

    public static String getClassName(Object element, String defaultName) {
        String name;
        String string = name = element == null ? null : element.getClass().getSimpleName();
        if (name == null || name.length() == 0) {
            name = defaultName;
        }
        return name == null ? "" : name;
    }

    private static String sanitizeName(String name, String exclude, int maxLength) {
        if (name == null) {
            return "";
        }
        String newName = name;
        if (exclude != null && exclude.length() > 0) {
            newName = newName.replaceAll(exclude, "").trim();
        }
        if (maxLength > 0 && newName.length() > maxLength) {
            newName = newName.substring(0, maxLength).trim();
        }
        return newName;
    }
}

