/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.util;

import android.content.res.Resources;
import android.database.Cursor;
import android.util.Printer;
import android.util.StringBuilderPrinter;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.Checkable;
import android.widget.TextView;
import androidx.test.espresso.util.StringJoinerKt;
import androidx.test.espresso.util.ToStringHelper;
import androidx.test.espresso.util.TreeIterables;
import androidx.test.internal.util.Checks;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HumanReadables {
    private static final String JAVA_ID = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern OBJECT_HASH_CODE_PATTERN = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*@([0-9A-Fa-f]+)");

    private HumanReadables() {
    }

    public static String getViewHierarchyErrorMessage(View rootView, List<View> problemViews, String errorHeader, String problemViewSuffix) {
        return HumanReadables.getViewHierarchyErrorMessage(rootView, problemViews, errorHeader, problemViewSuffix, Integer.MAX_VALUE);
    }

    public static String getViewHierarchyErrorMessage(View rootView, List<View> problemViews, String errorHeader, String problemViewSuffix, int maxMsgLen) {
        Checks.checkArgument((problemViews == null || problemViewSuffix != null ? 1 : 0) != 0);
        StringBuilder errorMessage = new StringBuilder(errorHeader);
        if (problemViewSuffix != null) {
            errorMessage.append(String.format(Locale.ROOT, "\nProblem views are marked with '%s' below.", problemViewSuffix));
        }
        ArrayList<String> tokens = new ArrayList<String>();
        for (TreeIterables.ViewAndDistance viewAndDistance : TreeIterables.depthFirstViewTraversalWithDistance(rootView)) {
            StringBuilder token = new StringBuilder();
            token.append('+');
            for (int i = 0; i < viewAndDistance.getDistanceFromRoot(); ++i) {
                token.append('-');
            }
            token.append('>');
            token.append(HumanReadables.describe(viewAndDistance.getView()));
            token.append(' ');
            if (problemViews != null && problemViews.contains(viewAndDistance.getView())) {
                token.append(problemViewSuffix);
            }
            tokens.add(token.toString());
        }
        String viewHierarchyDump = StringJoinerKt.joinToString(tokens, "\n|\n");
        errorMessage.append("\n\nView Hierarchy:\n").append(viewHierarchyDump);
        if (maxMsgLen < Integer.MAX_VALUE) {
            String suffix = " [truncated]";
            if (errorMessage.length() + suffix.length() > maxMsgLen) {
                errorMessage.delete(Math.max(0, maxMsgLen - suffix.length()), errorMessage.length());
                errorMessage.append(suffix);
            }
        }
        return errorMessage.toString();
    }

    public static String describe(Cursor c) {
        if (c.isBeforeFirst()) {
            return "Cursor positioned before first element.";
        }
        if (c.isAfterLast()) {
            return "Cursor positioned after last element.";
        }
        StringBuilder result = new StringBuilder("Row ").append(c.getPosition()).append(": {");
        String[] columns = c.getColumnNames();
        for (int i = 0; i < columns.length; ++i) {
            result.append(columns[i]).append(":");
            int type = c.getType(i);
            switch (type) {
                case 3: {
                    result.append("\"").append(c.getString(i)).append("\"");
                    break;
                }
                case 1: {
                    result.append(c.getLong(i));
                    break;
                }
                case 2: {
                    result.append(c.getDouble(i));
                    result.append("f");
                    break;
                }
                case 0: {
                    result.append("null");
                    break;
                }
                case 4: {
                    byte[] val = c.getBlob(i);
                    result.append("[");
                    for (int j = 0; j < 5 && j < val.length; ++j) {
                        result.append(val[j]);
                        result.append(",");
                    }
                    if (5 < val.length) {
                        result.append("... (").append(val.length - 5).append(" more elements)");
                    }
                    result.append("]");
                    break;
                }
                default: {
                    result.append("\"").append(c.getString(i)).append("\"");
                }
            }
            result.append(", ");
        }
        result.append("}");
        return result.toString();
    }

    public static String describe(View v) {
        EditorInfo ei;
        InputConnection ic;
        if (null == v) {
            return "null";
        }
        ToStringHelper helper = new ToStringHelper(v).add("id", v.getId());
        if (v.getId() != -1 && v.getId() != 0 && v.getResources() != null && !HumanReadables.isViewIdGenerated(v.getId())) {
            try {
                helper.add("res-name", v.getResources().getResourceEntryName(v.getId()));
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
        }
        if (null != v.getContentDescription()) {
            helper.add("desc", v.getContentDescription());
        }
        switch (v.getVisibility()) {
            case 8: {
                helper.add("visibility", "GONE");
                break;
            }
            case 4: {
                helper.add("visibility", "INVISIBLE");
                break;
            }
            case 0: {
                helper.add("visibility", "VISIBLE");
                break;
            }
            default: {
                helper.add("visibility", v.getVisibility());
            }
        }
        helper.add("width", v.getWidth()).add("height", v.getHeight()).add("has-focus", v.hasFocus()).add("has-focusable", v.hasFocusable()).add("has-window-focus", v.hasWindowFocus()).add("is-clickable", v.isClickable()).add("is-enabled", v.isEnabled()).add("is-focused", v.isFocused()).add("is-focusable", v.isFocusable()).add("is-layout-requested", v.isLayoutRequested()).add("is-selected", v.isSelected()).add("layout-params", HumanReadables.replaceHashCodes(v.getLayoutParams())).add("tag", v.getTag());
        if (null != v.getRootView()) {
            helper.add("root-is-layout-requested", v.getRootView().isLayoutRequested());
        }
        boolean hasInputConnection = (ic = v.onCreateInputConnection(ei = new EditorInfo())) != null;
        helper.add("has-input-connection", hasInputConnection);
        if (hasInputConnection) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            StringBuilderPrinter p = new StringBuilderPrinter(sb);
            ei.dump((Printer)p, "");
            sb.append("]");
            helper.add("editor-info", sb.toString().replace("\n", " "));
        }
        helper.add("x", Float.valueOf(v.getX())).add("y", Float.valueOf(v.getY()));
        if (v instanceof TextView) {
            HumanReadables.innerDescribe((TextView)v, helper);
        }
        if (v instanceof Checkable) {
            HumanReadables.innerDescribe((Checkable)v, helper);
        }
        if (v instanceof ViewGroup) {
            HumanReadables.innerDescribe((ViewGroup)v, helper);
        }
        return helper.toString();
    }

    private static String replaceHashCodes(Object instance) {
        if (instance == null) {
            return null;
        }
        String str = instance.toString();
        Matcher matcher = OBJECT_HASH_CODE_PATTERN.matcher(str);
        if (matcher.find()) {
            str = str.substring(0, matcher.start(2)) + "YYYYYY" + str.substring(matcher.end(2));
        }
        return str;
    }

    private static void innerDescribe(TextView textBox, ToStringHelper helper) {
        if (null != textBox.getText()) {
            helper.add("text", textBox.getText());
        }
        if (null != textBox.getError()) {
            helper.add("error-text", textBox.getError());
        }
        if (null != textBox.getHint()) {
            helper.add("hint", textBox.getHint());
        }
        helper.add("input-type", textBox.getInputType());
        helper.add("ime-target", textBox.isInputMethodTarget());
        helper.add("has-links", textBox.getUrls().length > 0);
    }

    private static void innerDescribe(Checkable checkable, ToStringHelper helper) {
        helper.add("is-checked", checkable.isChecked());
    }

    private static void innerDescribe(ViewGroup viewGroup, ToStringHelper helper) {
        helper.add("child-count", viewGroup.getChildCount());
    }

    private static boolean isViewIdGenerated(int id) {
        return (id & 0xFF000000) == 0 && (id & 0xFFFFFF) != 0;
    }
}

