/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.util;

import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import androidx.test.runner.lifecycle.Stage;

public final class ActivityLifecycles {
    private ActivityLifecycles() {
    }

    public static boolean hasForegroundActivities(ActivityLifecycleMonitor monitor) {
        return !monitor.getActivitiesInStage(Stage.RESUMED).isEmpty();
    }

    public static boolean hasVisibleActivities(ActivityLifecycleMonitor monitor) {
        return ActivityLifecycles.hasForegroundActivities(monitor) || ActivityLifecycles.hasTransitioningActivities(monitor);
    }

    public static boolean hasTransitioningActivities(ActivityLifecycleMonitor monitor) {
        return !monitor.getActivitiesInStage(Stage.RESTARTED).isEmpty() || !monitor.getActivitiesInStage(Stage.STARTED).isEmpty() || !monitor.getActivitiesInStage(Stage.PAUSED).isEmpty();
    }
}

