/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import android.util.LruCache;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.test.espresso.remote.RemoteProtocolException;
import androidx.test.internal.util.Checks;
import androidx.test.internal.util.LogUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;

final class MethodInvocation {
    private static final String TAG = "MethodInvocation";
    private static final LruCache<MethodKey, Method> methodCache = new LruCache(256);
    private final Class<?> clazz;
    @Nullable
    private final Object instance;
    private final String methodName;
    private final Class<?>[] parameterTypes;

    public MethodInvocation(@NonNull Class<?> clazz, @Nullable Object instance, @NonNull String methodName, Class<?> ... parameterTypes) {
        this.clazz = (Class)Checks.checkNotNull(clazz, (Object)"clazz cannot be null!");
        this.instance = instance;
        Checks.checkArgument((methodName != null && !methodName.isEmpty() ? 1 : 0) != 0, (Object)"methodName cannot be null or empty");
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    private static Method getMethod(MethodKey methodKey) throws NoSuchMethodException {
        return MethodInvocation.getMethodInternal(methodKey, false);
    }

    private static Method getDeclaredMethod(MethodKey methodKey) throws NoSuchMethodException {
        return MethodInvocation.getMethodInternal(methodKey, true);
    }

    private static Method getMethodInternal(MethodKey methodKey, boolean declaredMethod) throws NoSuchMethodException {
        Method method = (Method)methodCache.get((Object)methodKey);
        if (null == method) {
            LogUtil.logDebug((String)TAG, (String)"Cache miss for method: %s#%s(%s). Loading into cache.", (Object[])new Object[]{methodKey.type.getSimpleName(), methodKey.methodName, Arrays.toString(methodKey.parameterTypes)});
            method = declaredMethod ? methodKey.type.getDeclaredMethod(methodKey.methodName, methodKey.parameterTypes) : methodKey.type.getMethod(methodKey.methodName, methodKey.parameterTypes);
            methodCache.put((Object)methodKey, (Object)method);
        } else {
            LogUtil.logDebug((String)TAG, (String)"Cache hit for method: %s#%s(%s).", (Object[])new Object[]{methodKey.type.getSimpleName(), methodKey.methodName, Arrays.toString(methodKey.parameterTypes)});
        }
        return method;
    }

    @VisibleForTesting
    public static void invalidateCache() {
        methodCache.evictAll();
    }

    public Object invokeDeclaredMethod(Object ... methodParams) {
        try {
            return this.invokeMethodExplosively(MethodInvocation.getDeclaredMethod(new MethodKey(this.clazz, this.methodName, this.parameterTypes)), methodParams);
        }
        catch (NoSuchMethodException nsme) {
            throw new RemoteProtocolException(String.format(Locale.ROOT, "No method: %s(%s) found for clazz: %s Available methods: %s", this.methodName, Arrays.asList(this.parameterTypes), this.clazz.getName(), Arrays.asList(this.clazz.getDeclaredMethods())), nsme);
        }
    }

    public Object invokeMethod(Object ... methodParams) {
        try {
            return this.invokeMethodExplosively(MethodInvocation.getMethod(new MethodKey(this.clazz, this.methodName, this.parameterTypes)), methodParams);
        }
        catch (NoSuchMethodException nsme) {
            throw new RemoteProtocolException(String.format(Locale.ROOT, "No method: %s found for clazz: %s. Available methods: %s", this.methodName, this.clazz.getName(), Arrays.asList(this.clazz.getMethods())), nsme);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object invokeMethodExplosively(Method method, Object ... args) {
        Object returnValue = null;
        try {
            method.setAccessible(true);
            returnValue = method.invoke(this.instance, args);
        }
        catch (InvocationTargetException ite) {
            try {
                throw new RemoteProtocolException(String.format(Locale.ROOT, "Cannot invoke method %s with args [%s] on builder %s", method, Arrays.toString(args), this.clazz.getName()), ite);
                catch (IllegalAccessException iae) {
                    throw new RemoteProtocolException(String.format(Locale.ROOT, "Cannot create instance of %s", this.clazz.getName()), iae);
                }
                catch (SecurityException se) {
                    throw new RemoteProtocolException(String.format(Locale.ROOT, "Method not accessible: %s", method.getName()), se);
                }
            }
            catch (Throwable throwable) {
                LogUtil.logDebug((String)TAG, (String)"%s.invokeMethodExplosively(%s,%s)", (Object[])new Object[]{this.clazz.getSimpleName(), this.methodName, Arrays.toString(args)});
                throw throwable;
            }
        }
        LogUtil.logDebug((String)TAG, (String)"%s.invokeMethodExplosively(%s,%s)", (Object[])new Object[]{this.clazz.getSimpleName(), this.methodName, Arrays.toString(args)});
        return returnValue;
    }

    private static final class MethodKey {
        private final Class<?> type;
        private final String methodName;
        private final Class<?>[] parameterTypes;

        public MethodKey(Class<?> type, String methodName, Class<?>[] parameterTypes) {
            this.type = type;
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            MethodKey methodKey = (MethodKey)o;
            if (!this.type.equals(methodKey.type)) {
                return false;
            }
            if (!this.methodName.equals(methodKey.methodName)) {
                return false;
            }
            return Arrays.equals(this.parameterTypes, methodKey.parameterTypes);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.methodName.hashCode();
            result = 31 * result + Arrays.hashCode(this.parameterTypes);
            return result;
        }
    }
}

