/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public interface IInteractionExecutionStatus
extends IInterface {
    public static final String DESCRIPTOR = "androidx.test.espresso.remote.IInteractionExecutionStatus";

    public boolean canExecute() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInteractionExecutionStatus {
        static final int TRANSACTION_canExecute = 1;

        public Stub() {
            this.attachInterface(this, IInteractionExecutionStatus.DESCRIPTOR);
        }

        public static IInteractionExecutionStatus asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IInteractionExecutionStatus.DESCRIPTOR);
            if (iin != null && iin instanceof IInteractionExecutionStatus) {
                return (IInteractionExecutionStatus)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IInteractionExecutionStatus.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    boolean _result = this.canExecute();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IInteractionExecutionStatus {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IInteractionExecutionStatus.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canExecute() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInteractionExecutionStatus.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IInteractionExecutionStatus {
        @Override
        public boolean canExecute() throws RemoteException {
            return false;
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

