/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import android.util.LruCache;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.test.espresso.remote.RemoteProtocolException;
import androidx.test.internal.util.Checks;
import androidx.test.internal.util.LogUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Locale;

public final class ConstructorInvocation {
    private static final String TAG = "ConstructorInvocation";
    private static final LruCache<ConstructorKey, Constructor<?>> constructorCache = new LruCache(256);
    private final Class<?> clazz;
    @Nullable
    private final Class<? extends Annotation> annotationClass;
    @Nullable
    private final Class<?>[] parameterTypes;

    public ConstructorInvocation(@NonNull Class<?> clazz, @Nullable Class<? extends Annotation> annotationClass, Class<?> ... parameterTypes) {
        this.clazz = (Class)Checks.checkNotNull(clazz, (Object)"clazz cannot be null!");
        this.annotationClass = annotationClass;
        this.parameterTypes = parameterTypes;
    }

    @VisibleForTesting
    static void invalidateCache() {
        constructorCache.evictAll();
    }

    public Object invokeConstructor(Object ... constructorParams) {
        return this.invokeConstructorExplosively(constructorParams);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object invokeConstructorExplosively(Object ... constructorParams) {
        Object returnValue = null;
        Constructor<?> constructor = null;
        ConstructorKey constructorKey = new ConstructorKey(this.clazz, this.parameterTypes);
        try {
            constructor = (Constructor<?>)constructorCache.get((Object)constructorKey);
            if (null == constructor) {
                LogUtil.logDebug((String)TAG, (String)"Cache miss for constructor: %s(%s). Loading into cache.", (Object[])new Object[]{this.clazz.getSimpleName(), LogUtil.lazyArg(() -> Arrays.toString(constructorParams))});
                if (this.annotationClass != null) {
                    for (Constructor<?> candidate : this.clazz.getDeclaredConstructors()) {
                        if (!candidate.isAnnotationPresent(this.annotationClass)) continue;
                        constructor = candidate;
                        break;
                    }
                }
                if (null == constructor) {
                    constructor = this.clazz.getConstructor(this.parameterTypes);
                }
                Checks.checkState((constructor != null ? 1 : 0) != 0, (String)"No constructor found for annotation: %s, or parameter types: %s", (Object[])new Object[]{this.annotationClass, Arrays.asList(this.parameterTypes)});
                constructorCache.put((Object)constructorKey, constructor);
            } else {
                LogUtil.logDebug((String)TAG, (String)"Cache hit for constructor: %s(%s).", (Object[])new Object[]{this.clazz.getSimpleName(), LogUtil.lazyArg(() -> Arrays.toString(constructorParams))});
            }
            constructor.setAccessible(true);
            returnValue = constructor.newInstance(constructorParams);
        }
        catch (InvocationTargetException ite) {
            try {
                throw new RemoteProtocolException(String.format(Locale.ROOT, "Cannot invoke constructor %s with constructorParams [%s] on clazz %s", constructor, Arrays.toString(constructorParams), this.clazz.getName()), ite);
                catch (IllegalAccessException iae) {
                    throw new RemoteProtocolException(String.format(Locale.ROOT, "Cannot create instance of %s", this.clazz.getName()), iae);
                }
                catch (InstantiationException ia) {
                    throw new RemoteProtocolException(String.format(Locale.ROOT, "Cannot create instance of %s", this.clazz.getName()), ia);
                }
                catch (NoSuchMethodException nsme) {
                    throw new RemoteProtocolException(String.format(Locale.ROOT, "No constructor found for clazz: %s. Available constructors: %s", this.clazz.getName(), Arrays.asList(this.clazz.getConstructors())), nsme);
                }
                catch (SecurityException se) {
                    throw new RemoteProtocolException(String.format(Locale.ROOT, "Constructor not accessible: %s", constructor.getName()), se);
                }
            }
            catch (Throwable throwable) {
                LogUtil.logDebug((String)TAG, (String)"%s(%s)", (Object[])new Object[]{this.clazz.getSimpleName(), LogUtil.lazyArg(() -> Arrays.toString(constructorParams))});
                throw throwable;
            }
        }
        LogUtil.logDebug((String)TAG, (String)"%s(%s)", (Object[])new Object[]{this.clazz.getSimpleName(), LogUtil.lazyArg(() -> Arrays.toString(constructorParams))});
        return returnValue;
    }

    private static final class ConstructorKey {
        private final Class<?> type;
        private final Class<?>[] parameterTypes;

        public ConstructorKey(Class<?> type, Class<?>[] parameterTypes) {
            this.type = type;
            this.parameterTypes = parameterTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConstructorKey that = (ConstructorKey)o;
            if (!this.type.equals(that.type)) {
                return false;
            }
            return Arrays.equals(this.parameterTypes, that.parameterTypes);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + Arrays.hashCode(this.parameterTypes);
            return result;
        }
    }
}

