/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.webkit.WebView;
import android.widget.Checkable;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.test.espresso.matcher.BoundedDiagnosingMatcher;
import androidx.test.espresso.matcher.HasBackgroundMatcher;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.IterablesKt;
import androidx.test.espresso.util.TreeIterables;
import androidx.test.internal.util.Checks;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import org.hamcrest.Description;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class ViewMatchers {
    private static final Pattern RESOURCE_ID_PATTERN = Pattern.compile("\\d+");

    private ViewMatchers() {
    }

    public static org.hamcrest.Matcher<View> isAssignableFrom(Class<? extends View> clazz) {
        return new IsAssignableFromMatcher(clazz);
    }

    public static org.hamcrest.Matcher<View> withClassName(org.hamcrest.Matcher<String> classNameMatcher) {
        return new WithClassNameMatcher((org.hamcrest.Matcher)Checks.checkNotNull(classNameMatcher));
    }

    public static org.hamcrest.Matcher<View> isDisplayed() {
        return new IsDisplayedMatcher();
    }

    public static org.hamcrest.Matcher<View> isCompletelyDisplayed() {
        return ViewMatchers.isDisplayingAtLeast(100);
    }

    public static org.hamcrest.Matcher<View> isDisplayingAtLeast(int areaPercentage) {
        Checks.checkArgument((areaPercentage <= 100 ? 1 : 0) != 0, (String)"Cannot have over 100 percent: %s", (Object[])new Object[]{areaPercentage});
        Checks.checkArgument((areaPercentage > 0 ? 1 : 0) != 0, (String)"Must have a positive, non-zero value: %s", (Object[])new Object[]{areaPercentage});
        return new IsDisplayingAtLeastMatcher(areaPercentage);
    }

    public static org.hamcrest.Matcher<View> isEnabled() {
        return new IsEnabledMatcher(true);
    }

    public static org.hamcrest.Matcher<View> isNotEnabled() {
        return new IsEnabledMatcher(false);
    }

    public static org.hamcrest.Matcher<View> isFocusable() {
        return new IsFocusableMatcher(true);
    }

    public static org.hamcrest.Matcher<View> isNotFocusable() {
        return new IsFocusableMatcher(false);
    }

    public static org.hamcrest.Matcher<View> isFocused() {
        return new IsFocusedMatcher(true);
    }

    public static org.hamcrest.Matcher<View> isNotFocused() {
        return new IsFocusedMatcher(false);
    }

    public static org.hamcrest.Matcher<View> hasFocus() {
        return new HasFocusMatcher(true);
    }

    public static org.hamcrest.Matcher<View> doesNotHaveFocus() {
        return new HasFocusMatcher(false);
    }

    public static org.hamcrest.Matcher<View> isSelected() {
        return new IsSelectedMatcher(true);
    }

    public static org.hamcrest.Matcher<View> isNotSelected() {
        return new IsSelectedMatcher(false);
    }

    public static org.hamcrest.Matcher<View> isActivated() {
        return new IsActivatedMatcher(true);
    }

    public static org.hamcrest.Matcher<View> isNotActivated() {
        return new IsActivatedMatcher(false);
    }

    public static org.hamcrest.Matcher<View> hasSibling(org.hamcrest.Matcher<View> siblingMatcher) {
        return new HasSiblingMatcher((org.hamcrest.Matcher)Checks.checkNotNull(siblingMatcher));
    }

    public static org.hamcrest.Matcher<View> withContentDescription(int resourceId) {
        return new WithContentDescriptionFromIdMatcher(resourceId);
    }

    public static org.hamcrest.Matcher<View> withContentDescription(String text) {
        return new WithContentDescriptionTextMatcher(Matchers.is((Object)text));
    }

    public static org.hamcrest.Matcher<View> withContentDescription(org.hamcrest.Matcher<? extends CharSequence> charSequenceMatcher) {
        return new WithContentDescriptionMatcher((org.hamcrest.Matcher)Checks.checkNotNull(charSequenceMatcher));
    }

    public static org.hamcrest.Matcher<View> withId(int id) {
        return ViewMatchers.withId((org.hamcrest.Matcher<Integer>)Matchers.is((Object)id));
    }

    public static org.hamcrest.Matcher<View> withId(org.hamcrest.Matcher<Integer> integerMatcher) {
        return new WithIdMatcher((org.hamcrest.Matcher)Checks.checkNotNull(integerMatcher));
    }

    public static org.hamcrest.Matcher<View> withResourceName(String name) {
        return ViewMatchers.withResourceName((org.hamcrest.Matcher<String>)Matchers.is((Object)name));
    }

    public static org.hamcrest.Matcher<View> withResourceName(org.hamcrest.Matcher<String> stringMatcher) {
        return new WithResourceNameMatcher((org.hamcrest.Matcher)Checks.checkNotNull(stringMatcher));
    }

    public static org.hamcrest.Matcher<View> withTagKey(int key) {
        return ViewMatchers.withTagKey(key, Matchers.notNullValue());
    }

    public static org.hamcrest.Matcher<View> withTagKey(int key, org.hamcrest.Matcher<?> objectMatcher) {
        return new WithTagKeyMatcher(key, (org.hamcrest.Matcher)Checks.checkNotNull(objectMatcher));
    }

    public static org.hamcrest.Matcher<View> withTagValue(org.hamcrest.Matcher<Object> tagValueMatcher) {
        return new WithTagValueMatcher((org.hamcrest.Matcher)Checks.checkNotNull(tagValueMatcher));
    }

    public static org.hamcrest.Matcher<View> withText(String text) {
        return ViewMatchers.withText((org.hamcrest.Matcher<String>)Matchers.is((Object)text));
    }

    public static org.hamcrest.Matcher<View> withText(org.hamcrest.Matcher<String> stringMatcher) {
        return new WithTextMatcher((org.hamcrest.Matcher)Checks.checkNotNull(stringMatcher));
    }

    public static org.hamcrest.Matcher<View> withText(int resourceId) {
        return new WithCharSequenceMatcher(resourceId, WithCharSequenceMatcher.TextViewMethod.GET_TEXT);
    }

    public static org.hamcrest.Matcher<View> withSubstring(String substring) {
        return ViewMatchers.withText((org.hamcrest.Matcher<String>)Matchers.containsString((String)substring));
    }

    public static org.hamcrest.Matcher<View> withHint(String hintText) {
        return ViewMatchers.withHint((org.hamcrest.Matcher<String>)Matchers.is((Object)((String)Checks.checkNotNull((Object)hintText))));
    }

    public static org.hamcrest.Matcher<View> withHint(org.hamcrest.Matcher<String> stringMatcher) {
        return new WithHintMatcher((org.hamcrest.Matcher)Checks.checkNotNull(stringMatcher));
    }

    public static org.hamcrest.Matcher<View> withHint(int resourceId) {
        return new WithCharSequenceMatcher(resourceId, WithCharSequenceMatcher.TextViewMethod.GET_HINT);
    }

    public static org.hamcrest.Matcher<View> isChecked() {
        return ViewMatchers.withCheckBoxState((org.hamcrest.Matcher<Boolean>)Matchers.is((Object)true));
    }

    public static org.hamcrest.Matcher<View> isNotChecked() {
        return ViewMatchers.withCheckBoxState((org.hamcrest.Matcher<Boolean>)Matchers.is((Object)false));
    }

    private static <E extends View> org.hamcrest.Matcher<View> withCheckBoxState(org.hamcrest.Matcher<Boolean> checkStateMatcher) {
        return new WithCheckBoxStateMatcher(checkStateMatcher);
    }

    public static org.hamcrest.Matcher<View> hasContentDescription() {
        return new HasContentDescriptionMatcher();
    }

    public static org.hamcrest.Matcher<View> hasDescendant(org.hamcrest.Matcher<View> descendantMatcher) {
        return new HasDescendantMatcher((org.hamcrest.Matcher)Checks.checkNotNull(descendantMatcher));
    }

    public static org.hamcrest.Matcher<View> isClickable() {
        return new IsClickableMatcher(true);
    }

    public static org.hamcrest.Matcher<View> isNotClickable() {
        return new IsClickableMatcher(false);
    }

    public static org.hamcrest.Matcher<View> isDescendantOfA(org.hamcrest.Matcher<View> ancestorMatcher) {
        return new IsDescendantOfAMatcher((org.hamcrest.Matcher)Checks.checkNotNull(ancestorMatcher));
    }

    public static org.hamcrest.Matcher<View> withEffectiveVisibility(Visibility visibility) {
        return new WithEffectiveVisibilityMatcher(visibility);
    }

    public static org.hamcrest.Matcher<View> withAlpha(float alpha) {
        return new WithAlphaMatcher(alpha);
    }

    public static org.hamcrest.Matcher<View> withParent(org.hamcrest.Matcher<View> parentMatcher) {
        return new WithParentMatcher((org.hamcrest.Matcher)Checks.checkNotNull(parentMatcher));
    }

    public static org.hamcrest.Matcher<View> withChild(org.hamcrest.Matcher<View> childMatcher) {
        return new WithChildMatcher((org.hamcrest.Matcher)Checks.checkNotNull(childMatcher));
    }

    public static org.hamcrest.Matcher<View> hasChildCount(int childCount) {
        return new HasChildCountMatcher(childCount);
    }

    public static org.hamcrest.Matcher<View> hasMinimumChildCount(int minChildCount) {
        return new HasMinimumChildCountMatcher(minChildCount);
    }

    public static org.hamcrest.Matcher<View> isRoot() {
        return new IsRootMatcher();
    }

    public static org.hamcrest.Matcher<View> supportsInputMethods() {
        return new SupportsInputMethodsMatcher();
    }

    public static org.hamcrest.Matcher<View> hasImeAction(int imeAction) {
        return ViewMatchers.hasImeAction((org.hamcrest.Matcher<Integer>)Matchers.is((Object)imeAction));
    }

    public static org.hamcrest.Matcher<View> hasImeAction(org.hamcrest.Matcher<Integer> imeActionMatcher) {
        return new HasImeActionMatcher(imeActionMatcher);
    }

    public static org.hamcrest.Matcher<View> hasLinks() {
        return new HasLinksMatcher();
    }

    public static <T> void assertThat(T actual, org.hamcrest.Matcher<T> matcher) {
        ViewMatchers.assertThat("", actual, matcher);
    }

    public static <T> void assertThat(String message, T actual, org.hamcrest.Matcher<T> matcher) {
        if (!matcher.matches(actual)) {
            StringDescription description = new StringDescription();
            String mismatchDescriptionString = ViewMatchers.getMismatchDescriptionString(actual, matcher);
            description.appendText(message).appendText("\nExpected: ").appendDescriptionOf(matcher).appendText("\n     Got: ").appendText(mismatchDescriptionString);
            if (actual instanceof View) {
                description.appendText("\nView Details: ").appendText(HumanReadables.describe((View)actual));
            }
            description.appendText("\n");
            throw new AssertionFailedError(description.toString());
        }
    }

    private static <T> String getMismatchDescriptionString(T actual, org.hamcrest.Matcher<T> matcher) {
        StringDescription mismatchDescription = new StringDescription();
        matcher.describeMismatch(actual, (Description)mismatchDescription);
        String mismatchDescriptionString = mismatchDescription.toString().trim();
        return mismatchDescriptionString.isEmpty() ? actual.toString() : mismatchDescriptionString;
    }

    public static org.hamcrest.Matcher<View> withSpinnerText(int resourceId) {
        return new WithSpinnerTextIdMatcher(resourceId);
    }

    public static org.hamcrest.Matcher<View> withSpinnerText(org.hamcrest.Matcher<String> stringMatcher) {
        return new WithSpinnerTextMatcher((org.hamcrest.Matcher)Checks.checkNotNull(stringMatcher));
    }

    public static org.hamcrest.Matcher<View> withSpinnerText(String text) {
        return ViewMatchers.withSpinnerText((org.hamcrest.Matcher<String>)Matchers.is((Object)text));
    }

    public static org.hamcrest.Matcher<View> isJavascriptEnabled() {
        return new IsJavascriptEnabledMatcher();
    }

    public static org.hamcrest.Matcher<View> hasErrorText(org.hamcrest.Matcher<String> stringMatcher) {
        return new HasErrorTextMatcher((org.hamcrest.Matcher)Checks.checkNotNull(stringMatcher));
    }

    public static org.hamcrest.Matcher<View> hasErrorText(String expectedError) {
        return ViewMatchers.hasErrorText((org.hamcrest.Matcher<String>)Matchers.is((Object)expectedError));
    }

    public static org.hamcrest.Matcher<View> withInputType(int inputType) {
        return new WithInputTypeMatcher(inputType);
    }

    public static org.hamcrest.Matcher<View> withParentIndex(int index) {
        Checks.checkArgument((index >= 0 ? 1 : 0) != 0, (String)"Index %s must be >= 0", (Object[])new Object[]{index});
        return new WithParentIndexMatcher(index);
    }

    public static org.hamcrest.Matcher<View> hasBackground(int drawableId) {
        return new HasBackgroundMatcher(drawableId);
    }

    public static org.hamcrest.Matcher<View> hasTextColor(final int colorResId) {
        return new BoundedDiagnosingMatcher<View, TextView>(TextView.class){
            private Context context;

            @Override
            protected boolean matchesSafely(TextView textView, Description mismatchDescription) {
                this.context = textView.getContext();
                int textViewColor = textView.getCurrentTextColor();
                int expectedColor = Build.VERSION.SDK_INT <= 22 ? this.context.getResources().getColor(colorResId) : this.context.getColor(colorResId);
                mismatchDescription.appendText("textView.getCurrentTextColor() was ").appendText(this.getColorHex(textViewColor));
                return textViewColor == expectedColor;
            }

            @Override
            protected void describeMoreTo(Description description) {
                description.appendText("textView.getCurrentTextColor() is color with ");
                if (this.context == null) {
                    description.appendText("ID ").appendValue((Object)colorResId);
                } else {
                    int color = Build.VERSION.SDK_INT <= 22 ? this.context.getResources().getColor(colorResId) : this.context.getColor(colorResId);
                    description.appendText("value " + this.getColorHex(color));
                }
            }

            private String getColorHex(int color) {
                return String.format(Locale.ROOT, "#%02X%06X", 0xFF & Color.alpha((int)color), 0xFFFFFF & color);
            }
        };
    }

    private static String safeGetResourceName(Resources res, int id) {
        try {
            return ViewMatchers.isViewIdGenerated(id) ? null : res.getResourceName(id);
        }
        catch (Resources.NotFoundException e) {
            return null;
        }
    }

    private static String safeGetResourceEntryName(Resources res, int id) {
        try {
            return ViewMatchers.isViewIdGenerated(id) ? null : res.getResourceEntryName(id);
        }
        catch (Resources.NotFoundException e) {
            return null;
        }
    }

    private static boolean isViewIdGenerated(int id) {
        return (id & 0xFF000000) == 0 && (id & 0xFFFFFF) != 0;
    }

    @VisibleForTesting
    static final class WithParentIndexMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final int index;
        private final org.hamcrest.Matcher<ViewGroup> parentViewGroupMatcher = Matchers.isA(ViewGroup.class);

        @RemoteMsgConstructor
        private WithParentIndexMatcher(int index) {
            this.index = index;
        }

        public void describeTo(Description description) {
            description.appendText("(view.getParent() ").appendDescriptionOf(this.parentViewGroupMatcher).appendText(" and is at child index ").appendValue((Object)this.index).appendText(")");
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            ViewParent parent = view.getParent();
            if (!this.parentViewGroupMatcher.matches((Object)parent)) {
                mismatchDescription.appendText("view.getParent() ");
                this.parentViewGroupMatcher.describeMismatch((Object)parent, mismatchDescription);
                return false;
            }
            if (((ViewGroup)parent).getChildCount() <= this.index) {
                mismatchDescription.appendText("parent only has ").appendValue((Object)((ViewGroup)parent).getChildCount()).appendText(" children");
                return false;
            }
            View child = ((ViewGroup)parent).getChildAt(this.index);
            if (child != view) {
                mismatchDescription.appendText("child view at index ").appendValue((Object)this.index).appendText(" was ").appendValue((Object)child);
                return false;
            }
            return true;
        }
    }

    @VisibleForTesting
    static final class WithInputTypeMatcher
    extends BoundedDiagnosingMatcher<View, EditText> {
        @RemoteMsgField(order=0)
        private final int inputType;

        @RemoteMsgConstructor
        private WithInputTypeMatcher(int inputType) {
            super(EditText.class);
            this.inputType = inputType;
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("editText.getInputType() is ").appendValue((Object)this.inputType);
        }

        @Override
        protected boolean matchesSafely(EditText view, Description mismatchDescription) {
            mismatchDescription.appendText("editText.getInputType() was ").appendValue((Object)view.getInputType());
            return view.getInputType() == this.inputType;
        }
    }

    @VisibleForTesting
    static final class HasErrorTextMatcher
    extends BoundedDiagnosingMatcher<View, EditText> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<String> stringMatcher;

        @RemoteMsgConstructor
        private HasErrorTextMatcher(org.hamcrest.Matcher<String> stringMatcher) {
            super(EditText.class);
            this.stringMatcher = stringMatcher;
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("editText.getError() to match ").appendDescriptionOf(this.stringMatcher);
        }

        @Override
        protected boolean matchesSafely(EditText view, Description mismatchDescription) {
            mismatchDescription.appendText("editText.getError() was ").appendValue((Object)view.getError());
            return this.stringMatcher.matches((Object)view.getError());
        }
    }

    @VisibleForTesting
    static final class IsJavascriptEnabledMatcher
    extends BoundedDiagnosingMatcher<View, WebView> {
        @RemoteMsgConstructor
        private IsJavascriptEnabledMatcher() {
            super(WebView.class);
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("webView.getSettings().getJavaScriptEnabled() is ").appendValue((Object)true);
        }

        @Override
        protected boolean matchesSafely(WebView webView, Description mismatchDescription) {
            mismatchDescription.appendText("webView.getSettings().getJavaScriptEnabled() was ").appendValue((Object)webView.getSettings().getJavaScriptEnabled());
            return webView.getSettings().getJavaScriptEnabled();
        }
    }

    @VisibleForTesting
    static final class WithSpinnerTextMatcher
    extends BoundedDiagnosingMatcher<View, Spinner> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<String> stringMatcher;

        @RemoteMsgConstructor
        private WithSpinnerTextMatcher(org.hamcrest.Matcher<String> stringMatcher) {
            super(Spinner.class);
            this.stringMatcher = stringMatcher;
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("spinner.getSelectedItem().toString() to match ").appendDescriptionOf(this.stringMatcher);
        }

        @Override
        protected boolean matchesSafely(Spinner spinner, Description mismatchDescription) {
            Object selectedItem = spinner.getSelectedItem();
            if (selectedItem == null) {
                mismatchDescription.appendText("spinner.getSelectedItem() was null");
                return false;
            }
            mismatchDescription.appendText("spinner.getSelectedItem().toString() was ").appendValue((Object)selectedItem.toString());
            return this.stringMatcher.matches((Object)spinner.getSelectedItem().toString());
        }
    }

    @VisibleForTesting
    static final class WithSpinnerTextIdMatcher
    extends BoundedDiagnosingMatcher<View, Spinner> {
        @RemoteMsgField(order=0)
        private final int resourceId;
        private String resourceName = null;
        private String expectedText = null;

        @RemoteMsgConstructor
        private WithSpinnerTextIdMatcher(int resourceId) {
            super(Spinner.class);
            this.resourceId = resourceId;
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("spinner.getSelectedItem().toString() to match string from resource id: ").appendValue((Object)this.resourceId);
            if (this.resourceName != null) {
                description.appendText(" [").appendText(this.resourceName).appendText("]");
            }
            if (this.expectedText != null) {
                description.appendText(" value: ").appendText(this.expectedText);
            }
        }

        @Override
        protected boolean matchesSafely(Spinner spinner, Description mismatchDescription) {
            if (this.expectedText == null) {
                try {
                    this.expectedText = spinner.getResources().getString(this.resourceId);
                }
                catch (Resources.NotFoundException notFoundException) {
                    // empty catch block
                }
                this.resourceName = ViewMatchers.safeGetResourceEntryName(spinner.getResources(), this.resourceId);
            }
            if (this.expectedText == null) {
                mismatchDescription.appendText("failure to resolve resourceId ").appendValue((Object)this.resourceId);
                return false;
            }
            Object selectedItem = spinner.getSelectedItem();
            if (selectedItem == null) {
                mismatchDescription.appendText("spinner.getSelectedItem() was null");
                return false;
            }
            mismatchDescription.appendText("spinner.getSelectedItem().toString() was ").appendValue((Object)selectedItem.toString());
            return this.expectedText.equals(selectedItem.toString());
        }
    }

    @VisibleForTesting
    static final class HasLinksMatcher
    extends BoundedDiagnosingMatcher<View, TextView> {
        @RemoteMsgConstructor
        private HasLinksMatcher() {
            super(TextView.class);
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("textView.getUrls().length > 0");
        }

        @Override
        protected boolean matchesSafely(TextView textView, Description mismatchDescription) {
            mismatchDescription.appendText("textView.getUrls().length was ").appendValue((Object)textView.getUrls().length);
            return textView.getUrls().length > 0;
        }
    }

    @VisibleForTesting
    static final class HasImeActionMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<Integer> imeActionMatcher;

        @RemoteMsgConstructor
        private HasImeActionMatcher(org.hamcrest.Matcher<Integer> imeActionMatcher) {
            this.imeActionMatcher = imeActionMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("(view.onCreateInputConnection() is not null and editorInfo.actionId ").appendDescriptionOf(this.imeActionMatcher).appendText(")");
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            int actionId;
            EditorInfo editorInfo = new EditorInfo();
            InputConnection inputConnection = view.onCreateInputConnection(editorInfo);
            if (inputConnection == null) {
                mismatchDescription.appendText("view.onCreateInputConnection() was null");
                return false;
            }
            int n = actionId = editorInfo.actionId != 0 ? editorInfo.actionId : editorInfo.imeOptions & 0xFF;
            if (!this.imeActionMatcher.matches((Object)actionId)) {
                mismatchDescription.appendText("editorInfo.actionId ");
                this.imeActionMatcher.describeMismatch((Object)actionId, mismatchDescription);
                return false;
            }
            return true;
        }
    }

    @VisibleForTesting
    static final class SupportsInputMethodsMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgConstructor
        private SupportsInputMethodsMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("view.onCreateInputConnection() is not null");
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            if (view.onCreateInputConnection(new EditorInfo()) == null) {
                mismatchDescription.appendText("view.onCreateInputConnection() was null");
                return false;
            }
            return true;
        }
    }

    @VisibleForTesting
    static final class IsRootMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgConstructor
        private IsRootMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("view.getRootView() to equal view");
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            View rootView = view.getRootView();
            if (rootView != view) {
                mismatchDescription.appendText("view.getRootView() was ").appendValue((Object)rootView);
                return false;
            }
            return true;
        }
    }

    @VisibleForTesting
    static final class HasMinimumChildCountMatcher
    extends BoundedDiagnosingMatcher<View, ViewGroup> {
        @RemoteMsgField(order=0)
        private final int minChildCount;

        @RemoteMsgConstructor
        private HasMinimumChildCountMatcher(int minChildCount) {
            super(ViewGroup.class);
            this.minChildCount = minChildCount;
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("viewGroup.getChildCount() to be at least ").appendValue((Object)this.minChildCount);
        }

        @Override
        protected boolean matchesSafely(ViewGroup viewGroup, Description mismatchDescription) {
            mismatchDescription.appendText("viewGroup.getChildCount() was ").appendValue((Object)viewGroup.getChildCount());
            return viewGroup.getChildCount() >= this.minChildCount;
        }
    }

    @VisibleForTesting
    static final class HasChildCountMatcher
    extends BoundedDiagnosingMatcher<View, ViewGroup> {
        @RemoteMsgField(order=0)
        private final int childCount;

        @RemoteMsgConstructor
        private HasChildCountMatcher(int childCount) {
            super(ViewGroup.class);
            this.childCount = childCount;
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("viewGroup.getChildCount() to be ").appendValue((Object)this.childCount);
        }

        @Override
        protected boolean matchesSafely(ViewGroup viewGroup, Description mismatchDescription) {
            mismatchDescription.appendText("viewGroup.getChildCount() was ").appendValue((Object)viewGroup.getChildCount());
            return viewGroup.getChildCount() == this.childCount;
        }
    }

    @VisibleForTesting
    static final class WithChildMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<View> childMatcher;
        private final org.hamcrest.Matcher<ViewGroup> viewGroupMatcher = Matchers.isA(ViewGroup.class);

        @RemoteMsgConstructor
        private WithChildMatcher(org.hamcrest.Matcher<View> childMatcher) {
            this.childMatcher = childMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("(view ").appendDescriptionOf(this.viewGroupMatcher).appendText(" and has child matching: ").appendDescriptionOf(this.childMatcher).appendText(")");
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            if (!this.viewGroupMatcher.matches((Object)view)) {
                mismatchDescription.appendText("view ");
                this.viewGroupMatcher.describeMismatch((Object)view, mismatchDescription);
                return false;
            }
            ViewGroup group = (ViewGroup)view;
            for (int i = 0; i < group.getChildCount(); ++i) {
                if (!this.childMatcher.matches((Object)group.getChildAt(i))) continue;
                return true;
            }
            mismatchDescription.appendText("All ").appendValue((Object)group.getChildCount()).appendText(" children did not match");
            return false;
        }
    }

    @VisibleForTesting
    static final class WithParentMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<View> parentMatcher;

        @RemoteMsgConstructor
        private WithParentMatcher(org.hamcrest.Matcher<View> parentMatcher) {
            this.parentMatcher = parentMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("view.getParent() ").appendDescriptionOf(this.parentMatcher);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            ViewParent parent = view.getParent();
            if (!this.parentMatcher.matches((Object)parent)) {
                mismatchDescription.appendText("view.getParent() ");
                this.parentMatcher.describeMismatch((Object)parent, mismatchDescription);
                return false;
            }
            return true;
        }
    }

    @VisibleForTesting
    static final class WithAlphaMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final float alpha;

        @RemoteMsgConstructor
        private WithAlphaMatcher(float alpha) {
            this.alpha = alpha;
        }

        public void describeTo(Description description) {
            description.appendText("view.getAlpha() is ").appendValue((Object)Float.valueOf(this.alpha));
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            float alpha = view.getAlpha();
            if (alpha != this.alpha) {
                mismatchDescription.appendText("view.getAlpha() was ").appendValue((Object)Float.valueOf(alpha));
                return false;
            }
            return true;
        }
    }

    @VisibleForTesting
    static final class WithEffectiveVisibilityMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final Visibility visibility;

        @RemoteMsgConstructor
        private WithEffectiveVisibilityMatcher(Visibility visibility) {
            this.visibility = visibility;
        }

        public void describeTo(Description description) {
            description.appendText("view has effective visibility ").appendValue((Object)this.visibility);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            if (this.visibility.getValue() == 0) {
                if (view.getVisibility() != this.visibility.getValue()) {
                    mismatchDescription.appendText("view.getVisibility() was ").appendValue((Object)Visibility.forViewVisibility(view));
                    return false;
                }
                while (view.getParent() instanceof View) {
                    if ((view = (View)view.getParent()).getVisibility() == this.visibility.getValue()) continue;
                    mismatchDescription.appendText("ancestor ").appendValue((Object)view).appendText("'s getVisibility() was ").appendValue((Object)Visibility.forViewVisibility(view));
                    return false;
                }
                return true;
            }
            if (view.getVisibility() == this.visibility.getValue()) {
                return true;
            }
            while (view.getParent() instanceof View) {
                if ((view = (View)view.getParent()).getVisibility() != this.visibility.getValue()) continue;
                return true;
            }
            mismatchDescription.appendText("neither view nor its ancestors have getVisibility() set to ").appendValue((Object)this.visibility);
            return false;
        }
    }

    @VisibleForTesting
    static final class IsDescendantOfAMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<View> ancestorMatcher;

        @RemoteMsgConstructor
        private IsDescendantOfAMatcher(org.hamcrest.Matcher<View> ancestorMatcher) {
            this.ancestorMatcher = ancestorMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("is descendant of a view matching ").appendDescriptionOf(this.ancestorMatcher);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            boolean matches = this.checkAncestors(view.getParent());
            if (!matches) {
                mismatchDescription.appendText("none of the ancestors match ").appendDescriptionOf(this.ancestorMatcher);
            }
            return matches;
        }

        private boolean checkAncestors(ViewParent viewParent) {
            if (!(viewParent instanceof View)) {
                return false;
            }
            if (this.ancestorMatcher.matches((Object)viewParent)) {
                return true;
            }
            return this.checkAncestors(viewParent.getParent());
        }
    }

    @VisibleForTesting
    static final class IsClickableMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final boolean isClickable;

        @RemoteMsgConstructor
        private IsClickableMatcher(boolean isClickable) {
            this.isClickable = isClickable;
        }

        public void describeTo(Description description) {
            description.appendText("view.isClickable() is ").appendValue((Object)this.isClickable);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            boolean isClickable = view.isClickable();
            if (isClickable != this.isClickable) {
                mismatchDescription.appendText("view.isClickable() was ").appendValue((Object)isClickable);
                return false;
            }
            return true;
        }
    }

    @VisibleForTesting
    static final class HasDescendantMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<View> descendantMatcher;
        private final org.hamcrest.Matcher<ViewGroup> isViewGroupMatcher = Matchers.isA(ViewGroup.class);

        @RemoteMsgConstructor
        private HasDescendantMatcher(org.hamcrest.Matcher<View> descendantMatcher) {
            this.descendantMatcher = descendantMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("(view ").appendDescriptionOf(this.isViewGroupMatcher).appendText(" and has descendant matching ").appendDescriptionOf(this.descendantMatcher).appendText(")");
        }

        protected boolean matchesSafely(final View view, Description mismatchDescription) {
            if (!this.isViewGroupMatcher.matches((Object)view)) {
                mismatchDescription.appendText("view ");
                this.isViewGroupMatcher.describeMismatch((Object)view, mismatchDescription);
                return false;
            }
            TypeSafeDiagnosingMatcher<View> matcherPredicate = new TypeSafeDiagnosingMatcher<View>(){

                public void describeTo(Description description) {
                }

                protected boolean matchesSafely(View input, Description description) {
                    return input != view && descendantMatcher.matches((Object)input);
                }
            };
            Iterator<View> matchedViewIterator = IterablesKt.filter(TreeIterables.breadthFirstViewTraversal(view), matcherPredicate).iterator();
            if (!matchedViewIterator.hasNext()) {
                mismatchDescription.appendText("no descendant matching ").appendDescriptionOf(this.descendantMatcher).appendText(" was found");
                return false;
            }
            return true;
        }
    }

    @VisibleForTesting
    static final class HasContentDescriptionMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgConstructor
        private HasContentDescriptionMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("view.getContentDescription() is not null");
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            if (view.getContentDescription() == null) {
                mismatchDescription.appendText("view.getContentDescription() was null");
                return false;
            }
            return true;
        }
    }

    @VisibleForTesting
    static final class WithCheckBoxStateMatcher<E extends View>
    extends BoundedDiagnosingMatcher<View, E> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<Boolean> checkStateMatcher;

        @RemoteMsgConstructor
        private WithCheckBoxStateMatcher(org.hamcrest.Matcher<Boolean> checkStateMatcher) {
            super(View.class, Checkable.class, new Class[0]);
            this.checkStateMatcher = checkStateMatcher;
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("view.isChecked() matching: ").appendDescriptionOf(this.checkStateMatcher);
        }

        @Override
        protected boolean matchesSafely(E checkable, Description mismatchDescription) {
            boolean isChecked = ((Checkable)checkable).isChecked();
            mismatchDescription.appendText("view.isChecked() was ").appendValue((Object)isChecked);
            return this.checkStateMatcher.matches((Object)isChecked);
        }
    }

    @VisibleForTesting
    static final class WithHintMatcher
    extends BoundedDiagnosingMatcher<View, TextView> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<String> stringMatcher;

        @RemoteMsgConstructor
        private WithHintMatcher(org.hamcrest.Matcher<String> stringMatcher) {
            super(TextView.class);
            this.stringMatcher = stringMatcher;
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("view.getHint() matching: ");
            this.stringMatcher.describeTo(description);
        }

        @Override
        protected boolean matchesSafely(TextView textView, Description mismatchDescription) {
            CharSequence hint = textView.getHint();
            mismatchDescription.appendText("view.getHint() was ").appendValue((Object)hint);
            return this.stringMatcher.matches((Object)hint);
        }
    }

    @VisibleForTesting
    static final class WithCharSequenceMatcher
    extends BoundedDiagnosingMatcher<View, TextView> {
        @RemoteMsgField(order=0)
        private final int resourceId;
        @RemoteMsgField(order=1)
        private final TextViewMethod method;
        @Nullable
        private String resourceName;
        @Nullable
        private String expectedText;

        @RemoteMsgConstructor
        private WithCharSequenceMatcher(int resourceId, TextViewMethod method) {
            super(TextView.class);
            this.resourceId = resourceId;
            this.method = method;
        }

        @Override
        protected void describeMoreTo(Description description) {
            switch (this.method) {
                case GET_TEXT: {
                    description.appendText("view.getText()");
                    break;
                }
                case GET_HINT: {
                    description.appendText("view.getHint()");
                }
            }
            description.appendText(" equals string from resource id: ").appendValue((Object)this.resourceId);
            if (null != this.resourceName) {
                description.appendText(" [").appendText(this.resourceName).appendText("]");
            }
            if (null != this.expectedText) {
                description.appendText(" value: ").appendText(this.expectedText);
            }
        }

        @Override
        protected boolean matchesSafely(TextView textView, Description mismatchDescription) {
            CharSequence actualText;
            if (null == this.expectedText) {
                try {
                    this.expectedText = textView.getResources().getString(this.resourceId);
                }
                catch (Resources.NotFoundException notFoundException) {
                    // empty catch block
                }
                this.resourceName = ViewMatchers.safeGetResourceEntryName(textView.getResources(), this.resourceId);
            }
            switch (this.method) {
                case GET_TEXT: {
                    actualText = textView.getText();
                    mismatchDescription.appendText("view.getText() was ");
                    break;
                }
                case GET_HINT: {
                    actualText = textView.getHint();
                    mismatchDescription.appendText("view.getHint() was ");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected TextView method: " + (Object)((Object)this.method));
                }
            }
            mismatchDescription.appendValue((Object)actualText);
            return null != this.expectedText && null != actualText && this.expectedText.contentEquals(actualText);
        }

        private static enum TextViewMethod {
            GET_TEXT,
            GET_HINT;

        }
    }

    @VisibleForTesting
    static final class WithTagValueMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<Object> tagValueMatcher;

        @RemoteMsgConstructor
        private WithTagValueMatcher(org.hamcrest.Matcher<Object> tagValueMatcher) {
            this.tagValueMatcher = tagValueMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("view.getTag() ").appendDescriptionOf(this.tagValueMatcher);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            Object tag = view.getTag();
            if (!this.tagValueMatcher.matches(tag)) {
                mismatchDescription.appendText("view.getTag() ");
                this.tagValueMatcher.describeMismatch(tag, mismatchDescription);
                return false;
            }
            return true;
        }
    }

    @VisibleForTesting
    static final class WithContentDescriptionTextMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<String> textMatcher;

        @RemoteMsgConstructor
        private WithContentDescriptionTextMatcher(org.hamcrest.Matcher<String> textMatcher) {
            this.textMatcher = textMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("view.getContentDescription() ").appendDescriptionOf(this.textMatcher);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            String descriptionText;
            String string = descriptionText = view.getContentDescription() != null ? view.getContentDescription().toString() : null;
            if (!this.textMatcher.matches((Object)descriptionText)) {
                mismatchDescription.appendText("view.getContentDescription() ");
                this.textMatcher.describeMismatch((Object)descriptionText, mismatchDescription);
                return false;
            }
            return true;
        }
    }

    @VisibleForTesting
    static final class WithContentDescriptionMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<? extends CharSequence> charSequenceMatcher;

        @RemoteMsgConstructor
        private WithContentDescriptionMatcher(org.hamcrest.Matcher<? extends CharSequence> charSequenceMatcher) {
            this.charSequenceMatcher = charSequenceMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("view.getContentDescription() ").appendDescriptionOf(this.charSequenceMatcher);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            CharSequence contentDescription = view.getContentDescription();
            if (!this.charSequenceMatcher.matches((Object)contentDescription)) {
                mismatchDescription.appendText("view.getContentDescription() ");
                this.charSequenceMatcher.describeMismatch((Object)contentDescription, mismatchDescription);
                return false;
            }
            return true;
        }
    }

    static final class WithContentDescriptionFromIdMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final int resourceId;
        private String resourceName = null;
        private String expectedText = null;

        @RemoteMsgConstructor
        private WithContentDescriptionFromIdMatcher(int resourceId) {
            this.resourceId = resourceId;
        }

        public void describeTo(Description description) {
            description.appendText("view.getContentDescription() to match resource id ").appendValue((Object)this.resourceId);
            if (this.resourceName != null) {
                description.appendText("[").appendText(this.resourceName).appendText("]");
            }
            if (this.expectedText != null) {
                description.appendText(" with value ").appendValue((Object)this.expectedText);
            }
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            if (null == this.expectedText) {
                try {
                    this.expectedText = view.getResources().getString(this.resourceId);
                }
                catch (Resources.NotFoundException notFoundException) {
                    // empty catch block
                }
                this.resourceName = ViewMatchers.safeGetResourceEntryName(view.getResources(), this.resourceId);
            }
            if (this.expectedText == null) {
                mismatchDescription.appendText("Failed to resolve resource id ").appendValue((Object)this.resourceId);
                return false;
            }
            CharSequence contentDescription = view.getContentDescription();
            if (contentDescription == null || !this.expectedText.contentEquals(contentDescription)) {
                mismatchDescription.appendText("view.getContentDescription() was ").appendValue((Object)contentDescription);
                return false;
            }
            return true;
        }
    }

    static final class HasSiblingMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<View> siblingMatcher;
        private final org.hamcrest.Matcher<ViewGroup> parentMatcher = Matchers.isA(ViewGroup.class);

        @RemoteMsgConstructor
        private HasSiblingMatcher(org.hamcrest.Matcher<View> siblingMatcher) {
            this.siblingMatcher = siblingMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("(view.getParent() ").appendDescriptionOf(this.parentMatcher).appendText(" and has a sibling matching ").appendDescriptionOf(this.siblingMatcher).appendText(")");
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            ViewParent parent = view.getParent();
            if (!this.parentMatcher.matches((Object)parent)) {
                mismatchDescription.appendText("view.getParent() ");
                this.parentMatcher.describeMismatch((Object)parent, mismatchDescription);
                return false;
            }
            ViewGroup parentGroup = (ViewGroup)parent;
            if (parentGroup.getChildCount() == 1) {
                mismatchDescription.appendText("no siblings found");
                return false;
            }
            for (int i = 0; i < parentGroup.getChildCount(); ++i) {
                View child = parentGroup.getChildAt(i);
                if (view == child || !this.siblingMatcher.matches((Object)child)) continue;
                return true;
            }
            mismatchDescription.appendText("none of the ").appendValue((Object)(parentGroup.getChildCount() - 1)).appendText(" siblings match");
            return false;
        }
    }

    static final class IsActivatedMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final boolean isActivated;

        @RemoteMsgConstructor
        private IsActivatedMatcher(boolean isActivated) {
            this.isActivated = isActivated;
        }

        public void describeTo(Description description) {
            description.appendText("view.isActivated() is ").appendValue((Object)this.isActivated);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            boolean isActivated = view.isActivated();
            if (isActivated != this.isActivated) {
                mismatchDescription.appendText("view.isActivated() was ").appendValue((Object)isActivated);
                return false;
            }
            return true;
        }
    }

    static final class IsSelectedMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final boolean isSelected;

        @RemoteMsgConstructor
        private IsSelectedMatcher(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public void describeTo(Description description) {
            description.appendText("view.isSelected() is ").appendValue((Object)this.isSelected);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            boolean isSelected = view.isSelected();
            if (isSelected != this.isSelected) {
                mismatchDescription.appendText("view.isSelected() was ").appendValue((Object)isSelected);
                return false;
            }
            return true;
        }
    }

    static final class HasFocusMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final boolean hasFocus;

        @RemoteMsgConstructor
        private HasFocusMatcher(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }

        public void describeTo(Description description) {
            description.appendText("view.hasFocus() is ").appendValue((Object)this.hasFocus);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            boolean hasFocus = view.hasFocus();
            if (hasFocus != this.hasFocus) {
                mismatchDescription.appendText("view.hasFocus() is ").appendValue((Object)hasFocus);
                return false;
            }
            return true;
        }
    }

    static final class IsFocusedMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final boolean isFocused;

        @RemoteMsgConstructor
        private IsFocusedMatcher(boolean isFocused) {
            this.isFocused = isFocused;
        }

        public void describeTo(Description description) {
            description.appendText("view.isFocused() is ").appendValue((Object)this.isFocused);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            boolean isFocused = view.isFocused();
            if (isFocused != this.isFocused) {
                mismatchDescription.appendText("view.isFocused() was ").appendValue((Object)isFocused);
                return false;
            }
            return true;
        }
    }

    static final class IsFocusableMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final boolean isFocusable;

        @RemoteMsgConstructor
        private IsFocusableMatcher(boolean isFocusable) {
            this.isFocusable = isFocusable;
        }

        public void describeTo(Description description) {
            description.appendText("view.isFocusable() is ").appendValue((Object)this.isFocusable);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            boolean isFocusable = view.isFocusable();
            if (isFocusable != this.isFocusable) {
                mismatchDescription.appendText("view.isFocusable() was ").appendValue((Object)isFocusable);
                return false;
            }
            return true;
        }
    }

    static final class IsEnabledMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final boolean isEnabled;

        @RemoteMsgConstructor
        private IsEnabledMatcher(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public void describeTo(Description description) {
            description.appendText("view.isEnabled() is ").appendValue((Object)this.isEnabled);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            boolean isEnabled = view.isEnabled();
            if (isEnabled != this.isEnabled) {
                mismatchDescription.appendText("view.isEnabled() was ").appendValue((Object)isEnabled);
                return false;
            }
            return true;
        }
    }

    static final class IsDisplayingAtLeastMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        @VisibleForTesting
        final int areaPercentage;
        private final org.hamcrest.Matcher<View> visibilityMatchers = ViewMatchers.withEffectiveVisibility(Visibility.VISIBLE);

        @RemoteMsgConstructor
        private IsDisplayingAtLeastMatcher(int areaPercentage) {
            this.areaPercentage = areaPercentage;
        }

        public void describeTo(Description description) {
            description.appendText("(").appendDescriptionOf(this.visibilityMatchers).appendText(" and view.getGlobalVisibleRect() covers at least ").appendValue((Object)this.areaPercentage).appendText(" percent of the view's area)");
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            if (!this.visibilityMatchers.matches((Object)view)) {
                this.visibilityMatchers.describeMismatch((Object)view, mismatchDescription);
                return false;
            }
            Rect visibleParts = new Rect();
            boolean visibleAtAll = view.getGlobalVisibleRect(visibleParts);
            if (!visibleAtAll) {
                mismatchDescription.appendText("view was ").appendValue((Object)0).appendText(" percent visible to the user");
                return false;
            }
            Rect screen = this.getScreenWithoutStatusBarActionBar(view);
            float viewHeight = view.getHeight() > screen.height() ? (float)screen.height() : (float)view.getHeight();
            float viewWidth = view.getWidth() > screen.width() ? (float)screen.width() : (float)view.getWidth();
            viewHeight = Math.min((float)view.getHeight() * Math.abs(view.getScaleY()), (float)screen.height());
            viewWidth = Math.min((float)view.getWidth() * Math.abs(view.getScaleX()), (float)screen.width());
            double maxArea = viewHeight * viewWidth;
            double visibleArea = visibleParts.height() * visibleParts.width();
            int displayedPercentage = (int)(visibleArea / maxArea * 100.0);
            if (displayedPercentage < this.areaPercentage) {
                mismatchDescription.appendText("view was ").appendValue((Object)displayedPercentage).appendText(" percent visible to the user");
                return false;
            }
            return true;
        }

        private Rect getScreenWithoutStatusBarActionBar(View view) {
            DisplayMetrics m = new DisplayMetrics();
            ((WindowManager)view.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(m);
            int resourceId = view.getContext().getResources().getIdentifier("status_bar_height", "dimen", "android");
            int statusBarHeight = resourceId > 0 ? view.getContext().getResources().getDimensionPixelSize(resourceId) : 0;
            TypedValue tv = new TypedValue();
            int actionBarHeight = view.getContext().getTheme().resolveAttribute(16843499, tv, true) ? TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)view.getContext().getResources().getDisplayMetrics()) : 0;
            return new Rect(0, 0, m.widthPixels, m.heightPixels - (statusBarHeight + actionBarHeight));
        }
    }

    static final class IsDisplayedMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        private final org.hamcrest.Matcher<View> visibilityMatcher = ViewMatchers.withEffectiveVisibility(Visibility.VISIBLE);

        @RemoteMsgConstructor
        private IsDisplayedMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("(").appendDescriptionOf(this.visibilityMatcher).appendText(" and view.getGlobalVisibleRect() to return non-empty rectangle)");
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            if (!this.visibilityMatcher.matches((Object)view)) {
                this.visibilityMatcher.describeMismatch((Object)view, mismatchDescription);
                return false;
            }
            if (!view.getGlobalVisibleRect(new Rect())) {
                mismatchDescription.appendText("view.getGlobalVisibleRect() returned empty rectangle");
                return false;
            }
            return true;
        }
    }

    static final class WithClassNameMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        @VisibleForTesting
        final org.hamcrest.Matcher<String> classNameMatcher;

        @RemoteMsgConstructor
        private WithClassNameMatcher(org.hamcrest.Matcher<String> classNameMatcher) {
            this.classNameMatcher = classNameMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("view.getClass().getName() matches: ").appendDescriptionOf(this.classNameMatcher);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            String className = view.getClass().getName();
            if (!this.classNameMatcher.matches((Object)className)) {
                mismatchDescription.appendText("view.getClass().getName() ");
                this.classNameMatcher.describeMismatch((Object)className, mismatchDescription);
                return false;
            }
            return true;
        }
    }

    static final class IsAssignableFromMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final Class<?> clazz;

        @RemoteMsgConstructor
        private IsAssignableFromMatcher(@NonNull Class<?> clazz) {
            this.clazz = (Class)Checks.checkNotNull(clazz);
        }

        public void describeTo(Description description) {
            description.appendText("is assignable from class ").appendValue(this.clazz);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            if (!this.clazz.isAssignableFrom(view.getClass())) {
                mismatchDescription.appendText("view.getClass() was ").appendValue(view.getClass());
                return false;
            }
            return true;
        }
    }

    static final class WithTagKeyMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final int key;
        @RemoteMsgField(order=1)
        private final org.hamcrest.Matcher<?> objectMatcher;

        @RemoteMsgConstructor
        private WithTagKeyMatcher(int key, org.hamcrest.Matcher<?> objectMatcher) {
            this.key = key;
            this.objectMatcher = objectMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("view.getTag(" + this.key + ") ").appendDescriptionOf(this.objectMatcher);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            Object tag = view.getTag(this.key);
            if (!this.objectMatcher.matches(tag)) {
                mismatchDescription.appendText("view.getTag(" + this.key + ") ");
                this.objectMatcher.describeMismatch(tag, mismatchDescription);
                return false;
            }
            return true;
        }
    }

    static final class WithResourceNameMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<String> stringMatcher;

        @RemoteMsgConstructor
        private WithResourceNameMatcher(org.hamcrest.Matcher<String> stringMatcher) {
            this.stringMatcher = stringMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("view.getId()'s resource name should match ").appendDescriptionOf(this.stringMatcher);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            int id = view.getId();
            if (id == -1) {
                mismatchDescription.appendText("view.getId() was View.NO_ID");
                return false;
            }
            if (view.getResources() == null) {
                mismatchDescription.appendText("view.getResources() was null, can't resolve resource name");
                return false;
            }
            if (ViewMatchers.isViewIdGenerated(id)) {
                mismatchDescription.appendText("view.getId() was generated by a call to View.generateViewId()");
                return false;
            }
            String resourceName = ViewMatchers.safeGetResourceEntryName(view.getResources(), view.getId());
            if (resourceName == null) {
                mismatchDescription.appendText("view.getId() was ").appendValue((Object)id).appendText(" which fails to resolve resource name");
                return false;
            }
            if (!this.stringMatcher.matches((Object)resourceName)) {
                mismatchDescription.appendText("view.getId() was <").appendText(resourceName).appendText(">");
                return false;
            }
            return true;
        }
    }

    static final class WithTextMatcher
    extends BoundedDiagnosingMatcher<View, TextView> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<String> stringMatcher;

        @RemoteMsgConstructor
        private WithTextMatcher(org.hamcrest.Matcher<String> stringMatcher) {
            super(TextView.class);
            this.stringMatcher = stringMatcher;
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("view.getText() with or without transformation to match: ");
            this.stringMatcher.describeTo(description);
        }

        @Override
        protected boolean matchesSafely(TextView textView, Description mismatchDescription) {
            String text = textView.getText().toString();
            if (this.stringMatcher.matches((Object)text)) {
                return true;
            }
            mismatchDescription.appendText("view.getText() was ").appendValue((Object)text);
            if (textView.getTransformationMethod() != null) {
                CharSequence transformedText = textView.getTransformationMethod().getTransformation((CharSequence)text, (View)textView);
                mismatchDescription.appendText(" transformed text was ").appendValue((Object)transformedText);
                if (transformedText != null) {
                    return this.stringMatcher.matches((Object)transformedText.toString());
                }
            }
            return false;
        }
    }

    static final class WithIdMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        @VisibleForTesting
        org.hamcrest.Matcher<Integer> viewIdMatcher;
        private Resources resources;

        @RemoteMsgConstructor
        private WithIdMatcher(org.hamcrest.Matcher<Integer> integerMatcher) {
            this.viewIdMatcher = integerMatcher;
        }

        public void describeTo(Description description) {
            String id = this.getViewIdString(this.viewIdMatcher.toString());
            description.appendText("view.getId() ").appendText(id);
        }

        protected boolean matchesSafely(View view, Description mismatchDescription) {
            this.resources = view.getResources();
            boolean matches = this.viewIdMatcher.matches((Object)view.getId());
            if (!matches && !(mismatchDescription instanceof Description.NullDescription)) {
                mismatchDescription.appendText("view.getId() was ").appendText(this.getViewIdString("<" + view.getId() + ">"));
            }
            return matches;
        }

        private String getViewIdString(String idDescription) {
            Matcher matcher = RESOURCE_ID_PATTERN.matcher(idDescription);
            StringBuffer buffer = new StringBuffer(idDescription.length());
            while (matcher.find()) {
                if (this.resources == null) continue;
                String idString = matcher.group();
                int id = Integer.parseInt(idString);
                String resourceName = ViewMatchers.safeGetResourceName(this.resources, id);
                if (resourceName != null) {
                    matcher.appendReplacement(buffer, idString + "/" + resourceName);
                    continue;
                }
                matcher.appendReplacement(buffer, String.format(Locale.ROOT, "%s (resource name not found)", idString));
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
    }

    public static enum Visibility {
        VISIBLE(0),
        INVISIBLE(4),
        GONE(8);

        private final int value;

        private Visibility(int value) {
            this.value = value;
        }

        public static Visibility forViewVisibility(View view) {
            return Visibility.forViewVisibility(view.getVisibility());
        }

        public static Visibility forViewVisibility(int visibility) {
            switch (visibility) {
                case 0: {
                    return VISIBLE;
                }
                case 4: {
                    return INVISIBLE;
                }
                case 8: {
                    return GONE;
                }
            }
            throw new IllegalArgumentException("Invalid visibility value <" + visibility + ">");
        }

        public int getValue() {
            return this.value;
        }
    }
}

