/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.content.res.Resources;
import android.preference.Preference;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public final class PreferenceMatchers {
    private PreferenceMatchers() {
    }

    public static Matcher<Preference> withSummary(final int resourceId) {
        return new TypeSafeMatcher<Preference>(){
            private String resourceName = null;
            private String expectedText = null;

            public void describeTo(Description description) {
                description.appendText(" with summary string from resource id: ");
                description.appendValue((Object)resourceId);
                if (null != this.resourceName) {
                    description.appendText("[");
                    description.appendText(this.resourceName);
                    description.appendText("]");
                }
                if (null != this.expectedText) {
                    description.appendText(" value: ");
                    description.appendText(this.expectedText);
                }
            }

            public boolean matchesSafely(Preference preference) {
                if (null == this.expectedText) {
                    try {
                        this.expectedText = preference.getContext().getResources().getString(resourceId);
                        this.resourceName = preference.getContext().getResources().getResourceEntryName(resourceId);
                    }
                    catch (Resources.NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
                if (null != this.expectedText) {
                    return this.expectedText.equals(preference.getSummary().toString());
                }
                return false;
            }
        };
    }

    public static Matcher<Preference> withSummaryText(String summary) {
        return PreferenceMatchers.withSummaryText((Matcher<String>)Matchers.is((Object)summary));
    }

    public static Matcher<Preference> withSummaryText(final Matcher<String> summaryMatcher) {
        return new TypeSafeMatcher<Preference>(){

            public void describeTo(Description description) {
                description.appendText(" a preference with summary matching: ");
                summaryMatcher.describeTo(description);
            }

            public boolean matchesSafely(Preference pref) {
                String summary = pref.getSummary().toString();
                return summaryMatcher.matches((Object)summary);
            }
        };
    }

    public static Matcher<Preference> withTitle(final int resourceId) {
        return new TypeSafeMatcher<Preference>(){
            private String resourceName = null;
            private String expectedText = null;

            public void describeTo(Description description) {
                description.appendText(" with title string from resource id: ");
                description.appendValue((Object)resourceId);
                if (null != this.resourceName) {
                    description.appendText("[");
                    description.appendText(this.resourceName);
                    description.appendText("]");
                }
                if (null != this.expectedText) {
                    description.appendText(" value: ");
                    description.appendText(this.expectedText);
                }
            }

            public boolean matchesSafely(Preference preference) {
                if (null == this.expectedText) {
                    try {
                        this.expectedText = preference.getContext().getResources().getString(resourceId);
                        this.resourceName = preference.getContext().getResources().getResourceEntryName(resourceId);
                    }
                    catch (Resources.NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
                if (null != this.expectedText && preference.getTitle() != null) {
                    return this.expectedText.equals(preference.getTitle().toString());
                }
                return false;
            }
        };
    }

    public static Matcher<Preference> withTitleText(String title) {
        return PreferenceMatchers.withTitleText((Matcher<String>)Matchers.is((Object)title));
    }

    public static Matcher<Preference> withTitleText(final Matcher<String> titleMatcher) {
        return new TypeSafeMatcher<Preference>(){

            public void describeTo(Description description) {
                description.appendText(" a preference with title matching: ");
                titleMatcher.describeTo(description);
            }

            public boolean matchesSafely(Preference pref) {
                if (pref.getTitle() == null) {
                    return false;
                }
                String title = pref.getTitle().toString();
                return titleMatcher.matches((Object)title);
            }
        };
    }

    public static Matcher<Preference> isEnabled() {
        return new TypeSafeMatcher<Preference>(){

            public void describeTo(Description description) {
                description.appendText(" is an enabled preference");
            }

            public boolean matchesSafely(Preference pref) {
                return pref.isEnabled();
            }
        };
    }

    public static Matcher<Preference> withKey(String key) {
        return PreferenceMatchers.withKey((Matcher<String>)Matchers.is((Object)key));
    }

    public static Matcher<Preference> withKey(final Matcher<String> keyMatcher) {
        return new TypeSafeMatcher<Preference>(){

            public void describeTo(Description description) {
                description.appendText(" preference with key matching: ");
                keyMatcher.describeTo(description);
            }

            public boolean matchesSafely(Preference pref) {
                return keyMatcher.matches((Object)pref.getKey());
            }
        };
    }
}

