/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public final class HasBackgroundMatcher
extends TypeSafeMatcher<View> {
    private static final String TAG = "HasBackgroundMatcher";
    private final int drawableId;

    public HasBackgroundMatcher(int drawableId) {
        this.drawableId = drawableId;
    }

    protected boolean matchesSafely(View view) {
        return HasBackgroundMatcher.assertDrawable(view.getBackground(), this.drawableId, view);
    }

    public void describeTo(Description description) {
        description.appendText("has background with drawable ID: " + this.drawableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean assertDrawable(Drawable actual, int expectedId, View v) {
        if (null == actual || !(actual instanceof BitmapDrawable)) {
            return false;
        }
        Bitmap expectedBitmap = null;
        try {
            expectedBitmap = BitmapFactory.decodeResource((Resources)v.getContext().getResources(), (int)expectedId);
            boolean bl = ((BitmapDrawable)actual).getBitmap().sameAs(expectedBitmap);
            return bl;
        }
        finally {
            if (expectedBitmap != null) {
                expectedBitmap.recycle();
                expectedBitmap = null;
            }
        }
    }
}

