/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import androidx.test.espresso.matcher.BoundedMatcher;
import androidx.test.internal.util.Checks;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;

public final class CursorMatchers {
    private static final int COLUMN_NOT_FOUND = -1;
    private static final int MULTIPLE_COLUMNS_FOUND = -2;
    private static final int USE_COLUMN_PICKER = -3;
    private static final CursorDataRetriever<byte[]> BLOB_MATCHER_APPLIER = new CursorDataRetriever<byte[]>(){

        public void describeTo(Description description) {
            description.appendText("with Blob");
        }

        @Override
        public byte[] getData(Cursor cursor, int chosenColumn) {
            return cursor.getBlob(chosenColumn);
        }
    };
    private static final CursorDataRetriever<Long> LONG_MATCHER_APPLIER = new CursorDataRetriever<Long>(){

        public void describeTo(Description description) {
            description.appendText("with Long");
        }

        @Override
        public Long getData(Cursor cursor, int chosenColumn) {
            return cursor.getLong(chosenColumn);
        }
    };
    private static final CursorDataRetriever<Short> SHORT_MATCHER_APPLIER = new CursorDataRetriever<Short>(){

        public void describeTo(Description description) {
            description.appendText("with Short");
        }

        @Override
        public Short getData(Cursor cursor, int chosenColumn) {
            return cursor.getShort(chosenColumn);
        }
    };
    private static final CursorDataRetriever<Integer> INT_MATCHER_APPLIER = new CursorDataRetriever<Integer>(){

        public void describeTo(Description description) {
            description.appendText("with Int");
        }

        @Override
        public Integer getData(Cursor cursor, int chosenColumn) {
            return cursor.getInt(chosenColumn);
        }
    };
    private static final CursorDataRetriever<Float> FLOAT_MATCHER_APPLIER = new CursorDataRetriever<Float>(){

        public void describeTo(Description description) {
            description.appendText("with Float");
        }

        @Override
        public Float getData(Cursor cursor, int chosenColumn) {
            return Float.valueOf(cursor.getFloat(chosenColumn));
        }
    };
    private static final CursorDataRetriever<Double> DOUBLE_MATCHER_APPLIER = new CursorDataRetriever<Double>(){

        public void describeTo(Description description) {
            description.appendText("with Double");
        }

        @Override
        public Double getData(Cursor cursor, int chosenColumn) {
            return cursor.getDouble(chosenColumn);
        }
    };
    private static final CursorDataRetriever<String> STRING_MATCHER_APPLIER = new CursorDataRetriever<String>(){

        public void describeTo(Description description) {
            description.appendText("with String");
        }

        @Override
        public String getData(Cursor cursor, int chosenColumn) {
            return cursor.getString(chosenColumn);
        }
    };

    private CursorMatchers() {
    }

    private static int findColumnIndex(Matcher<String> nameMatcher, Cursor cursor) {
        int result = -1;
        String[] columnNames = cursor.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            String column = columnNames[i];
            if (!nameMatcher.matches((Object)column)) continue;
            if (result == -1) {
                result = i;
                continue;
            }
            result = -2;
            break;
        }
        return result;
    }

    public static CursorMatcher withRowShort(int columnIndex, short value) {
        return CursorMatchers.withRowShort(columnIndex, (Matcher<Short>)Matchers.is((Object)value));
    }

    public static CursorMatcher withRowShort(int columnIndex, Matcher<Short> valueMatcher) {
        return new CursorMatcher(columnIndex, valueMatcher, SHORT_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowShort(String columnName, short value) {
        return CursorMatchers.withRowShort(columnName, (Matcher<Short>)Matchers.is((Object)value));
    }

    public static CursorMatcher withRowShort(String columnName, Matcher<Short> valueMatcher) {
        return CursorMatchers.withRowShort((Matcher<String>)Matchers.is((Object)columnName), valueMatcher);
    }

    public static CursorMatcher withRowShort(Matcher<String> columnNameMatcher, Matcher<Short> valueMatcher) {
        return new CursorMatcher(columnNameMatcher, valueMatcher, SHORT_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowInt(int columnIndex, int value) {
        return CursorMatchers.withRowInt(columnIndex, (Matcher<Integer>)Matchers.is((Object)value));
    }

    public static CursorMatcher withRowInt(int columnIndex, Matcher<Integer> valueMatcher) {
        return new CursorMatcher(columnIndex, valueMatcher, INT_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowInt(String columnName, int value) {
        return CursorMatchers.withRowInt(columnName, (Matcher<Integer>)Matchers.is((Object)value));
    }

    public static CursorMatcher withRowInt(String columnName, Matcher<Integer> valueMatcher) {
        return CursorMatchers.withRowInt((Matcher<String>)Matchers.is((Object)columnName), valueMatcher);
    }

    public static CursorMatcher withRowInt(Matcher<String> columnNameMatcher, Matcher<Integer> valueMatcher) {
        return new CursorMatcher(columnNameMatcher, valueMatcher, INT_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowLong(int columnIndex, long value) {
        return CursorMatchers.withRowLong(columnIndex, (Matcher<Long>)Matchers.is((Object)value));
    }

    public static CursorMatcher withRowLong(int columnIndex, Matcher<Long> valueMatcher) {
        return new CursorMatcher(columnIndex, valueMatcher, LONG_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowLong(String columnName, long value) {
        return CursorMatchers.withRowLong(columnName, (Matcher<Long>)Matchers.is((Object)value));
    }

    public static CursorMatcher withRowLong(String columnName, Matcher<Long> valueMatcher) {
        return CursorMatchers.withRowLong((Matcher<String>)Matchers.is((Object)columnName), valueMatcher);
    }

    public static CursorMatcher withRowLong(Matcher<String> columnNameMatcher, Matcher<Long> valueMatcher) {
        return new CursorMatcher(columnNameMatcher, valueMatcher, LONG_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowFloat(int columnIndex, float value) {
        return CursorMatchers.withRowFloat(columnIndex, (Matcher<Float>)Matchers.is((Object)Float.valueOf(value)));
    }

    public static CursorMatcher withRowFloat(int columnIndex, Matcher<Float> valueMatcher) {
        return new CursorMatcher(columnIndex, valueMatcher, FLOAT_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowFloat(String columnName, float value) {
        return CursorMatchers.withRowFloat(columnName, (Matcher<Float>)Matchers.is((Object)Float.valueOf(value)));
    }

    public static CursorMatcher withRowFloat(String columnName, Matcher<Float> valueMatcher) {
        return CursorMatchers.withRowFloat((Matcher<String>)Matchers.is((Object)columnName), valueMatcher);
    }

    public static CursorMatcher withRowFloat(Matcher<String> columnNameMatcher, Matcher<Float> valueMatcher) {
        return new CursorMatcher(columnNameMatcher, valueMatcher, FLOAT_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowDouble(int columnIndex, double value) {
        return CursorMatchers.withRowDouble(columnIndex, (Matcher<Double>)Matchers.is((Object)value));
    }

    public static CursorMatcher withRowDouble(int columnIndex, Matcher<Double> valueMatcher) {
        return new CursorMatcher(columnIndex, valueMatcher, DOUBLE_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowDouble(String columnName, double value) {
        return CursorMatchers.withRowDouble(columnName, (Matcher<Double>)Matchers.is((Object)value));
    }

    public static CursorMatcher withRowDouble(String columnName, Matcher<Double> valueMatcher) {
        return CursorMatchers.withRowDouble((Matcher<String>)Matchers.is((Object)columnName), valueMatcher);
    }

    public static CursorMatcher withRowDouble(Matcher<String> columnNameMatcher, Matcher<Double> valueMatcher) {
        return new CursorMatcher(columnNameMatcher, valueMatcher, DOUBLE_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowString(int columnIndex, String value) {
        return CursorMatchers.withRowString(columnIndex, (Matcher<String>)Matchers.is((Object)value));
    }

    public static CursorMatcher withRowString(int columnIndex, Matcher<String> valueMatcher) {
        return new CursorMatcher(columnIndex, valueMatcher, STRING_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowString(String columnName, String value) {
        return CursorMatchers.withRowString((Matcher<String>)Matchers.is((Object)columnName), (Matcher<String>)Matchers.is((Object)value));
    }

    public static CursorMatcher withRowString(String columnName, Matcher<String> valueMatcher) {
        return CursorMatchers.withRowString((Matcher<String>)Matchers.is((Object)columnName), valueMatcher);
    }

    public static CursorMatcher withRowString(Matcher<String> columnPicker, Matcher<String> valueMatcher) {
        return new CursorMatcher(columnPicker, valueMatcher, STRING_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowBlob(int columnIndex, byte[] value) {
        return CursorMatchers.withRowBlob(columnIndex, (Matcher<byte[]>)Matchers.is((Object)value));
    }

    public static CursorMatcher withRowBlob(int columnIndex, Matcher<byte[]> valueMatcher) {
        return new CursorMatcher(columnIndex, valueMatcher, BLOB_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowBlob(String columnName, byte[] value) {
        return CursorMatchers.withRowBlob((Matcher<String>)Matchers.is((Object)columnName), (Matcher<byte[]>)Matchers.is((Object)value));
    }

    public static CursorMatcher withRowBlob(String columnName, Matcher<byte[]> valueMatcher) {
        return CursorMatchers.withRowBlob((Matcher<String>)Matchers.is((Object)columnName), valueMatcher);
    }

    public static CursorMatcher withRowBlob(Matcher<String> columnPicker, Matcher<byte[]> valueMatcher) {
        return new CursorMatcher(columnPicker, valueMatcher, BLOB_MATCHER_APPLIER);
    }

    private static interface CursorDataRetriever<T>
    extends SelfDescribing {
        public T getData(Cursor var1, int var2);
    }

    public static class CursorMatcher
    extends BoundedMatcher<Object, Cursor> {
        private final int columnIndex;
        private final Matcher<String> columnNameMatcher;
        private final Matcher<?> valueMatcher;
        private final CursorDataRetriever<?> cursorDataRetriever;
        private boolean checkColumns = false;

        private CursorMatcher(int columnIndex, Matcher<?> valueMatcher, CursorDataRetriever<?> cursorDataRetriever) {
            super(Cursor.class);
            Checks.checkArgument((columnIndex >= 0 ? 1 : 0) != 0);
            this.columnIndex = columnIndex;
            this.valueMatcher = (Matcher)Checks.checkNotNull(valueMatcher);
            this.cursorDataRetriever = (CursorDataRetriever)Checks.checkNotNull(cursorDataRetriever);
            this.columnNameMatcher = null;
        }

        private CursorMatcher(Matcher<String> columnPicker, Matcher<?> valueMatcher, CursorDataRetriever<?> cursorDataRetriever) {
            super(Cursor.class);
            this.columnNameMatcher = (Matcher)Checks.checkNotNull(columnPicker);
            this.valueMatcher = (Matcher)Checks.checkNotNull(valueMatcher);
            this.cursorDataRetriever = (CursorDataRetriever)Checks.checkNotNull(cursorDataRetriever);
            this.columnIndex = -3;
        }

        @Override
        public boolean matchesSafely(Cursor cursor) {
            int chosenColumn = this.columnIndex;
            StringDescription mismatchDescription = new StringDescription();
            if (chosenColumn < 0 && (chosenColumn = CursorMatchers.findColumnIndex((Matcher<String>)this.columnNameMatcher, cursor)) < 0) {
                if (chosenColumn == -2) {
                    mismatchDescription.appendText("Multiple columns in ").appendValue((Object)cursor.getColumnNames()).appendText(" match ").appendDescriptionOf(this.columnNameMatcher);
                } else {
                    mismatchDescription.appendText("Couldn't find column in ").appendValue((Object)cursor.getColumnNames()).appendText(" matching ").appendDescriptionOf(this.columnNameMatcher);
                }
                if (this.checkColumns) {
                    throw new IllegalArgumentException(mismatchDescription.toString());
                }
                return false;
            }
            try {
                Object data = this.cursorDataRetriever.getData(cursor, chosenColumn);
                boolean result = this.valueMatcher.matches(data);
                if (!result) {
                    mismatchDescription.appendText("value at column ").appendValue((Object)chosenColumn).appendText(" ");
                    this.valueMatcher.describeMismatch(data, (Description)mismatchDescription);
                }
                return result;
            }
            catch (CursorIndexOutOfBoundsException e) {
                mismatchDescription.appendText("Column index ").appendValue((Object)chosenColumn).appendText(" is invalid");
                if (this.checkColumns) {
                    throw new IllegalArgumentException(mismatchDescription.toString(), e);
                }
                return false;
            }
        }

        public void describeTo(Description description) {
            description.appendText("an instance of android.database.Cursor and Rows with column: ");
            if (this.columnIndex < 0) {
                this.columnNameMatcher.describeTo(description);
            } else {
                description.appendText("index = " + this.columnIndex);
            }
            description.appendText(" ").appendDescriptionOf(this.cursorDataRetriever).appendText(" matching ").appendDescriptionOf(this.valueMatcher);
        }

        public CursorMatcher withStrictColumnChecks(boolean checkColumns) {
            this.checkColumns = checkColumns;
            return this;
        }
    }
}

