/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import androidx.test.internal.util.Checks;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public abstract class BoundedMatcher<T, S extends T>
extends BaseMatcher<T> {
    private final Class<?> expectedType;
    private final Class<?>[] interfaceTypes;

    public BoundedMatcher(Class<? extends S> expectedType) {
        this.expectedType = (Class)Checks.checkNotNull(expectedType);
        this.interfaceTypes = new Class[0];
    }

    public BoundedMatcher(Class<?> expectedType, Class<?> interfaceType1, Class<?> ... otherInterfaces) {
        this.expectedType = (Class)Checks.checkNotNull(expectedType);
        Checks.checkNotNull(otherInterfaces);
        int interfaceCount = otherInterfaces.length + 1;
        this.interfaceTypes = new Class[interfaceCount];
        this.interfaceTypes[0] = (Class)Checks.checkNotNull(interfaceType1);
        Checks.checkArgument((boolean)interfaceType1.isInterface());
        int interfaceTypeIdx = 1;
        for (Class<?> intfType : otherInterfaces) {
            this.interfaceTypes[interfaceTypeIdx] = (Class)Checks.checkNotNull(intfType);
            Checks.checkArgument((boolean)intfType.isInterface());
            ++interfaceTypeIdx;
        }
    }

    protected abstract boolean matchesSafely(S var1);

    public final boolean matches(Object item) {
        if (item == null) {
            return false;
        }
        if (this.expectedType.isInstance(item)) {
            for (Class<?> intfType : this.interfaceTypes) {
                if (intfType.isInstance(item)) continue;
                return false;
            }
            return this.matchesSafely(item);
        }
        return false;
    }

    public void describeMismatch(Object item, Description description) {
        if (item == null) {
            description.appendText("item was null");
            return;
        }
        if (!this.expectedType.isInstance(item)) {
            description.appendText("item does not extend ").appendText(this.expectedType.getName());
            return;
        }
        for (Class<?> intfType : this.interfaceTypes) {
            if (intfType.isInstance(item)) continue;
            description.appendText("item does not implement ").appendText(intfType.getName());
            return;
        }
    }
}

